/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.VerticalTableLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VerticalTableLoggerMode", generator="Immutables")
@Immutable
public final class ImmutableVerticalTableLoggerMode
extends VerticalTableLoggerMode {
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    private final String componentName;
    private final boolean useLocalTimeZone;
    private final String componentLabel;
    private final VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVerticalTableLoggerMode(Builder builder) {
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        if (builder.componentName != null) {
            this.initShim.componentName(builder.componentName);
        }
        if (builder.useLocalTimeZoneIsSet()) {
            this.initShim.useLocalTimeZone(builder.useLocalTimeZone);
        }
        if (builder.componentLabel != null) {
            this.initShim.componentLabel(builder.componentLabel);
        }
        if (builder.verticalTitlePrintOption != null) {
            this.initShim.verticalTitlePrintOption(builder.verticalTitlePrintOption);
        }
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.componentName = this.initShim.componentName();
        this.useLocalTimeZone = this.initShim.useLocalTimeZone();
        this.componentLabel = this.initShim.componentLabel();
        this.verticalTitlePrintOption = this.initShim.verticalTitlePrintOption();
        this.initShim = null;
    }

    private ImmutableVerticalTableLoggerMode(ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, String componentName, boolean useLocalTimeZone, String componentLabel, VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption) {
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.initShim.componentName(componentName);
        this.initShim.useLocalTimeZone(useLocalTimeZone);
        this.initShim.componentLabel(componentLabel);
        this.initShim.verticalTitlePrintOption(verticalTitlePrintOption);
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.componentName = this.initShim.componentName();
        this.useLocalTimeZone = this.initShim.useLocalTimeZone();
        this.componentLabel = this.initShim.componentLabel();
        this.verticalTitlePrintOption = this.initShim.verticalTitlePrintOption();
        this.initShim = null;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    public String componentName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.componentName() : this.componentName;
    }

    @Override
    public boolean useLocalTimeZone() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useLocalTimeZone() : this.useLocalTimeZone;
    }

    @Override
    public String componentLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.componentLabel() : this.componentLabel;
    }

    @Override
    public VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verticalTitlePrintOption() : this.verticalTitlePrintOption;
    }

    public final ImmutableVerticalTableLoggerMode withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableVerticalTableLoggerMode((ImmutableList<Component.SchemaFieldDescription>)newValue, this.componentName, this.useLocalTimeZone, this.componentLabel, this.verticalTitlePrintOption);
    }

    public final ImmutableVerticalTableLoggerMode withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableVerticalTableLoggerMode((ImmutableList<Component.SchemaFieldDescription>)newValue, this.componentName, this.useLocalTimeZone, this.componentLabel, this.verticalTitlePrintOption);
    }

    public final ImmutableVerticalTableLoggerMode withComponentName(String value) {
        String newValue = Objects.requireNonNull(value, "componentName");
        if (this.componentName.equals(newValue)) {
            return this;
        }
        return new ImmutableVerticalTableLoggerMode(this.schemaFieldDescriptions, newValue, this.useLocalTimeZone, this.componentLabel, this.verticalTitlePrintOption);
    }

    public final ImmutableVerticalTableLoggerMode withUseLocalTimeZone(boolean value) {
        if (this.useLocalTimeZone == value) {
            return this;
        }
        return new ImmutableVerticalTableLoggerMode(this.schemaFieldDescriptions, this.componentName, value, this.componentLabel, this.verticalTitlePrintOption);
    }

    public final ImmutableVerticalTableLoggerMode withComponentLabel(String value) {
        String newValue = Objects.requireNonNull(value, "componentLabel");
        if (this.componentLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableVerticalTableLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, newValue, this.verticalTitlePrintOption);
    }

    public final ImmutableVerticalTableLoggerMode withVerticalTitlePrintOption(VerticalTableLoggerMode.VerticalTitlePrintOptions value) {
        VerticalTableLoggerMode.VerticalTitlePrintOptions newValue = Objects.requireNonNull(value, "verticalTitlePrintOption");
        if (this.verticalTitlePrintOption == newValue) {
            return this;
        }
        return new ImmutableVerticalTableLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, this.componentLabel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerticalTableLoggerMode && this.equalTo(0, (ImmutableVerticalTableLoggerMode)another);
    }

    private boolean equalTo(int synthetic, ImmutableVerticalTableLoggerMode another) {
        return this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && this.componentName.equals(another.componentName) && this.useLocalTimeZone == another.useLocalTimeZone && this.componentLabel.equals(another.componentLabel) && this.verticalTitlePrintOption.equals((Object)another.verticalTitlePrintOption);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + this.componentName.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.useLocalTimeZone);
        h += (h << 5) + this.componentLabel.hashCode();
        h += (h << 5) + this.verticalTitlePrintOption.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VerticalTableLoggerMode").omitNullValues().add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("componentName", (Object)this.componentName).add("useLocalTimeZone", this.useLocalTimeZone).add("componentLabel", (Object)this.componentLabel).add("verticalTitlePrintOption", (Object)this.verticalTitlePrintOption).toString();
    }

    public static ImmutableVerticalTableLoggerMode copyOf(VerticalTableLoggerMode instance) {
        if (instance instanceof ImmutableVerticalTableLoggerMode) {
            return (ImmutableVerticalTableLoggerMode)instance;
        }
        return ImmutableVerticalTableLoggerMode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VerticalTableLoggerMode", generator="Immutables")
    private final class InitShim {
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte componentNameBuildStage = 0;
        private String componentName;
        private byte useLocalTimeZoneBuildStage = 0;
        private boolean useLocalTimeZone;
        private byte componentLabelBuildStage = 0;
        private String componentLabel;
        private byte verticalTitlePrintOptionBuildStage = 0;
        private VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption;

        private InitShim() {
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableVerticalTableLoggerMode.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableVerticalTableLoggerMode.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        String componentName() {
            if (this.componentNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.componentNameBuildStage == 0) {
                this.componentNameBuildStage = (byte)-1;
                this.componentName = Objects.requireNonNull(ImmutableVerticalTableLoggerMode.super.componentName(), "componentName");
                this.componentNameBuildStage = 1;
            }
            return this.componentName;
        }

        void componentName(String componentName) {
            this.componentName = componentName;
            this.componentNameBuildStage = 1;
        }

        boolean useLocalTimeZone() {
            if (this.useLocalTimeZoneBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useLocalTimeZoneBuildStage == 0) {
                this.useLocalTimeZoneBuildStage = (byte)-1;
                this.useLocalTimeZone = ImmutableVerticalTableLoggerMode.super.useLocalTimeZone();
                this.useLocalTimeZoneBuildStage = 1;
            }
            return this.useLocalTimeZone;
        }

        void useLocalTimeZone(boolean useLocalTimeZone) {
            this.useLocalTimeZone = useLocalTimeZone;
            this.useLocalTimeZoneBuildStage = 1;
        }

        String componentLabel() {
            if (this.componentLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.componentLabelBuildStage == 0) {
                this.componentLabelBuildStage = (byte)-1;
                this.componentLabel = Objects.requireNonNull(ImmutableVerticalTableLoggerMode.super.componentLabel(), "componentLabel");
                this.componentLabelBuildStage = 1;
            }
            return this.componentLabel;
        }

        void componentLabel(String componentLabel) {
            this.componentLabel = componentLabel;
            this.componentLabelBuildStage = 1;
        }

        VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption() {
            if (this.verticalTitlePrintOptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verticalTitlePrintOptionBuildStage == 0) {
                this.verticalTitlePrintOptionBuildStage = (byte)-1;
                this.verticalTitlePrintOption = Objects.requireNonNull(ImmutableVerticalTableLoggerMode.super.verticalTitlePrintOption(), "verticalTitlePrintOption");
                this.verticalTitlePrintOptionBuildStage = 1;
            }
            return this.verticalTitlePrintOption;
        }

        void verticalTitlePrintOption(VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption) {
            this.verticalTitlePrintOption = verticalTitlePrintOption;
            this.verticalTitlePrintOptionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.componentNameBuildStage == -1) {
                attributes.add("componentName");
            }
            if (this.useLocalTimeZoneBuildStage == -1) {
                attributes.add("useLocalTimeZone");
            }
            if (this.componentLabelBuildStage == -1) {
                attributes.add("componentLabel");
            }
            if (this.verticalTitlePrintOptionBuildStage == -1) {
                attributes.add("verticalTitlePrintOption");
            }
            return "Cannot build VerticalTableLoggerMode, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="VerticalTableLoggerMode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_USE_LOCAL_TIME_ZONE = 1L;
        private long optBits;
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private String componentName;
        private boolean useLocalTimeZone;
        @Nullable
        private String componentLabel;
        @Nullable
        private VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(VerticalTableLoggerMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WithLoggerMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Component.WithSchemaDescription instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
            }
            if (object instanceof VerticalTableLoggerMode) {
                instance = (VerticalTableLoggerMode)object;
                if ((bits & 1L) == 0L) {
                    this.useLocalTimeZone(instance.useLocalTimeZone());
                    bits |= 1L;
                }
                this.verticalTitlePrintOption(instance.verticalTitlePrintOption());
                if ((bits & 2L) == 0L) {
                    this.componentName(instance.componentName());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
                this.componentLabel(instance.componentLabel());
            }
            if (object instanceof WithLoggerMode) {
                instance = (WithLoggerMode)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.useLocalTimeZone(instance.useLocalTimeZone());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.componentName(instance.componentName());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder componentName(String componentName) {
            this.componentName = Objects.requireNonNull(componentName, "componentName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useLocalTimeZone(boolean useLocalTimeZone) {
            this.useLocalTimeZone = useLocalTimeZone;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder componentLabel(String componentLabel) {
            this.componentLabel = Objects.requireNonNull(componentLabel, "componentLabel");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder verticalTitlePrintOption(VerticalTableLoggerMode.VerticalTitlePrintOptions verticalTitlePrintOption) {
            this.verticalTitlePrintOption = Objects.requireNonNull(verticalTitlePrintOption, "verticalTitlePrintOption");
            return this;
        }

        public ImmutableVerticalTableLoggerMode build() {
            return new ImmutableVerticalTableLoggerMode(this);
        }

        private boolean useLocalTimeZoneIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

