/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.immutables.value.Value;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.util.TLogRowUtils;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.util.TableFormatLogger;

@Value.Immutable
public abstract class TableLoggerMode
implements WithLoggerMode {
    @Override
    public String log(Row recordValue) {
        List<StructField> fieldList = Arrays.asList(recordValue.schema().fields());
        String[] columnsNameArray = TLogRowUtils.getColumnsNameArray(fieldList);
        TableFormatLogger tableFormatLogger = new TableFormatLogger();
        tableFormatLogger.setTableName(this.componentName());
        tableFormatLogger.setNbColumns(columnsNameArray.length);
        tableFormatLogger.addRow(columnsNameArray);
        String[] rowArray = new String[columnsNameArray.length];
        recordValue.schema().foreach(structField -> {
            if (recordValue.getAs(structField.name()) != null) {
                rowArray[recordValue.fieldIndex((String)structField.name())] = this.getFormattedValue(recordValue, (StructField)structField);
            }
            return true;
        });
        tableFormatLogger.addRow(rowArray);
        return Optional.of(new String(tableFormatLogger.format().toString().getBytes(StandardCharsets.UTF_8), Charset.defaultCharset())).orElse(new String("".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String log(Dataset<Row> ds) {
        List<StructField> fields = Arrays.asList(ds.schema().fields());
        String[] columnNames = TLogRowUtils.getColumnsNameArray(fields);
        TableFormatLogger tableFormatLogger = new TableFormatLogger();
        tableFormatLogger.setTableName(this.componentName());
        tableFormatLogger.setNbColumns(columnNames.length);
        tableFormatLogger.addRow(columnNames);
        String[] rows = new String[columnNames.length];
        for (Row row : ds.collectAsList()) {
            ds.schema().foreach(field -> {
                if (row.getAs(field.name()) != null) {
                    rows[row.fieldIndex((String)field.name())] = this.getFormattedValue(row, (StructField)field);
                }
                return true;
            });
            tableFormatLogger.addRow(Arrays.copyOf(rows, rows.length));
        }
        return Optional.of(new String(tableFormatLogger.format().toString().getBytes(StandardCharsets.UTF_8), Charset.defaultCharset())).orElse(new String("".getBytes(StandardCharsets.UTF_8)));
    }
}

