/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.tlogrow.TLogRowCastUtils;
import routines.system.FormatterUtils;

public interface WithLoggerMode
extends Component.WithSchemaDescription {
    @Value.Default
    default public String componentName() {
        return "tLogRow";
    }

    @Value.Default
    default public boolean useLocalTimeZone() {
        return false;
    }

    @Value.Default
    default public String getFormattedValue(Row recordValue, StructField field) {
        Optional<Component.SchemaFieldDescription> schemaFieldDescriptionOptional = Optional.ofNullable((Component.SchemaFieldDescription)this.getSchemaFieldDescriptionsMap().get(field.name()));
        Object object = recordValue.getAs(field.name());
        if (object instanceof Date) {
            Date dateField = (Date)object;
            if (schemaFieldDescriptionOptional.isPresent() && !schemaFieldDescriptionOptional.get().pattern().isEmpty()) {
                if (this.useLocalTimeZone()) {
                    return FormatterUtils.format_Date_Locale((Date)dateField, (String)schemaFieldDescriptionOptional.get().pattern(), (String)TimeZone.getDefault().getID());
                }
                return FormatterUtils.format_Date((Date)dateField, (String)schemaFieldDescriptionOptional.get().pattern());
            }
        } else {
            object = recordValue.getAs(field.name());
            if (object instanceof byte[]) {
                byte[] byteArray = (byte[])object;
                return Charset.defaultCharset().decode(TLogRowCastUtils.wrapBytes((byte[])byteArray)).toString();
            }
        }
        return recordValue.getAs(field.name()).toString();
    }

    public String log(Row var1);

    public String log(Dataset<Row> var1);
}

