/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.parquet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.Trigger;
import org.immutables.value.Generated;
import org.talend.bigdata.structuredstreaming.common.output.FileWriter;
import org.talend.bigdata.structuredstreaming.common.output.StreamWriter;
import org.talend.bigdata.structuredstreaming.parquet.TFileOutputParquet;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TFileOutputParquet", generator="Immutables")
@Immutable
public final class ImmutableTFileOutputParquet
extends TFileOutputParquet {
    private final Dataset<Row> input;
    private final Encoder<Row> encoder;
    private final Class<?> rowClass;
    private final ImmutableMap<String, String> options;
    private final Optional<String> queryName;
    @Nullable
    private final Trigger trigger;
    private final SparkSession sparkSession;
    private final String path;
    private final FileWriter.FileFormat format;
    private final transient OutputMode outputMode;
    private final boolean sortColumnsAlphabetically;
    private final String[] partitionColumns;
    private final boolean overrideDatesTZwithUTC;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTFileOutputParquet(Dataset<Row> input, SparkSession sparkSession, String path, FileWriter.FileFormat format) {
        this.input = Objects.requireNonNull(input, "input");
        this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
        this.path = Objects.requireNonNull(path, "path");
        this.format = Objects.requireNonNull(format, "format");
        this.trigger = null;
        this.encoder = this.initShim.encoder();
        this.rowClass = this.initShim.rowClass();
        this.options = this.initShim.options();
        this.queryName = this.initShim.queryName();
        this.outputMode = this.initShim.outputMode();
        this.sortColumnsAlphabetically = this.initShim.sortColumnsAlphabetically();
        this.partitionColumns = this.initShim.partitionColumns();
        this.overrideDatesTZwithUTC = this.initShim.overrideDatesTZwithUTC();
        this.initShim = null;
    }

    private ImmutableTFileOutputParquet(Builder builder) {
        this.input = builder.input;
        this.trigger = builder.trigger;
        this.sparkSession = builder.sparkSession;
        this.path = builder.path;
        this.format = builder.format;
        if (builder.encoder != null) {
            this.initShim.encoder(builder.encoder);
        }
        if (builder.rowClass != null) {
            this.initShim.rowClass(builder.rowClass);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options((ImmutableMap<String, String>)builder.options.build());
        }
        if (builder.queryName != null) {
            this.initShim.queryName(builder.queryName);
        }
        if (builder.sortColumnsAlphabeticallyIsSet()) {
            this.initShim.sortColumnsAlphabetically(builder.sortColumnsAlphabetically);
        }
        if (builder.partitionColumns != null) {
            this.initShim.partitionColumns(builder.partitionColumns);
        }
        if (builder.overrideDatesTZwithUTCIsSet()) {
            this.initShim.overrideDatesTZwithUTC(builder.overrideDatesTZwithUTC);
        }
        this.encoder = this.initShim.encoder();
        this.rowClass = this.initShim.rowClass();
        this.options = this.initShim.options();
        this.queryName = this.initShim.queryName();
        this.outputMode = this.initShim.outputMode();
        this.sortColumnsAlphabetically = this.initShim.sortColumnsAlphabetically();
        this.partitionColumns = this.initShim.partitionColumns();
        this.overrideDatesTZwithUTC = this.initShim.overrideDatesTZwithUTC();
        this.initShim = null;
    }

    private ImmutableTFileOutputParquet(Dataset<Row> input, Encoder<Row> encoder, Class<?> rowClass, ImmutableMap<String, String> options, Optional<String> queryName, @Nullable Trigger trigger, SparkSession sparkSession, String path, FileWriter.FileFormat format, boolean sortColumnsAlphabetically, String[] partitionColumns, boolean overrideDatesTZwithUTC) {
        this.input = input;
        this.initShim.encoder(encoder);
        this.initShim.rowClass(rowClass);
        this.initShim.options(options);
        this.initShim.queryName(queryName);
        this.trigger = trigger;
        this.sparkSession = sparkSession;
        this.path = path;
        this.format = format;
        this.initShim.sortColumnsAlphabetically(sortColumnsAlphabetically);
        this.initShim.partitionColumns(partitionColumns);
        this.initShim.overrideDatesTZwithUTC(overrideDatesTZwithUTC);
        this.encoder = this.initShim.encoder();
        this.rowClass = this.initShim.rowClass();
        this.options = this.initShim.options();
        this.queryName = this.initShim.queryName();
        this.outputMode = this.initShim.outputMode();
        this.sortColumnsAlphabetically = this.initShim.sortColumnsAlphabetically();
        this.partitionColumns = this.initShim.partitionColumns();
        this.overrideDatesTZwithUTC = this.initShim.overrideDatesTZwithUTC();
        this.initShim = null;
    }

    public Dataset<Row> input() {
        return this.input;
    }

    public Encoder<Row> encoder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encoder() : this.encoder;
    }

    public Class<?> rowClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowClass() : this.rowClass;
    }

    public ImmutableMap<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    @Override
    public Optional<String> queryName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.queryName() : this.queryName;
    }

    @Override
    public Optional<Trigger> trigger() {
        return Optional.ofNullable(this.trigger);
    }

    @Override
    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public FileWriter.FileFormat format() {
        return this.format;
    }

    @Override
    public OutputMode outputMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputMode() : this.outputMode;
    }

    @Override
    boolean sortColumnsAlphabetically() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sortColumnsAlphabetically() : this.sortColumnsAlphabetically;
    }

    @Override
    String[] partitionColumns() {
        InitShim shim = this.initShim;
        return shim != null ? (String[])shim.partitionColumns().clone() : (String[])this.partitionColumns.clone();
    }

    @Override
    boolean overrideDatesTZwithUTC() {
        InitShim shim = this.initShim;
        return shim != null ? shim.overrideDatesTZwithUTC() : this.overrideDatesTZwithUTC;
    }

    public final ImmutableTFileOutputParquet withInput(Dataset<Row> value) {
        if (this.input == value) {
            return this;
        }
        Dataset<Row> newValue = Objects.requireNonNull(value, "input");
        return new ImmutableTFileOutputParquet(newValue, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withEncoder(Encoder<Row> value) {
        if (this.encoder == value) {
            return this;
        }
        Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
        return new ImmutableTFileOutputParquet(this.input, newValue, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withRowClass(Class<?> value) {
        if (this.rowClass == value) {
            return this;
        }
        Class<?> newValue = Objects.requireNonNull(value, "rowClass");
        return new ImmutableTFileOutputParquet(this.input, this.encoder, newValue, this.options, this.queryName, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, (ImmutableMap<String, String>)newValue, this.queryName, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withQueryName(Optional<String> value) {
        Optional<String> newValue = Objects.requireNonNull(value, "queryName");
        if (this.queryName.equals(newValue)) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, newValue, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withTrigger(Trigger value) {
        Trigger newValue = Objects.requireNonNull(value, "trigger");
        if (this.trigger == newValue) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, newValue, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withTrigger(Optional<? extends Trigger> optional) {
        Trigger value = optional.orElse(null);
        if (this.trigger == value) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, value, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withSparkSession(SparkSession value) {
        if (this.sparkSession == value) {
            return this;
        }
        SparkSession newValue = Objects.requireNonNull(value, "sparkSession");
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, newValue, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, newValue, this.format, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withFormat(FileWriter.FileFormat value) {
        FileWriter.FileFormat newValue = Objects.requireNonNull(value, "format");
        if (this.format == newValue) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, this.path, newValue, this.sortColumnsAlphabetically, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withSortColumnsAlphabetically(boolean value) {
        if (this.sortColumnsAlphabetically == value) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, this.path, this.format, value, this.partitionColumns, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withPartitionColumns(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, newValue, this.overrideDatesTZwithUTC);
    }

    public final ImmutableTFileOutputParquet withOverrideDatesTZwithUTC(boolean value) {
        if (this.overrideDatesTZwithUTC == value) {
            return this;
        }
        return new ImmutableTFileOutputParquet(this.input, this.encoder, this.rowClass, this.options, this.queryName, this.trigger, this.sparkSession, this.path, this.format, this.sortColumnsAlphabetically, this.partitionColumns, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTFileOutputParquet && this.equalTo(0, (ImmutableTFileOutputParquet)another);
    }

    private boolean equalTo(int synthetic, ImmutableTFileOutputParquet another) {
        return this.input.equals(another.input) && this.encoder.equals(another.encoder) && this.rowClass.equals(another.rowClass) && this.options.equals(another.options) && this.queryName.equals(another.queryName) && Objects.equals(this.trigger, another.trigger) && this.sparkSession.equals(another.sparkSession) && this.path.equals(another.path) && this.format.equals((Object)another.format) && this.outputMode.equals(another.outputMode) && this.sortColumnsAlphabetically == another.sortColumnsAlphabetically && Arrays.equals(this.partitionColumns, another.partitionColumns) && this.overrideDatesTZwithUTC == another.overrideDatesTZwithUTC;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.encoder.hashCode();
        h += (h << 5) + this.rowClass.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.queryName.hashCode();
        h += (h << 5) + Objects.hashCode(this.trigger);
        h += (h << 5) + this.sparkSession.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.format.hashCode();
        h += (h << 5) + this.outputMode.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.sortColumnsAlphabetically);
        h += (h << 5) + Arrays.hashCode(this.partitionColumns);
        h += (h << 5) + Booleans.hashCode((boolean)this.overrideDatesTZwithUTC);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TFileOutputParquet").omitNullValues().add("input", this.input).add("encoder", this.encoder).add("rowClass", this.rowClass).add("options", this.options).add("queryName", this.queryName).add("trigger", (Object)this.trigger).add("sparkSession", (Object)this.sparkSession).add("path", (Object)this.path).add("format", (Object)this.format).add("outputMode", (Object)this.outputMode).add("sortColumnsAlphabetically", this.sortColumnsAlphabetically).add("partitionColumns", (Object)Arrays.toString(this.partitionColumns)).add("overrideDatesTZwithUTC", this.overrideDatesTZwithUTC).toString();
    }

    public static ImmutableTFileOutputParquet of(Dataset<Row> input, SparkSession sparkSession, String path, FileWriter.FileFormat format) {
        return new ImmutableTFileOutputParquet(input, sparkSession, path, format);
    }

    public static ImmutableTFileOutputParquet copyOf(TFileOutputParquet instance) {
        if (instance instanceof ImmutableTFileOutputParquet) {
            return (ImmutableTFileOutputParquet)instance;
        }
        return ImmutableTFileOutputParquet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TFileOutputParquet", generator="Immutables")
    private final class InitShim {
        private byte encoderBuildStage = 0;
        private Encoder<Row> encoder;
        private byte rowClassBuildStage = 0;
        private Class<?> rowClass;
        private byte optionsBuildStage = 0;
        private ImmutableMap<String, String> options;
        private byte queryNameBuildStage = 0;
        private Optional<String> queryName;
        private byte outputModeBuildStage = 0;
        private OutputMode outputMode;
        private byte sortColumnsAlphabeticallyBuildStage = 0;
        private boolean sortColumnsAlphabetically;
        private byte partitionColumnsBuildStage = 0;
        private String[] partitionColumns;
        private byte overrideDatesTZwithUTCBuildStage = 0;
        private boolean overrideDatesTZwithUTC;

        private InitShim() {
        }

        Encoder<Row> encoder() {
            if (this.encoderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encoderBuildStage == 0) {
                this.encoderBuildStage = (byte)-1;
                this.encoder = Objects.requireNonNull(ImmutableTFileOutputParquet.super.encoder(), "encoder");
                this.encoderBuildStage = 1;
            }
            return this.encoder;
        }

        void encoder(Encoder<Row> encoder) {
            this.encoder = encoder;
            this.encoderBuildStage = 1;
        }

        Class<?> rowClass() {
            if (this.rowClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowClassBuildStage == 0) {
                this.rowClassBuildStage = (byte)-1;
                this.rowClass = Objects.requireNonNull(ImmutableTFileOutputParquet.super.rowClass(), "rowClass");
                this.rowClassBuildStage = 1;
            }
            return this.rowClass;
        }

        void rowClass(Class<?> rowClass) {
            this.rowClass = rowClass;
            this.rowClassBuildStage = 1;
        }

        ImmutableMap<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableMap.copyOf((Map)ImmutableTFileOutputParquet.super.options());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableMap<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        Optional<String> queryName() {
            if (this.queryNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queryNameBuildStage == 0) {
                this.queryNameBuildStage = (byte)-1;
                this.queryName = Objects.requireNonNull(ImmutableTFileOutputParquet.super.queryName(), "queryName");
                this.queryNameBuildStage = 1;
            }
            return this.queryName;
        }

        void queryName(Optional<String> queryName) {
            this.queryName = queryName;
            this.queryNameBuildStage = 1;
        }

        OutputMode outputMode() {
            if (this.outputModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputModeBuildStage == 0) {
                this.outputModeBuildStage = (byte)-1;
                this.outputMode = Objects.requireNonNull(ImmutableTFileOutputParquet.super.outputMode(), "outputMode");
                this.outputModeBuildStage = 1;
            }
            return this.outputMode;
        }

        boolean sortColumnsAlphabetically() {
            if (this.sortColumnsAlphabeticallyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortColumnsAlphabeticallyBuildStage == 0) {
                this.sortColumnsAlphabeticallyBuildStage = (byte)-1;
                this.sortColumnsAlphabetically = ImmutableTFileOutputParquet.super.sortColumnsAlphabetically();
                this.sortColumnsAlphabeticallyBuildStage = 1;
            }
            return this.sortColumnsAlphabetically;
        }

        void sortColumnsAlphabetically(boolean sortColumnsAlphabetically) {
            this.sortColumnsAlphabetically = sortColumnsAlphabetically;
            this.sortColumnsAlphabeticallyBuildStage = 1;
        }

        String[] partitionColumns() {
            if (this.partitionColumnsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitionColumnsBuildStage == 0) {
                this.partitionColumnsBuildStage = (byte)-1;
                this.partitionColumns = (String[])ImmutableTFileOutputParquet.super.partitionColumns().clone();
                this.partitionColumnsBuildStage = 1;
            }
            return this.partitionColumns;
        }

        void partitionColumns(String[] partitionColumns) {
            this.partitionColumns = partitionColumns;
            this.partitionColumnsBuildStage = 1;
        }

        boolean overrideDatesTZwithUTC() {
            if (this.overrideDatesTZwithUTCBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.overrideDatesTZwithUTCBuildStage == 0) {
                this.overrideDatesTZwithUTCBuildStage = (byte)-1;
                this.overrideDatesTZwithUTC = ImmutableTFileOutputParquet.super.overrideDatesTZwithUTC();
                this.overrideDatesTZwithUTCBuildStage = 1;
            }
            return this.overrideDatesTZwithUTC;
        }

        void overrideDatesTZwithUTC(boolean overrideDatesTZwithUTC) {
            this.overrideDatesTZwithUTC = overrideDatesTZwithUTC;
            this.overrideDatesTZwithUTCBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.encoderBuildStage == -1) {
                attributes.add("encoder");
            }
            if (this.rowClassBuildStage == -1) {
                attributes.add("rowClass");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.queryNameBuildStage == -1) {
                attributes.add("queryName");
            }
            if (this.outputModeBuildStage == -1) {
                attributes.add("outputMode");
            }
            if (this.sortColumnsAlphabeticallyBuildStage == -1) {
                attributes.add("sortColumnsAlphabetically");
            }
            if (this.partitionColumnsBuildStage == -1) {
                attributes.add("partitionColumns");
            }
            if (this.overrideDatesTZwithUTCBuildStage == -1) {
                attributes.add("overrideDatesTZwithUTC");
            }
            return "Cannot build TFileOutputParquet, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TFileOutputParquet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_SPARK_SESSION = 2L;
        private static final long INIT_BIT_PATH = 4L;
        private static final long INIT_BIT_FORMAT = 8L;
        private static final long OPT_BIT_OPTIONS = 1L;
        private static final long OPT_BIT_SORT_COLUMNS_ALPHABETICALLY = 2L;
        private static final long OPT_BIT_OVERRIDE_DATES_T_ZWITH_U_T_C = 4L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private Dataset<Row> input;
        @Nullable
        private Encoder<Row> encoder;
        @Nullable
        private Class<?> rowClass;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        @Nullable
        private Optional<String> queryName;
        @Nullable
        private Trigger trigger;
        @Nullable
        private SparkSession sparkSession;
        @Nullable
        private String path;
        @Nullable
        private FileWriter.FileFormat format;
        private boolean sortColumnsAlphabetically;
        @Nullable
        private String[] partitionColumns;
        private boolean overrideDatesTZwithUTC;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TFileOutputParquet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamWriter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FileWriter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Trigger> triggerOptional;
            StreamWriter instance;
            long bits = 0L;
            if (object instanceof TFileOutputParquet) {
                instance = (TFileOutputParquet)object;
                this.input((Dataset<Row>)instance.input());
                if ((bits & 1L) == 0L) {
                    this.path(instance.path());
                    bits |= 1L;
                }
                this.overrideDatesTZwithUTC(((TFileOutputParquet)instance).overrideDatesTZwithUTC());
                if ((bits & 2L) == 0L) {
                    this.rowClass(instance.rowClass());
                    bits |= 2L;
                }
                this.sortColumnsAlphabetically(((TFileOutputParquet)instance).sortColumnsAlphabetically());
                if ((bits & 4L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 4L;
                }
                this.partitionColumns(((TFileOutputParquet)instance).partitionColumns());
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.format(instance.format());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.queryName(instance.queryName());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    triggerOptional = instance.trigger();
                    if (triggerOptional.isPresent()) {
                        this.trigger(triggerOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.encoder((Encoder<Row>)instance.encoder());
                    bits |= 0x80L;
                }
            }
            if (object instanceof StreamWriter) {
                instance = (StreamWriter)object;
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.queryName(instance.queryName());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.rowClass(instance.rowClass());
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    triggerOptional = instance.trigger();
                    if (triggerOptional.isPresent()) {
                        this.trigger(triggerOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.encoder((Encoder<Row>)instance.encoder());
                    bits |= 0x80L;
                }
            }
            if (object instanceof FileWriter) {
                instance = (FileWriter)object;
                if ((bits & 1L) == 0L) {
                    this.path(instance.path());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.rowClass(instance.rowClass());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.format(instance.format());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.queryName(instance.queryName());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    triggerOptional = instance.trigger();
                    if (triggerOptional.isPresent()) {
                        this.trigger(triggerOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.encoder((Encoder<Row>)instance.encoder());
                    bits |= 0x80L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder input(Dataset<Row> input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoder(Encoder<Row> encoder) {
            this.encoder = Objects.requireNonNull(encoder, "encoder");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowClass(Class<?> rowClass) {
            this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryName(Optional<String> queryName) {
            this.queryName = Objects.requireNonNull(queryName, "queryName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trigger(Trigger trigger) {
            this.trigger = Objects.requireNonNull(trigger, "trigger");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trigger(Optional<? extends Trigger> trigger) {
            this.trigger = trigger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sparkSession(SparkSession sparkSession) {
            this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(FileWriter.FileFormat format) {
            this.format = Objects.requireNonNull(format, "format");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortColumnsAlphabetically(boolean sortColumnsAlphabetically) {
            this.sortColumnsAlphabetically = sortColumnsAlphabetically;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionColumns(String ... partitionColumns) {
            this.partitionColumns = (String[])partitionColumns.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder overrideDatesTZwithUTC(boolean overrideDatesTZwithUTC) {
            this.overrideDatesTZwithUTC = overrideDatesTZwithUTC;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableTFileOutputParquet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTFileOutputParquet(this);
        }

        private boolean optionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sortColumnsAlphabeticallyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean overrideDatesTZwithUTCIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sparkSession");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("format");
            }
            return "Cannot build TFileOutputParquet, some of required attributes are not set " + attributes;
        }
    }
}

