/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.technical.tcollectandcheck;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.logging.log4j.Logger;
import org.immutables.value.Generated;
import org.talend.bigdata.structuredstreaming.technical.tcollectandcheck.TCollectAndCheckWriter;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TCollectAndCheckWriter", generator="Immutables")
@Immutable
public final class ImmutableTCollectAndCheckWriter
extends TCollectAndCheckWriter {
    private final Logger logger;
    private final String componentName;
    private final ImmutableList<String> referenceDataList;
    private final boolean keepReferenceOrder;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTCollectAndCheckWriter(Builder builder) {
        this.logger = builder.logger;
        if (builder.componentName != null) {
            this.initShim.componentName(builder.componentName);
        }
        if (builder.referenceDataListIsSet()) {
            this.initShim.referenceDataList((ImmutableList<String>)builder.referenceDataList.build());
        }
        if (builder.keepReferenceOrderIsSet()) {
            this.initShim.keepReferenceOrder(builder.keepReferenceOrder);
        }
        this.componentName = this.initShim.componentName();
        this.referenceDataList = this.initShim.referenceDataList();
        this.keepReferenceOrder = this.initShim.keepReferenceOrder();
        this.initShim = null;
    }

    private ImmutableTCollectAndCheckWriter(Logger logger, String componentName, ImmutableList<String> referenceDataList, boolean keepReferenceOrder) {
        this.logger = logger;
        this.componentName = componentName;
        this.referenceDataList = referenceDataList;
        this.keepReferenceOrder = keepReferenceOrder;
        this.initShim = null;
    }

    @Override
    Logger getLogger() {
        return this.logger;
    }

    @Override
    String componentName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.componentName() : this.componentName;
    }

    ImmutableList<String> referenceDataList() {
        InitShim shim = this.initShim;
        return shim != null ? shim.referenceDataList() : this.referenceDataList;
    }

    @Override
    boolean keepReferenceOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keepReferenceOrder() : this.keepReferenceOrder;
    }

    public final ImmutableTCollectAndCheckWriter withLogger(Logger value) {
        if (this.logger == value) {
            return this;
        }
        Logger newValue = Objects.requireNonNull(value, "logger");
        return new ImmutableTCollectAndCheckWriter(newValue, this.componentName, this.referenceDataList, this.keepReferenceOrder);
    }

    public final ImmutableTCollectAndCheckWriter withComponentName(String value) {
        String newValue = Objects.requireNonNull(value, "componentName");
        if (this.componentName.equals(newValue)) {
            return this;
        }
        return new ImmutableTCollectAndCheckWriter(this.logger, newValue, this.referenceDataList, this.keepReferenceOrder);
    }

    public final ImmutableTCollectAndCheckWriter withReferenceDataList(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTCollectAndCheckWriter(this.logger, this.componentName, (ImmutableList<String>)newValue, this.keepReferenceOrder);
    }

    public final ImmutableTCollectAndCheckWriter withReferenceDataList(Iterable<String> elements) {
        if (this.referenceDataList == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTCollectAndCheckWriter(this.logger, this.componentName, (ImmutableList<String>)newValue, this.keepReferenceOrder);
    }

    public final ImmutableTCollectAndCheckWriter withKeepReferenceOrder(boolean value) {
        if (this.keepReferenceOrder == value) {
            return this;
        }
        return new ImmutableTCollectAndCheckWriter(this.logger, this.componentName, this.referenceDataList, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTCollectAndCheckWriter && this.equalTo(0, (ImmutableTCollectAndCheckWriter)another);
    }

    private boolean equalTo(int synthetic, ImmutableTCollectAndCheckWriter another) {
        return this.logger.equals(another.logger) && this.componentName.equals(another.componentName) && this.referenceDataList.equals(another.referenceDataList) && this.keepReferenceOrder == another.keepReferenceOrder;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.logger.hashCode();
        h += (h << 5) + this.componentName.hashCode();
        h += (h << 5) + this.referenceDataList.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.keepReferenceOrder);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TCollectAndCheckWriter").omitNullValues().add("logger", (Object)this.logger).add("componentName", (Object)this.componentName).add("referenceDataList", this.referenceDataList).add("keepReferenceOrder", this.keepReferenceOrder).toString();
    }

    public static ImmutableTCollectAndCheckWriter copyOf(TCollectAndCheckWriter instance) {
        if (instance instanceof ImmutableTCollectAndCheckWriter) {
            return (ImmutableTCollectAndCheckWriter)instance;
        }
        return ImmutableTCollectAndCheckWriter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TCollectAndCheckWriter", generator="Immutables")
    private final class InitShim {
        private byte componentNameBuildStage = 0;
        private String componentName;
        private byte referenceDataListBuildStage = 0;
        private ImmutableList<String> referenceDataList;
        private byte keepReferenceOrderBuildStage = 0;
        private boolean keepReferenceOrder;

        private InitShim() {
        }

        String componentName() {
            if (this.componentNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.componentNameBuildStage == 0) {
                this.componentNameBuildStage = (byte)-1;
                this.componentName = Objects.requireNonNull(ImmutableTCollectAndCheckWriter.super.componentName(), "componentName");
                this.componentNameBuildStage = 1;
            }
            return this.componentName;
        }

        void componentName(String componentName) {
            this.componentName = componentName;
            this.componentNameBuildStage = 1;
        }

        ImmutableList<String> referenceDataList() {
            if (this.referenceDataListBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.referenceDataListBuildStage == 0) {
                this.referenceDataListBuildStage = (byte)-1;
                this.referenceDataList = ImmutableList.copyOf((Collection)ImmutableTCollectAndCheckWriter.super.referenceDataList());
                this.referenceDataListBuildStage = 1;
            }
            return this.referenceDataList;
        }

        void referenceDataList(ImmutableList<String> referenceDataList) {
            this.referenceDataList = referenceDataList;
            this.referenceDataListBuildStage = 1;
        }

        boolean keepReferenceOrder() {
            if (this.keepReferenceOrderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keepReferenceOrderBuildStage == 0) {
                this.keepReferenceOrderBuildStage = (byte)-1;
                this.keepReferenceOrder = ImmutableTCollectAndCheckWriter.super.keepReferenceOrder();
                this.keepReferenceOrderBuildStage = 1;
            }
            return this.keepReferenceOrder;
        }

        void keepReferenceOrder(boolean keepReferenceOrder) {
            this.keepReferenceOrder = keepReferenceOrder;
            this.keepReferenceOrderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.componentNameBuildStage == -1) {
                attributes.add("componentName");
            }
            if (this.referenceDataListBuildStage == -1) {
                attributes.add("referenceDataList");
            }
            if (this.keepReferenceOrderBuildStage == -1) {
                attributes.add("keepReferenceOrder");
            }
            return "Cannot build TCollectAndCheckWriter, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TCollectAndCheckWriter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOGGER = 1L;
        private static final long OPT_BIT_REFERENCE_DATA_LIST = 1L;
        private static final long OPT_BIT_KEEP_REFERENCE_ORDER = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Logger logger;
        @Nullable
        private String componentName;
        private ImmutableList.Builder<String> referenceDataList = ImmutableList.builder();
        private boolean keepReferenceOrder;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TCollectAndCheckWriter instance) {
            Objects.requireNonNull(instance, "instance");
            this.logger(instance.getLogger());
            this.componentName(instance.componentName());
            this.addAllReferenceDataList(instance.referenceDataList());
            this.keepReferenceOrder(instance.keepReferenceOrder());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logger(Logger logger) {
            this.logger = Objects.requireNonNull(logger, "logger");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder componentName(String componentName) {
            this.componentName = Objects.requireNonNull(componentName, "componentName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReferenceDataList(String element) {
            this.referenceDataList.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReferenceDataList(String ... elements) {
            this.referenceDataList.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenceDataList(Iterable<String> elements) {
            this.referenceDataList = ImmutableList.builder();
            return this.addAllReferenceDataList(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllReferenceDataList(Iterable<String> elements) {
            this.referenceDataList.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keepReferenceOrder(boolean keepReferenceOrder) {
            this.keepReferenceOrder = keepReferenceOrder;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableTCollectAndCheckWriter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTCollectAndCheckWriter(this);
        }

        private boolean referenceDataListIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean keepReferenceOrderIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("logger");
            }
            return "Cannot build TCollectAndCheckWriter, some of required attributes are not set " + attributes;
        }
    }
}

