/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.technical.tfixedflowstreaminput;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Value;
import org.talend.bigdata.structuredstreaming.common.input.StreamReader;

@Value.Immutable
public abstract class TFixedFlowStreamInput
implements StreamReader {
    public abstract List<Row> rows();

    @Value.Default
    public int duplicateRowsBy() {
        return 1;
    }

    @Override
    public Dataset<Row> load() {
        List localRows = IntStream.range(0, this.duplicateRowsBy()).boxed().flatMap(i -> this.rows().stream()).toList();
        StructType schema = this.schema().orElseThrow(() -> new IllegalStateException("Schema must be present"));
        Dataset rateStream = this.sparkSession().readStream().format("rate-micro-batch").options(this.options()).load();
        Dataset staticRows = this.sparkSession().createDataFrame(localRows, schema);
        Dataset fixedDS = rateStream.crossJoin(staticRows).drop("timestamp").drop("value");
        return this.withWatermarking((Dataset<Row>)fixedDS);
    }
}

