/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.tmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.expressions.Window;
import org.apache.spark.sql.functions;
import org.talend.bigdata.tmap.filters.Filter;

public class TMapInput<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UNIQUECOLUMN = "Qlik_Unique_Column";
    private String name;
    private Dataset<T> inputDS;
    private boolean isUniqueMatch;
    private transient Column[] joinCols;
    private boolean isStructuredStreaming;
    private List<Filter> filtersFromOutput = new ArrayList<Filter>();

    public TMapInput(String name, Dataset<T> inputDS, boolean isUniqueMatch, Column[] joinCols, boolean isStructuredStreaming) {
        this.name = name;
        this.inputDS = inputDS;
        this.isUniqueMatch = isUniqueMatch;
        this.joinCols = joinCols;
        this.isStructuredStreaming = isStructuredStreaming;
    }

    public TMapInput(String name, Dataset<T> inputDS, boolean isUniqueMatch, Column[] joinCols, FilterFunction<T> filter, boolean isStructuredStreaming) {
        this.name = name;
        this.inputDS = inputDS.filter(filter);
        this.isUniqueMatch = isUniqueMatch;
        this.joinCols = joinCols;
        this.isStructuredStreaming = isStructuredStreaming;
    }

    public void addFilter(Filter filter) {
        this.filtersFromOutput.add(filter);
    }

    public List<FilterFunction> getFilterFunctionsForOutput() {
        return this.filtersFromOutput.stream().map(Filter::getFilterFunction).collect(Collectors.toList());
    }

    public Dataset<T> getInputDS(String to) {
        Optional<Filter> filter;
        Dataset result = this.inputDS;
        if (!this.filtersFromOutput.isEmpty() && (filter = this.filtersFromOutput.stream().filter(f -> f.getDatasetTo().equals(to)).findAny()).isPresent()) {
            result = result.filter(filter.get().getFilterFunction());
        }
        if (this.isUniqueMatch && this.isStructuredStreaming) {
            result.dropDuplicatesWithinWatermark();
        } else if (this.isUniqueMatch) {
            result = result.withColumn(UNIQUECOLUMN, functions.row_number().over(Window.partitionBy((Column[])this.joinCols).orderBy(this.joinCols))).filter("Qlik_Unique_Column = 1").drop(UNIQUECOLUMN);
        }
        return result;
    }

    public Dataset<T> getInputDS() {
        return this.inputDS;
    }

    public String getName() {
        return this.name;
    }
}

