/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.tmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.talend.bigdata.tmap.TMapInput;
import org.talend.bigdata.tmap.TMapOutput;
import org.talend.bigdata.tmap.Transformation;
import org.talend.bigdata.tmap.filters.Filter;
import org.talend.bigdata.tmap.joins.FirstJoin;
import org.talend.bigdata.tmap.joins.Join;
import org.talend.bigdata.tmap.joins.LastJoin;
import org.talend.bigdata.tmap.joins.SingleJoin;
import org.talend.bigdata.tmap.joins.TemporaryJoin;
import scala.Tuple2;
import scala.collection.JavaConverters;

public class TMapDataset {
    private final List<TMapInput> inputs;
    private final List<TMapOutput> outputs;
    private final List<Transformation> transformations;
    private final List<Join> joins;

    public TMapDataset(List<TMapInput> inputs, List<TMapOutput> outputs, List<Transformation> transformations, List<Join> joins) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.transformations = transformations;
        this.joins = joins;
    }

    public TMapInput getInput(String name) {
        return this.inputs.stream().filter(input -> name.equals(input.getName())).findAny().orElse(null);
    }

    public TMapDataset addOutput(TMapOutput output) {
        this.outputs.add(output);
        return this;
    }

    public TMapDataset addInput(TMapInput input) {
        this.inputs.add(input);
        return this;
    }

    private TMapOutput getOutput(String from, String to) {
        Optional<TMapOutput> output = this.outputs.stream().filter(out -> to.equals(out.getName())).findAny();
        Transformation transformation = this.getTransformation(from, to);
        if (output.isPresent() && transformation != null) {
            Dataset outputDS;
            if (output.get().getOutputTypes().contains((Object)TMapOutput.OutputType.OUTPUT_REJECT)) {
                outputDS = this.getOutputRejectDs(from, to);
            } else {
                TMapInput input = this.getInput(from);
                outputDS = input.getInputDS(to);
            }
            output.get().setOutputDS(outputDS.flatMap((FlatMapFunction)transformation, transformation.getEncoder()));
            return output.get();
        }
        return null;
    }

    private Transformation getTransformation(String from, String to) {
        return this.transformations.stream().filter(t -> from.equals(t.getDatasetFrom()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private TMapOutput handleMapping(String from, String to) {
        return this.getOutput(from, to);
    }

    private TMapOutput handleSingleJoin(List<String> relatedInputs, TMapOutput output, String to) {
        Tuple2 firstTuple = new Tuple2((Object)relatedInputs.get(0), (Object)relatedInputs.get(1));
        Dataset outputDs = null;
        if (output.getOutputTypes().contains((Object)TMapOutput.OutputType.NORMAL) || output.getOutputTypes().contains((Object)TMapOutput.OutputType.INNER_JOIN_REJECT)) {
            outputDs = this.makeSingleJoin((Tuple2<String, String>)firstTuple, to);
            output.setJoinOutputDf((Dataset<Row>)outputDs);
            if (output.getJoinOutputFilter() != null && outputDs != null) {
                outputDs = outputDs.filter(output.getJoinOutputFilter());
            }
        }
        if (output.getOutputTypes().contains((Object)TMapOutput.OutputType.OUTPUT_REJECT)) {
            TMapOutput otherOutput = this.outputs.stream().filter(o -> !to.equals(o.getName())).findAny().orElse(null);
            Dataset outputRejects = null;
            if (otherOutput != null) {
                outputRejects = otherOutput.getJoinOutputRejectsDf();
            }
            outputDs = outputDs != null ? outputDs.union(outputRejects) : outputRejects;
        }
        SingleJoin singleJoin = this.getSingleJoin((Tuple2<String, String>)firstTuple, to);
        if (outputDs != null && singleJoin != null) {
            output.setOutputDS(outputDs.toDF().flatMap((FlatMapFunction)singleJoin, singleJoin.getEncoder()));
        }
        return output;
    }

    private TMapOutput handleMultipleJoins(List<String> relatedInputs, TMapOutput output, String to) {
        Tuple2 firstTuple = new Tuple2((Object)relatedInputs.get(0), (Object)relatedInputs.get(1));
        TMapInput inputLeft = this.getInput((String)firstTuple._1);
        Dataset inputDataset = this.renameColumns(inputLeft.getInputDS(to), inputLeft.getName());
        Dataset joinedDataset = this.makeFirstJoin((Tuple2<String, String>)firstTuple, to);
        if (joinedDataset == null) {
            return null;
        }
        joinedDataset = this.performTemporaryJoins(inputDataset, joinedDataset, to);
        String lastInputName = relatedInputs.get(relatedInputs.size() - 1);
        joinedDataset = this.makeLastJoin(inputDataset, joinedDataset, lastInputName, output);
        output.setOutputDS(joinedDataset);
        return output;
    }

    public TMapOutput getOutput(String to) {
        Optional<TMapOutput> outputOpt = this.outputs.stream().filter(out -> to.equals(out.getName())).findAny();
        if (!outputOpt.isPresent()) {
            return null;
        }
        TMapOutput output = outputOpt.get();
        List<String> relatedInputs = output.getRelatedInputs();
        if (relatedInputs.size() == 1) {
            return this.handleMapping(relatedInputs.get(0), to);
        }
        if (relatedInputs.size() == 2) {
            return this.handleSingleJoin(relatedInputs, output, to);
        }
        return this.handleMultipleJoins(relatedInputs, output, to);
    }

    private Dataset getOutputRejectDs(String from, String to) {
        TMapInput input = this.getInput(from);
        List<FilterFunction> relatedOutputsFilters = input.getFilterFunctionsForOutput();
        Dataset rejectedDs = input.getInputDS(to);
        for (FilterFunction f : relatedOutputsFilters) {
            rejectedDs = rejectedDs.filter((FilterFunction & Serializable)row -> !f.call(row));
        }
        return rejectedDs;
    }

    private Dataset makeFirstJoin(Tuple2<String, String> firstTuple, String to) {
        FirstJoin firstJoin = this.getFirstJoin(firstTuple, to);
        if (firstJoin != null) {
            TMapInput inputLeft = this.getInput((String)firstTuple._1);
            TMapInput inputRight = this.getInput((String)firstTuple._2);
            Dataset datasetLeft = this.renameColumns(inputLeft.getInputDS(to), inputLeft.getName());
            Dataset datasetRight = this.renameColumns(inputRight.getInputDS(to), inputRight.getName());
            Dataset result = datasetLeft.join(datasetRight, firstJoin.getCondition(), firstJoin.getJoinType());
            if (firstJoin.isStructuredSteaming()) {
                result = TMapDataset.selectJoinColumns(firstJoin, result);
            }
            return result;
        }
        return null;
    }

    private Dataset performTemporaryJoins(Dataset inputDataset, Dataset joinedDataset, String outputName) {
        List<TemporaryJoin> temporaryJoins = this.getTemporaryJoins(outputName);
        for (TemporaryJoin tempJoin : temporaryJoins) {
            if (tempJoin.getJoinType().equals("ANTI")) {
                joinedDataset = joinedDataset.union(this.makeTemporaryJoin(inputDataset, tempJoin, outputName));
                continue;
            }
            joinedDataset = this.makeTemporaryJoin(joinedDataset, tempJoin, outputName);
        }
        return joinedDataset;
    }

    private FirstJoin getFirstJoin(Tuple2<String, String> froms, String to) {
        List firstJoins = this.joins.stream().filter(FirstJoin.class::isInstance).map(FirstJoin.class::cast).collect(Collectors.toList());
        return firstJoins.stream().filter(t -> ((String)froms._1).equals(t.getDatasetFromA()) && ((String)froms._2).equals(t.getDatasetFromB()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private Dataset makeSingleJoin(Tuple2<String, String> firstTuple, String to) {
        SingleJoin singleJoin = this.getSingleJoin(firstTuple, to);
        if (singleJoin != null) {
            TMapInput leftInput = this.getInput((String)firstTuple._1);
            TMapInput rightInput = this.getInput((String)firstTuple._2);
            Dataset leftDs = this.renameColumns(leftInput.getInputDS(to), leftInput.getName());
            Dataset rightDs = this.renameColumns(rightInput.getInputDS(to), rightInput.getName());
            Dataset joinedDs = leftDs.join(rightDs, singleJoin.getCondition(), singleJoin.getJoinType());
            if ("left_anti".equalsIgnoreCase(singleJoin.getJoinType()) || "anti".equalsIgnoreCase(singleJoin.getJoinType())) {
                List<String> leftCols = Arrays.asList(leftDs.columns());
                for (String rightCol : rightDs.columns()) {
                    if (leftCols.contains(rightCol)) continue;
                    joinedDs = joinedDs.withColumn(rightCol, functions.lit(null));
                }
            }
            return joinedDs;
        }
        return null;
    }

    private SingleJoin getSingleJoin(Tuple2<String, String> froms, String to) {
        List singleJoins = this.joins.stream().filter(SingleJoin.class::isInstance).map(SingleJoin.class::cast).collect(Collectors.toList());
        return singleJoins.stream().filter(t -> ((String)froms._1).equals(t.getDatasetFromA()) && ((String)froms._2).equals(t.getDatasetFromB()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private Dataset makeTemporaryJoin(Dataset joinedDataset, TemporaryJoin tempJoin, String to) {
        TMapInput rightSide = this.getInput(tempJoin.getDatasetFrom());
        Dataset rightDataset = this.renameColumns(rightSide.getInputDS(to), rightSide.getName());
        Dataset result = joinedDataset.join(rightDataset, tempJoin.getCondition(), tempJoin.getJoinType());
        if (tempJoin.isStructuredSteaming()) {
            result = TMapDataset.selectJoinColumns(tempJoin, result);
        }
        return result;
    }

    protected static Dataset selectJoinColumns(Join join, Dataset dataset) {
        List columnNames = JavaConverters.seqAsJavaList(join.getColumnsToSelect());
        Column[] columns = (Column[])columnNames.stream().map(functions::col).toArray(Column[]::new);
        return dataset.select(columns);
    }

    private List<TemporaryJoin> getTemporaryJoins(String to) {
        return this.joins.stream().filter(TemporaryJoin.class::isInstance).map(TemporaryJoin.class::cast).filter(t -> to.equals(t.getDatasetTo())).collect(Collectors.toList());
    }

    private Dataset makeLastJoin(Dataset inputDataset, Dataset joinedDataset, String lookupName, TMapOutput output) {
        Dataset result;
        LastJoin lastJoin = this.getLastJoin(lookupName, output.getName());
        if (lastJoin == null) {
            return null;
        }
        TMapInput lookupInput = this.getInput(lookupName);
        Dataset lookupDataset = this.renameColumns(lookupInput.getInputDS(output.getName()), lookupInput.getName());
        if (lastJoin.getJoinType().equals("ANTI")) {
            List<TMapOutput> otherNormalOutputs;
            Dataset joinOutputRejectsDf;
            Dataset lastRejects = inputDataset.join(lookupDataset, lastJoin.getCondition(), lastJoin.getJoinType());
            result = joinedDataset.union(lastRejects).dropDuplicates();
            if (output.getOutputTypes().contains((Object)TMapOutput.OutputType.OUTPUT_REJECT) && (joinOutputRejectsDf = this.unionJoinOutputRejectsDf(otherNormalOutputs = this.outputs.stream().filter(o -> !output.getName().equals(o.getName())).filter(o -> o.getOutputTypes().contains((Object)TMapOutput.OutputType.NORMAL)).collect(Collectors.toList()))) != null) {
                result = this.addMissingColumns(result, joinOutputRejectsDf.columns());
                result = result.union(joinOutputRejectsDf);
            }
        } else if (output.getOutputTypes().contains((Object)TMapOutput.OutputType.OUTPUT_REJECT)) {
            List<TMapOutput> otherNormalOutputs = this.outputs.stream().filter(o -> !output.getName().equals(o.getName())).filter(o -> o.getOutputTypes().contains((Object)TMapOutput.OutputType.NORMAL)).collect(Collectors.toList());
            result = this.unionJoinOutputRejectsDf(otherNormalOutputs);
        } else {
            result = joinedDataset.join(lookupDataset, lastJoin.getCondition(), lastJoin.getJoinType());
            output.setJoinOutputDf((Dataset<Row>)result);
            result = output.getJoinOutputFilteredDf();
        }
        return result == null ? null : result.toDF().flatMap((FlatMapFunction)lastJoin, lastJoin.getEncoder());
    }

    private Dataset addMissingColumns(Dataset result, String[] columns) {
        List<String> resultCols = Arrays.asList(result.columns());
        for (String col : columns) {
            if (resultCols.contains(col)) continue;
            result = result.withColumn(col, functions.lit(null));
        }
        return result;
    }

    private Dataset unionJoinOutputRejectsDf(List<TMapOutput> outputs) {
        Dataset allOutputRejects = null;
        for (TMapOutput output : outputs) {
            Dataset outputRejects;
            if (output.getJoinOutputDf() == null) {
                this.getOutput(output.getName());
            }
            if ((outputRejects = output.getJoinOutputRejectsDf()) == null) continue;
            if (allOutputRejects == null) {
                allOutputRejects = outputRejects;
                continue;
            }
            allOutputRejects = allOutputRejects.union(outputRejects);
        }
        return allOutputRejects;
    }

    private LastJoin getLastJoin(String from, String to) {
        List lastJoins = this.joins.stream().filter(LastJoin.class::isInstance).map(LastJoin.class::cast).collect(Collectors.toList());
        return lastJoins.stream().filter(t -> from.equals(t.getDatasetFrom()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private Dataset renameColumns(Dataset ds, String prefix) {
        for (String colName : ds.columns()) {
            ds = ds.withColumnRenamed(colName, prefix + "_" + colName);
        }
        return ds;
    }

    public static class Builder {
        private final List<TMapInput> inputs = new ArrayList<TMapInput>();
        private final List<TMapOutput> outputs = new ArrayList<TMapOutput>();
        private final List<Transformation> transformations = new ArrayList<Transformation>();
        private final List<Join> joins = new ArrayList<Join>();

        public Builder addInput(TMapInput input) {
            this.inputs.add(input);
            return this;
        }

        public Builder addTransformation(Transformation transformation) {
            this.transformations.add(transformation);
            return this;
        }

        public Builder addJoin(Join join) {
            this.joins.add(join);
            return this;
        }

        public Builder addOutput(TMapOutput out) {
            this.outputs.add(out);
            return this;
        }

        public TMapDataset build() {
            return new TMapDataset(this.inputs, this.outputs, this.transformations, this.joins);
        }

        public Builder addOutputFilter(String inputName, FilterFunction filter, String outputName) {
            this.inputs.stream().filter(in -> inputName.equals(in.getName())).findAny().ifPresent(input -> input.addFilter(new Filter(filter, outputName)));
            return this;
        }
    }
}

