/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.tmap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class TMapOutput<O>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> relatedInputs;
    private Dataset<O> outputDs;
    private Dataset<Row> joinOutputDf;
    private FilterFunction<O> filter;
    private FilterFunction<Row> joinOutputFilter;
    private List<OutputType> outputTypes = Collections.singletonList(OutputType.NORMAL);

    public TMapOutput(String name, String relatedInput) {
        this.name = name;
        this.relatedInputs = Collections.singletonList(relatedInput);
    }

    public TMapOutput(String name, String relatedInput, OutputType ... outputTypes) {
        this.name = name;
        this.relatedInputs = Collections.singletonList(relatedInput);
        this.outputTypes = Arrays.asList(outputTypes);
    }

    public TMapOutput(String name, String relatedInput, FilterFunction<O> filter) {
        this.name = name;
        this.relatedInputs = Collections.singletonList(relatedInput);
        this.filter = filter;
    }

    public TMapOutput(String name, List<String> relatedInputs, OutputType ... outputTypes) {
        this.name = name;
        this.relatedInputs = relatedInputs;
        this.outputTypes = Arrays.asList(outputTypes);
    }

    public TMapOutput(String name, List<String> relatedInputs) {
        this.name = name;
        this.relatedInputs = relatedInputs;
    }

    public TMapOutput(String name, List<String> relatedInputs, FilterFunction<O> filter) {
        this.name = name;
        this.relatedInputs = relatedInputs;
        this.filter = filter;
    }

    public void setOutputDS(Dataset<O> ds) {
        this.outputDs = ds;
    }

    public void setJoinOutputDf(Dataset<Row> ds) {
        this.joinOutputDf = ds;
    }

    public Dataset<Row> getJoinOutputDf() {
        return this.joinOutputDf;
    }

    public Dataset<Row> getJoinOutputFilteredDf() {
        if (this.joinOutputFilter != null) {
            return this.joinOutputDf.filter(this.joinOutputFilter);
        }
        return this.joinOutputDf;
    }

    public Dataset<Row> getJoinOutputRejectsDf() {
        if (this.joinOutputFilter != null) {
            return this.joinOutputDf.filter((FilterFunction & Serializable)row -> !this.joinOutputFilter.call(row));
        }
        return this.joinOutputDf;
    }

    public Dataset<O> getOutputDS() {
        if (this.filter != null) {
            return this.outputDs.filter(this.filter);
        }
        return this.outputDs;
    }

    public Dataset<O> getOutputRejectDS() {
        if (this.filter != null) {
            return this.outputDs.filter((FilterFunction & Serializable)row -> !this.filter.call(row));
        }
        return this.outputDs;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRelatedInputs() {
        return this.relatedInputs;
    }

    public String getRelatedInput() {
        return this.relatedInputs.get(0);
    }

    public String getRelatedInput(String name) {
        return this.relatedInputs.stream().filter(name::equals).findAny().orElse(null);
    }

    public List<OutputType> getOutputTypes() {
        return this.outputTypes;
    }

    public TMapOutput<O> setJoinOutputFilter(FilterFunction<Row> joinOutputFilter) {
        this.joinOutputFilter = joinOutputFilter;
        return this;
    }

    public FilterFunction<Row> getJoinOutputFilter() {
        return this.joinOutputFilter;
    }

    public static enum OutputType {
        NORMAL,
        OUTPUT_REJECT,
        INNER_JOIN_REJECT;

    }
}

