/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.builder.FlexibleAggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.GroupedBodyAggregationStrategy;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.apache.camel.processor.aggregate.StringAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.aggregate.UseOriginalAggregationStrategy;

public final class AggregationStrategies {
    private AggregationStrategies() {
    }

    public static <T> FlexibleAggregationStrategy<T> flexible(Class<T> type) {
        return new FlexibleAggregationStrategy<T>(type);
    }

    public static FlexibleAggregationStrategy<Object> flexible() {
        return new FlexibleAggregationStrategy<Object>();
    }

    public static AggregationStrategy useLatest() {
        return new UseLatestAggregationStrategy();
    }

    public static AggregationStrategy useOriginal() {
        return new UseOriginalAggregationStrategy();
    }

    public static AggregationStrategy useOriginal(boolean propagateException) {
        return new UseOriginalAggregationStrategy(propagateException);
    }

    public static AggregationStrategy groupedExchange() {
        return new GroupedExchangeAggregationStrategy();
    }

    public static AggregationStrategy groupedBody() {
        return new GroupedBodyAggregationStrategy();
    }

    public static AggregationStrategy bean(Object bean2) {
        return new AggregationStrategyBeanAdapter(bean2);
    }

    public static AggregationStrategy bean(Object bean2, String methodName) {
        return new AggregationStrategyBeanAdapter(bean2, methodName);
    }

    public static AggregationStrategy beanAllowNull(Object bean2, String methodName) {
        AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(bean2, methodName);
        adapter.setAllowNullOldExchange(true);
        adapter.setAllowNullNewExchange(true);
        return adapter;
    }

    public static AggregationStrategy bean(Class<?> type) {
        return new AggregationStrategyBeanAdapter(type);
    }

    public static AggregationStrategy bean(Class<?> type, String methodName) {
        return new AggregationStrategyBeanAdapter(type, methodName);
    }

    public static AggregationStrategy beanAllowNull(Class<?> type, String methodName) {
        AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(type, methodName);
        adapter.setAllowNullOldExchange(true);
        adapter.setAllowNullNewExchange(true);
        return adapter;
    }

    public static StringAggregationStrategy string() {
        return new StringAggregationStrategy();
    }

    public static StringAggregationStrategy string(String delimiter) {
        return AggregationStrategies.string().delimiter(delimiter);
    }
}

