/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.trait.message.RedeliveryTraitPayload;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class JmsMessageHelper {
    private JmsMessageHelper() {
    }

    public static Object removeJmsProperty(Message jmsMessage, String name) throws JMSException {
        if (!jmsMessage.propertyExists(name)) {
            return null;
        }
        String answer = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (name.equals(key)) {
                answer = key;
                continue;
            }
            map.put(key, JmsMessageHelper.getProperty(jmsMessage, key));
        }
        jmsMessage.clearProperties();
        for (Map.Entry entry : map.entrySet()) {
            jmsMessage.setObjectProperty((String)entry.getKey(), entry.getValue());
        }
        return answer;
    }

    public static boolean hasProperty(Message jmsMessage, String name) throws JMSException {
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!name.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static Object getProperty(Message jmsMessage, String name) throws JMSException {
        Object value = jmsMessage.getObjectProperty(name);
        if (value == null) {
            value = jmsMessage.getStringProperty(name);
        }
        return value;
    }

    public static Long getSafeLongProperty(Message jmsMessage, String name) {
        try {
            return jmsMessage.getLongProperty(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setProperty(Message jmsMessage, String name, Object value) throws JMSException {
        if (value == null) {
            return;
        }
        if (value instanceof Byte) {
            Byte aByte = (Byte)value;
            jmsMessage.setByteProperty(name, aByte);
        } else if (value instanceof Boolean) {
            Boolean aBoolean = (Boolean)value;
            jmsMessage.setBooleanProperty(name, aBoolean);
        } else if (value instanceof Double) {
            Double aDouble = (Double)value;
            jmsMessage.setDoubleProperty(name, aDouble);
        } else if (value instanceof Float) {
            Float aFloat = (Float)value;
            jmsMessage.setFloatProperty(name, aFloat.floatValue());
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            jmsMessage.setIntProperty(name, integer);
        } else if (value instanceof Long) {
            Long aLong = (Long)value;
            jmsMessage.setLongProperty(name, aLong);
        } else if (value instanceof Short) {
            Short aShort = (Short)value;
            jmsMessage.setShortProperty(name, aShort);
        } else if (value instanceof String) {
            String string = (String)value;
            jmsMessage.setStringProperty(name, string);
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public static void setCorrelationId(Message message, String correlationId) {
        try {
            message.setJMSCorrelationID(correlationId);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public static boolean isQueuePrefix(String destination) {
        if (ObjectHelper.isEmpty(destination)) {
            return false;
        }
        return destination.startsWith("queue:") || destination.startsWith("temp-queue:");
    }

    public static boolean isTopicPrefix(String destination) {
        if (ObjectHelper.isEmpty(destination)) {
            return false;
        }
        return destination.startsWith("topic:") || destination.startsWith("temp-topic:");
    }

    public static String normalizeDestinationName(String destination) {
        return JmsMessageHelper.normalizeDestinationName(destination, false);
    }

    public static String normalizeDestinationName(String destination, boolean includePrefix) {
        if (ObjectHelper.isEmpty(destination)) {
            return destination;
        }
        if (destination.startsWith("queue:")) {
            Object s = StringHelper.removeStartingCharacters(destination.substring("queue:".length()), '/');
            if (includePrefix) {
                s = "queue://" + (String)s;
            }
            return s;
        }
        if (destination.startsWith("temp-queue:")) {
            Object s = StringHelper.removeStartingCharacters(destination.substring("temp-queue:".length()), '/');
            if (includePrefix) {
                s = "temp-queue://" + (String)s;
            }
            return s;
        }
        if (destination.startsWith("topic:")) {
            Object s = StringHelper.removeStartingCharacters(destination.substring("topic:".length()), '/');
            if (includePrefix) {
                s = "topic://" + (String)s;
            }
            return s;
        }
        if (destination.startsWith("temp-topic:")) {
            Object s = StringHelper.removeStartingCharacters(destination.substring("temp-topic:".length()), '/');
            if (includePrefix) {
                s = "temp-topic://" + (String)s;
            }
            return s;
        }
        return destination;
    }

    public static void setJMSReplyTo(Message message, Destination replyTo) {
        try {
            message.setJMSReplyTo(replyTo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Destination getJMSReplyTo(Message message) {
        try {
            return message.getJMSReplyTo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJMSType(Message message) {
        try {
            return message.getJMSType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStringProperty(Message message, String propertyName) {
        try {
            return message.getStringProperty(propertyName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Boolean getJMSRedelivered(Message message) {
        try {
            return message.getJMSRedelivered();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RedeliveryTraitPayload evalRedeliveryMessageTrait(Message message) {
        Boolean redelivered = JmsMessageHelper.getJMSRedelivered(message);
        if (redelivered == null) {
            return RedeliveryTraitPayload.UNDEFINED_REDELIVERY;
        }
        if (Boolean.TRUE.equals(redelivered)) {
            return RedeliveryTraitPayload.IS_REDELIVERY;
        }
        return RedeliveryTraitPayload.NON_REDELIVERY;
    }

    public static String getJMSMessageID(Message message) {
        try {
            return message.getJMSMessageID();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Destination getJMSDestination(Message message) {
        try {
            return message.getJMSDestination();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setJMSDeliveryMode(Exchange exchange, Message message, Object deliveryMode) throws JMSException {
        Integer mode = null;
        if (deliveryMode instanceof String) {
            String s = (String)deliveryMode;
            if ("PERSISTENT".equalsIgnoreCase(s)) {
                mode = 2;
            } else if ("NON_PERSISTENT".equalsIgnoreCase(s)) {
                mode = 1;
            } else {
                Integer value = ExchangeHelper.convertToType(exchange, Integer.class, deliveryMode);
                if (value == null) throw new IllegalArgumentException("Unknown delivery mode with value: " + String.valueOf(deliveryMode));
                mode = value;
            }
        } else {
            Integer value = ExchangeHelper.convertToType(exchange, Integer.class, deliveryMode);
            if (value != null) {
                mode = value;
            }
        }
        if (mode == null) return;
        message.setJMSDeliveryMode(mode);
        message.setIntProperty("CamelJmsDeliveryMode", mode);
    }

    public static byte[] getJMSCorrelationIDAsBytes(Message message) {
        try {
            byte[] bytes = message.getJMSCorrelationIDAsBytes();
            boolean isNull = true;
            if (bytes != null) {
                for (byte b : bytes) {
                    if (b == 0) continue;
                    isNull = false;
                    break;
                }
            }
            return isNull ? null : bytes;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJMSCorrelationID(Message message) {
        try {
            return message.getJMSCorrelationID();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getDestinationName(Destination destination) {
        try {
            if (destination instanceof Queue) {
                Queue q = (Queue)destination;
                return q.getQueueName();
            }
            if (destination instanceof Topic) {
                Topic t = (Topic)destination;
                return t.getTopicName();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return null;
    }
}

