/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsonable;
import org.apache.camel.util.json.Jsoner;

public final class DefaultBacklogTracerEventMessage
implements BacklogTracerEventMessage {
    private final StopWatch watch = new StopWatch();
    private final boolean first;
    private final boolean last;
    private final long uid;
    private final long timestamp;
    private final String location;
    private final String routeId;
    private final String toNode;
    private final String exchangeId;
    private final String threadName;
    private String endpointUri;
    private boolean remoteEndpoint;
    private String endpointServiceUrl;
    private String endpointServiceProtocol;
    private Map<String, String> endpointServiceMetadata;
    private final boolean rest;
    private final boolean template;
    private final JsonObject data;
    private volatile String dataAsJson;
    private volatile String dataAsXml;
    private Throwable exception;
    private volatile JsonObject exceptionAsJsonObject;
    private volatile String exceptionAsXml;
    private volatile String exceptionAsJSon;
    private long duration;
    private boolean done;

    public DefaultBacklogTracerEventMessage(boolean first, boolean last, long uid, long timestamp, String location, String routeId, String toNode, String exchangeId, boolean rest, boolean template, JsonObject data) {
        this.first = first;
        this.last = last;
        this.uid = uid;
        this.timestamp = timestamp;
        this.location = location;
        this.routeId = routeId;
        this.toNode = toNode;
        this.exchangeId = exchangeId;
        this.rest = rest;
        this.template = template;
        this.threadName = Thread.currentThread().getName();
        this.data = data;
    }

    public void doneProcessing() {
        this.done = true;
        this.duration = this.watch.taken();
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public boolean isFirst() {
        return this.first;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public boolean isRest() {
        return this.rest;
    }

    @Override
    public boolean isTemplate() {
        return this.template;
    }

    @Override
    public String getToNode() {
        return this.toNode;
    }

    @Override
    public String getExchangeId() {
        return this.exchangeId;
    }

    @Override
    public String getProcessingThreadName() {
        return this.threadName;
    }

    @Override
    public String getMessageAsXml() {
        if (this.dataAsXml == null) {
            this.dataAsXml = this.toXML(this.data, 4);
        }
        return this.dataAsXml;
    }

    @Override
    public String getMessageAsJSon() {
        if (this.dataAsJson == null) {
            this.dataAsJson = this.data.toJson();
        }
        return this.dataAsJson;
    }

    @Override
    public long getElapsed() {
        return this.done ? this.duration : this.watch.taken();
    }

    public void setElapsed(long elapsed) {
        this.duration = elapsed;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isFailed() {
        return this.hasException();
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Override
    public String getExceptionAsXml() {
        if (this.exceptionAsXml == null && this.exception != null) {
            this.exceptionAsXml = MessageHelper.dumpExceptionAsXML(this.exception, 4);
        }
        return this.exceptionAsXml;
    }

    @Override
    public String getExceptionAsJSon() {
        if (this.exceptionAsJSon == null && this.exception != null) {
            this.exceptionAsJSon = MessageHelper.dumpExceptionAsJSon(this.exception, 4, true);
        }
        return this.exceptionAsJSon;
    }

    @Override
    public String getEndpointUri() {
        return this.endpointUri;
    }

    @Override
    public boolean isRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public void setRemoteEndpoint(boolean remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    public String getEndpointServiceUrl() {
        return this.endpointServiceUrl;
    }

    public void setEndpointServiceUrl(String endpointServiceUrl) {
        this.endpointServiceUrl = endpointServiceUrl;
    }

    @Override
    public String getEndpointServiceProtocol() {
        return this.endpointServiceProtocol;
    }

    public void setEndpointServiceProtocol(String endpointServiceProtocol) {
        this.endpointServiceProtocol = endpointServiceProtocol;
    }

    @Override
    public Map<String, String> getEndpointServiceMetadata() {
        return this.endpointServiceMetadata;
    }

    public void setEndpointServiceMetadata(Map<String, String> endpointServiceMetadata) {
        this.endpointServiceMetadata = endpointServiceMetadata;
    }

    public String toString() {
        return "DefaultBacklogTracerEventMessage[" + this.exchangeId + " at " + this.toNode + "]";
    }

    @Override
    public String toXml(int indent) {
        String prefix = " ".repeat(indent);
        StringBuilder sb = new StringBuilder(512);
        sb.append(prefix).append("<").append("backlogTracerEventMessage").append(">\n");
        sb.append(prefix).append("  <uid>").append(this.uid).append("</uid>\n");
        sb.append(prefix).append("  <first>").append(this.first).append("</first>\n");
        sb.append(prefix).append("  <last>").append(this.last).append("</last>\n");
        sb.append(prefix).append("  <rest>").append(this.rest).append("</rest>\n");
        sb.append(prefix).append("  <template>").append(this.template).append("</template>\n");
        String ts = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.timestamp);
        sb.append(prefix).append("  <timestamp>").append(ts).append("</timestamp>\n");
        sb.append(prefix).append("  <elapsed>").append(this.getElapsed()).append("</elapsed>\n");
        sb.append(prefix).append("  <threadName>").append(this.getProcessingThreadName()).append("</threadName>\n");
        sb.append(prefix).append("  <done>").append(this.isDone()).append("</done>\n");
        sb.append(prefix).append("  <failed>").append(this.isFailed()).append("</failed>\n");
        if (this.getLocation() != null) {
            sb.append(prefix).append("  <location>").append(this.getLocation()).append("</location>\n");
        }
        sb.append(prefix).append("  <routeId>").append(this.routeId != null ? this.routeId : "").append("</routeId>\n");
        if (this.endpointUri != null) {
            sb.append(prefix).append("  <endpointUri>").append(this.endpointUri).append("</endpointUri>\n");
            sb.append(prefix).append("  <remoteEndpoint>").append(this.remoteEndpoint).append("</remoteEndpoint>\n");
        }
        if (this.toNode != null) {
            sb.append(prefix).append("  <toNode>").append(this.toNode).append("</toNode>\n");
        } else {
            sb.append(prefix).append("  <toNode>").append(this.routeId).append("</toNode>\n");
        }
        sb.append(prefix).append("  <exchangeId>").append(this.exchangeId).append("</exchangeId>\n");
        if (this.endpointServiceUrl != null) {
            sb.append(prefix).append("  <endpointService>\n");
            sb.append(prefix).append("    <serviceUrl>").append(this.endpointServiceUrl).append("</serviceUrl>\n");
            if (this.endpointServiceProtocol != null) {
                sb.append(prefix).append("    <serviceProtocol>").append(this.endpointServiceProtocol).append("</serviceProtocol>\n");
            }
            if (this.endpointServiceMetadata != null) {
                sb.append(prefix).append("    <serviceMetadata>\n");
                this.endpointServiceMetadata.forEach((k, v) -> sb.append(prefix).append("      <").append((String)k).append(">").append((String)v).append("</").append((String)k).append(">\n"));
                sb.append(prefix).append("    </serviceMetadata>\n");
            }
            sb.append(prefix).append("  </endpointService>\n");
        }
        sb.append(prefix).append(this.getMessageAsXml()).append("\n");
        if (this.getExceptionAsXml() != null) {
            sb.append(prefix).append(this.getExceptionAsXml()).append("\n");
        }
        sb.append(prefix).append("</").append("backlogTracerEventMessage").append(">");
        return sb.toString();
    }

    private String toXML(JsonObject data, int indent) {
        JsonObject jo;
        String value;
        String type;
        JsonObject jo2;
        StringBuilder sb = new StringBuilder(1024);
        String prefix = " ".repeat(indent);
        JsonObject root = (JsonObject)data.getMap("message");
        sb.append(prefix);
        sb.append("<message exchangeId=\"").append(root.getString("exchangeId")).append("\" exchangePattern=\"").append(root.getString("exchangePattern")).append("\" exchangeType=\"").append(root.getString("exchangeType")).append("\" messageType=\"").append(root.getString("messageType")).append("\">\n");
        JsonArray arr = (JsonArray)root.getCollection("exchangeVariables");
        if (arr != null && !arr.isEmpty()) {
            sb.append(prefix);
            sb.append("  <exchangeVariables>\n");
            for (Object entry : arr) {
                jo2 = (JsonObject)entry;
                sb.append(prefix);
                sb.append("    <exchangeVariable key=\"").append(jo2.getString("key")).append("\"");
                type = jo2.getString("type");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                value = jo2.getString("value");
                if (value != null) {
                    try {
                        sb.append(StringHelper.xmlEncode(value));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sb.append("</exchangeVariable>\n");
            }
            sb.append(prefix);
            sb.append("  </exchangeVariables>\n");
        }
        if ((arr = (JsonArray)root.getCollection("exchangeProperties")) != null && !arr.isEmpty()) {
            sb.append(prefix);
            sb.append("  <exchangeProperties>\n");
            for (Object entry : arr) {
                jo2 = (JsonObject)entry;
                sb.append(prefix);
                sb.append("    <exchangeProperty key=\"").append(jo2.getString("key")).append("\"");
                type = jo2.getString("type");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                value = jo2.getString("value");
                if (value != null) {
                    try {
                        sb.append(StringHelper.xmlEncode(value));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sb.append("</exchangeProperty>\n");
            }
            sb.append(prefix);
            sb.append("  </exchangeProperties>\n");
        }
        if ((arr = (JsonArray)root.getCollection("headers")) != null && !arr.isEmpty()) {
            sb.append(prefix);
            sb.append("  <headers>\n");
            for (Object entry : arr) {
                jo2 = (JsonObject)entry;
                sb.append(prefix);
                sb.append("    <header key=\"").append(jo2.getString("key")).append("\"");
                type = jo2.getString("type");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                value = jo2.getString("value");
                if (value != null) {
                    try {
                        sb.append(StringHelper.xmlEncode(value));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sb.append("</header>\n");
            }
            sb.append(prefix);
            sb.append("  </headers>\n");
        }
        if ((jo = (JsonObject)root.getMap("body")) != null) {
            Long position;
            Long size;
            sb.append(prefix);
            sb.append("  <body");
            String type2 = jo.getString("type");
            if (type2 != null) {
                sb.append(" type=\"").append(type2).append("\"");
            }
            if ((size = jo.getLong("size")) != null) {
                sb.append(" size=\"").append(size).append("\"");
            }
            if ((position = jo.getLong("position")) != null) {
                sb.append(" position=\"").append(position).append("\"");
            }
            sb.append(">");
            value = jo.getString("value");
            if (value != null) {
                try {
                    sb.append(StringHelper.xmlEncode(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append("</body>\n");
        }
        sb.append(prefix);
        sb.append("</message>");
        return sb.toString();
    }

    @Override
    public String toJSon(int indent) {
        Jsonable jo = (Jsonable)((Object)this.asJSon());
        if (indent > 0) {
            return Jsoner.prettyPrint(jo.toJson(), indent);
        }
        return Jsoner.prettyPrint(jo.toJson());
    }

    @Override
    public Map<String, Object> asJSon() {
        JsonObject jo = new JsonObject();
        jo.put("uid", this.uid);
        jo.put("first", this.first);
        jo.put("last", this.last);
        jo.put("rest", this.rest);
        jo.put("template", this.template);
        if (this.location != null) {
            jo.put("location", this.location);
        }
        if (this.endpointUri != null) {
            jo.put("endpointUri", this.endpointUri);
            jo.put("remoteEndpoint", this.remoteEndpoint);
        }
        if (this.routeId != null) {
            jo.put("routeId", this.routeId);
        }
        if (this.toNode != null) {
            jo.put("nodeId", this.toNode);
        }
        if (this.exchangeId != null) {
            jo.put("exchangeId", this.exchangeId);
        }
        if (this.timestamp > 0L) {
            jo.put("timestamp", this.timestamp);
        }
        jo.put("elapsed", this.getElapsed());
        jo.put("threadName", this.getProcessingThreadName());
        jo.put("done", this.isDone());
        jo.put("failed", this.isFailed());
        if (this.endpointServiceUrl != null) {
            JsonObject es = new JsonObject();
            es.put("serviceUrl", this.endpointServiceUrl);
            if (this.endpointServiceProtocol != null) {
                es.put("serviceProtocol", this.endpointServiceProtocol);
            }
            if (this.endpointServiceMetadata != null) {
                es.put("serviceMetadata", this.endpointServiceMetadata);
            }
            jo.put("endpointService", es);
        }
        jo.put("message", this.data.getMap("message"));
        if (this.exception != null) {
            if (this.exceptionAsJsonObject == null) {
                try {
                    this.exceptionAsJsonObject = MessageHelper.dumpExceptionAsJSonObject(this.exception);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.exceptionAsJsonObject != null) {
                jo.put("exception", this.exceptionAsJsonObject.get("exception"));
            }
        }
        return jo;
    }
}

