/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelDependencyInjectionAnnotationFactory;
import org.apache.camel.support.PluginHelper;

public class DefaultDependencyInjectionAnnotationFactory
implements CamelDependencyInjectionAnnotationFactory,
CamelContextAware {
    private CamelContext camelContext;

    public DefaultDependencyInjectionAnnotationFactory(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Runnable createBindToRegistryFactory(String id, Object bean2, Class<?> beanType, String beanName, boolean beanPostProcess, String initMethod, String destroyMethod) {
        return () -> {
            if (beanPostProcess) {
                try {
                    CamelBeanPostProcessor beanPostProcessor = PluginHelper.getBeanPostProcessor(this.camelContext);
                    beanPostProcessor.postProcessBeforeInitialization(bean2, beanName);
                    beanPostProcessor.postProcessAfterInitialization(bean2, beanName);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException(e);
                }
            }
            CamelContextAware.trySetCamelContext(bean2, this.camelContext);
            if (bean2 instanceof Supplier) {
                Supplier sup = (Supplier)bean2;
                this.camelContext.getRegistry().bind(id, beanType, sup);
            } else if (initMethod != null || destroyMethod != null) {
                this.camelContext.getRegistry().bind(id, bean2, initMethod, destroyMethod);
            } else {
                this.camelContext.getRegistry().bind(id, bean2);
            }
        };
    }
}

