/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.tokenizer;

import java.util.Optional;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.TokenizerDefinition;
import org.apache.camel.processor.TokenizerProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenizerReifier<T extends TokenizerDefinition>
extends ProcessorReifier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TokenizerReifier.class);
    private static final String TOKENIZER_PATH = "META-INF/services/org/apache/camel/tokenizer/";

    public TokenizerReifier(Route route, T definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(false);
        FactoryFinder factoryFinder = this.camelContext.getCamelContextExtension().getFactoryFinder(TOKENIZER_PATH);
        Optional<Tokenizer> tokenize = factoryFinder.newInstance(((TokenizerDefinition)this.definition).tokenizerName(), Tokenizer.class);
        if (tokenize.isEmpty()) {
            throw new RuntimeCamelException("Cannot find a tokenizer named: " + ((TokenizerDefinition)this.definition).tokenizerName() + " in the classpath");
        }
        Tokenizer tokenizer = tokenize.get();
        LOG.info("Creating a tokenizer of type {}", (Object)tokenizer.getClass().getName());
        this.configure(tokenizer);
        return new TokenizerProcessor(childProcessor, tokenizer);
    }

    protected abstract void configure(Tokenizer var1);
}

