/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.SpringTransactionErrorHandlerBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.errorhandler.ErrorHandlerHelper;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.spring.spi.LegacyTransactionErrorHandlerBuilder;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.spring.spi.TransactionErrorHandlerReifier;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionPolicy
implements TransactedPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SpringTransactionPolicy.class);
    private TransactionTemplate template;
    private String name;
    private String propagationBehaviorName;
    private PlatformTransactionManager transactionManager;

    public SpringTransactionPolicy() {
    }

    public SpringTransactionPolicy(TransactionTemplate template) {
        this.template = template;
    }

    public SpringTransactionPolicy(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void beforeWrap(Route route, NamedNode definition) {
    }

    @Override
    public Processor wrap(Route route, Processor processor) {
        TransactionErrorHandler answer;
        RefErrorHandlerDefinition builderRef;
        String ref;
        RouteDefinition routeDefinition = (RouteDefinition)route.getRoute();
        ErrorHandlerFactory builder = routeDefinition.getErrorHandlerFactory();
        if (builder instanceof RefErrorHandlerDefinition && ErrorHandlerHelper.isErrorHandlerFactoryConfigured(ref = (builderRef = (RefErrorHandlerDefinition)builder).getRef())) {
            LOG.debug("Looking up ErrorHandlerBuilder with ref: {}", (Object)ref);
            builder = ErrorHandlerHelper.lookupErrorHandlerFactory(route, ref, true);
        }
        if (builder != null && builder.supportTransacted()) {
            LOG.debug("The ErrorHandlerBuilder configured is already a TransactionErrorHandlerBuilder: {}", (Object)builder);
            answer = this.createTransactionErrorHandler(route, processor, builder);
        } else {
            if (builder != null) {
                LOG.debug("The ErrorHandlerBuilder configured is not a TransactionErrorHandlerBuilder: {}", (Object)builder);
            } else {
                LOG.debug("No ErrorHandlerBuilder configured, will use default LegacyTransactionErrorHandlerBuilder settings");
            }
            LegacyTransactionErrorHandlerBuilder txBuilder = new LegacyTransactionErrorHandlerBuilder();
            txBuilder.setTransactionTemplate(this.getTransactionTemplate());
            txBuilder.setSpringTransactionPolicy(this);
            if (builder != null) {
                route.addErrorHandlerFactoryReference(builder, txBuilder);
            }
            answer = this.createTransactionErrorHandler(route, processor, txBuilder);
            route.setErrorHandlerFactory(txBuilder);
        }
        return answer;
    }

    protected TransactionErrorHandler createTransactionErrorHandler(Route route, Processor processor, ErrorHandlerFactory builder) {
        TransactionErrorHandler answer;
        try {
            ModelCamelContext mcc = (ModelCamelContext)route.getCamelContext();
            answer = (TransactionErrorHandler)mcc.getModelReifierFactory().createErrorHandler(route, builder, processor);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    public TransactionTemplate getTransactionTemplate() {
        if (this.template == null) {
            ObjectHelper.notNull(this.transactionManager, "transactionManager");
            this.template = new TransactionTemplate(this.transactionManager);
            if (this.name != null) {
                this.template.setName(this.name);
            }
            if (this.propagationBehaviorName != null) {
                this.template.setPropagationBehaviorName(this.propagationBehaviorName);
            }
        }
        return this.template;
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public TransactionTemplate getTemplate() {
        return this.template;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPropagationBehaviorName(String propagationBehaviorName) {
        this.propagationBehaviorName = propagationBehaviorName;
    }

    public String getPropagationBehaviorName() {
        return this.propagationBehaviorName;
    }

    static {
        ErrorHandlerReifier.registerReifier(SpringTransactionErrorHandlerBuilder.class, (route, errorHandlerFactory) -> new TransactionErrorHandlerReifier((Route)route, (SpringTransactionErrorHandlerDefinition)errorHandlerFactory));
        ErrorHandlerReifier.registerReifier(SpringTransactionErrorHandlerDefinition.class, (route, errorHandlerFactory) -> new TransactionErrorHandlerReifier((Route)route, (SpringTransactionErrorHandlerDefinition)errorHandlerFactory));
    }
}

