/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class StringHelper {
    private StringHelper() {
    }

    public static String sanitize(String s) {
        return s.replace(':', '-').replace('_', '-').replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    public static String removeCRLF(String s) {
        return s.replace("\r", "").replace("\n", "");
    }

    public static int countChar(String s, char ch) {
        return StringHelper.countChar(s, ch, -1);
    }

    public static int countChar(String s, char ch, int end) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int matches = 0;
        int len = end < 0 ? s.length() : end;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s.charAt(i2);
            if (ch != c) continue;
            ++matches;
        }
        return matches;
    }

    public static String limitLength(String s, int maxLength) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        return s.length() <= maxLength ? s : s.substring(0, maxLength);
    }

    public static String removeQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        return s.replace("'", "").replace("\"", "");
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.length() < 2) {
            return s;
        }
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String s) {
        return StringHelper.isSingleQuoted(s) || StringHelper.isDoubleQuoted(s);
    }

    public static boolean isSingleQuoted(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return false;
        }
        return s.startsWith("'") && s.endsWith("'");
    }

    public static boolean isDoubleQuoted(String s) {
        if (ObjectHelper.isEmpty(s)) {
            return false;
        }
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String xmlEncode(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String xmlDecode(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&amp;", "&").replace("&quot;", "\"").replace("&apos;", "'").replace("&lt;", "<").replace("&gt;", ">");
    }

    public static boolean hasUpperCase(String text) {
        if (text == null) {
            return false;
        }
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char ch = text.charAt(i2);
            if (!Character.isUpperCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassName(String text) {
        if (text != null) {
            int lastIndexOf = text.lastIndexOf(46);
            if (lastIndexOf <= 0) {
                return false;
            }
            return Character.isUpperCase(text.charAt(lastIndexOf + 1));
        }
        return false;
    }

    public static boolean hasStartToken(String expression, String language) {
        if (expression == null) {
            return false;
        }
        if ("simple".equalsIgnoreCase(language) && expression.contains("${")) {
            return true;
        }
        return language != null && expression.contains("$" + language + "{");
    }

    public static String replaceFirst(String input, String from, String to) {
        if (from == null || to == null) {
            return input;
        }
        int pos = input.indexOf(from);
        if (pos != -1) {
            int len = from.length();
            return input.substring(0, pos) + to + input.substring(pos + len);
        }
        return input;
    }

    public static String toJson(String name, String value, boolean isMap) {
        if (isMap) {
            return "{ " + StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value) + " }";
        }
        return StringQuoteHelper.doubleQuote(name) + ": " + StringQuoteHelper.doubleQuote(value);
    }

    public static String notEmpty(String value, String name) {
        if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty");
        }
        return value;
    }

    public static String notEmpty(String value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty on: " + String.valueOf(on));
        }
        return value;
    }

    public static String[] splitOnCharacter(String value, String needle, int count) {
        String[] rc = new String[count];
        rc[0] = value;
        for (int i2 = 1; i2 < count; ++i2) {
            String v = rc[i2 - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i2 - 1] = v.substring(0, p);
            rc[i2] = v.substring(p + 1);
        }
        return rc;
    }

    public static Iterator<String> splitOnCharacterAsIterator(String value, final char needle, int count) {
        boolean skipEnd;
        int end = value.length() - 1;
        boolean skipStart = value.charAt(0) == needle;
        boolean bl = skipEnd = value.charAt(end) == needle;
        if (skipStart && skipEnd) {
            value = value.substring(1, end);
            count -= 2;
        } else if (skipStart) {
            value = value.substring(1);
            --count;
        } else if (skipEnd) {
            value = value.substring(0, end);
            --count;
        }
        final int size = count;
        final String text = value;
        return new Iterator<String>(){
            int i;
            int pos;

            @Override
            public boolean hasNext() {
                return this.i < size;
            }

            @Override
            public String next() {
                String answer;
                if (this.i == size) {
                    throw new NoSuchElementException();
                }
                int end = text.indexOf(needle, this.pos);
                if (end != -1) {
                    answer = text.substring(this.pos, end);
                    this.pos = end + 1;
                } else {
                    answer = text.substring(this.pos);
                    this.i = size;
                }
                return answer;
            }
        };
    }

    public static List<String> splitOnCharacterAsList(String value, char needle, int count) {
        boolean skipEnd;
        int end = value.length() - 1;
        boolean skipStart = value.charAt(0) == needle;
        boolean bl = skipEnd = value.charAt(end) == needle;
        if (skipStart && skipEnd) {
            value = value.substring(1, end);
            count -= 2;
        } else if (skipStart) {
            value = value.substring(1);
            --count;
        } else if (skipEnd) {
            value = value.substring(0, end);
            --count;
        }
        ArrayList<String> rc = new ArrayList<String>(count);
        int pos = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            end = value.indexOf(needle, pos);
            if (end == -1) {
                rc.add(value.substring(pos));
                break;
            }
            String part = value.substring(pos, end);
            pos = end + 1;
            rc.add(part);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    public static String capitalize(String text) {
        return StringHelper.capitalize(text, false);
    }

    public static String capitalize(String text, boolean dashToCamelCase) {
        String ret = text;
        if (dashToCamelCase) {
            ret = StringHelper.dashToCamelCase(text);
        }
        return StringHelper.doCapitalize(ret);
    }

    private static String doCapitalize(String ret) {
        if (ret == null) {
            return null;
        }
        char[] chars = ret.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isDashed(String text) {
        return !text.isEmpty() && text.indexOf(45) != -1;
    }

    public static String dashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        if (!StringHelper.isDashed(text)) {
            return text;
        }
        int length = text.length();
        StringBuilder sb = new StringBuilder(length - 1);
        boolean upper = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = text.charAt(i2);
            if (c == '-') {
                upper = true;
                continue;
            }
            if (upper) {
                c = Character.toUpperCase(c);
                upper = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String skippingDashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        if (!StringHelper.isDashed(text)) {
            return text;
        }
        int length = text.length();
        StringBuilder sb = new StringBuilder(length - 1);
        boolean upper = false;
        int singleQuotes = 0;
        int doubleQuotes = 0;
        boolean skip = false;
        for (int i2 = 0; i2 < length; ++i2) {
            char c = text.charAt(i2);
            if (c == ']') {
                skip = false;
            } else if (c == '[') {
                skip = true;
            } else if (c == '\'') {
                ++singleQuotes;
            } else if (c == '\"') {
                ++doubleQuotes;
            }
            if (singleQuotes > 0) {
                boolean bl = skip = singleQuotes % 2 == 1;
            }
            if (doubleQuotes > 0) {
                boolean bl = skip = doubleQuotes % 2 == 1;
            }
            if (skip) {
                sb.append(c);
                continue;
            }
            if (c == '-') {
                upper = true;
                continue;
            }
            if (upper) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
            upper = false;
        }
        return sb.toString();
    }

    public static String dashToCamelCase(String text, boolean skipQuotedOrKeyed) {
        if (!skipQuotedOrKeyed) {
            return StringHelper.dashToCamelCase(text);
        }
        return StringHelper.skippingDashToCamelCase(text);
    }

    public static String after(String text, String after) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf(after);
        if (pos == -1) {
            return null;
        }
        return text.substring(pos + after.length());
    }

    public static String after(String text, String after, String defaultValue) {
        String answer = StringHelper.after(text, after);
        return answer != null ? answer : defaultValue;
    }

    public static <T> Optional<T> after(String text, String after, Function<String, T> mapper) {
        String result = StringHelper.after(text, after);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String afterLast(String text, String after) {
        if (text == null) {
            return null;
        }
        int pos = text.lastIndexOf(after);
        if (pos == -1) {
            return null;
        }
        return text.substring(pos + after.length());
    }

    public static String afterLast(String text, String after, String defaultValue) {
        String answer = StringHelper.afterLast(text, after);
        return answer != null ? answer : defaultValue;
    }

    public static String before(String text, String before) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf(before);
        return pos == -1 ? null : text.substring(0, pos);
    }

    public static String before(String text, String before, String defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        int pos = text.indexOf(before);
        return pos == -1 ? defaultValue : text.substring(0, pos);
    }

    public static String before(String text, char before, String defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        int pos = text.indexOf(before);
        return pos == -1 ? defaultValue : text.substring(0, pos);
    }

    public static <T> Optional<T> before(String text, String before, Function<String, T> mapper) {
        String result = StringHelper.before(text, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String beforeLast(String text, String before) {
        if (text == null) {
            return null;
        }
        int pos = text.lastIndexOf(before);
        return pos == -1 ? null : text.substring(0, pos);
    }

    public static String beforeLast(String text, String before, String defaultValue) {
        String answer = StringHelper.beforeLast(text, before);
        return answer != null ? answer : defaultValue;
    }

    public static String between(String text, String after, String before) {
        String ret = StringHelper.after(text, after);
        if (ret == null) {
            return null;
        }
        return StringHelper.before(ret, before);
    }

    public static <T> Optional<T> between(String text, String after, String before, Function<String, T> mapper) {
        String result = StringHelper.between(text, after, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String between(String text, int head, int tail) {
        int len = text.length();
        if (head > 0) {
            text = head <= len ? text.substring(head) : "";
            len = text.length();
        }
        if (tail > 0) {
            text = tail <= len ? text.substring(0, len - tail) : "";
        }
        return text;
    }

    public static String betweenOuterPair(String text, char before, char after) {
        if (text == null) {
            return null;
        }
        int pos = -1;
        int pos2 = -1;
        int count = 0;
        int count2 = 0;
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char ch = text.charAt(i2);
            if (!doubleQuoted && ch == '\'') {
                singleQuoted = !singleQuoted;
            } else if (!singleQuoted && ch == '\"') {
                boolean bl = doubleQuoted = !doubleQuoted;
            }
            if (singleQuoted || doubleQuoted) continue;
            if (ch == before) {
                ++count;
            } else if (ch == after) {
                ++count2;
            }
            if (ch == before && pos == -1) {
                pos = i2;
                continue;
            }
            if (ch != after) continue;
            pos2 = i2;
        }
        if (pos == -1 || pos2 == -1) {
            return null;
        }
        if (count != count2) {
            return null;
        }
        return text.substring(pos + 1, pos2);
    }

    public static <T> Optional<T> betweenOuterPair(String text, char before, char after, Function<String, T> mapper) {
        String result = StringHelper.betweenOuterPair(text, before, after);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i2 = 1; i2 < size; ++i2) {
                if (Character.isJavaIdentifierPart(name.charAt(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizeClassName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (char ch : name.toCharArray()) {
            if (ch != '.' && ch != '[' && ch != ']' && ch != '-' && !Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static List<Integer> changedLines(String oldText, String newText) {
        if (oldText == null || oldText.equals(newText)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> changed = new ArrayList<Integer>();
        String[] oldLines = oldText.split("\n");
        String[] newLines = newText.split("\n");
        for (int i2 = 0; i2 < newLines.length; ++i2) {
            String oldLine;
            String newLine = newLines[i2];
            String string = oldLine = i2 < oldLines.length ? oldLines[i2] : null;
            if (oldLine == null) {
                changed.add(i2);
                continue;
            }
            if (newLine.equals(oldLine)) continue;
            changed.add(i2);
        }
        return changed;
    }

    public static String trimToNull(String given) {
        if (given == null) {
            return null;
        }
        String trimmed = given.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed;
    }

    public static boolean containsIgnoreCase(String src, String what) {
        if (src == null || what == null) {
            return false;
        }
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i2 = src.length() - length; i2 >= 0; --i2) {
            char ch = src.charAt(i2);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i2, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String humanReadableBytes(Locale locale, long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf("KMGTPE".charAt(exp - 1));
        return String.format(locale, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableBytes(long bytes) {
        return StringHelper.humanReadableBytes(Locale.getDefault(), bytes);
    }

    public static boolean matches(String pattern, String target) {
        if (Objects.equals(pattern, target)) {
            return true;
        }
        if (Objects.isNull(pattern)) {
            return true;
        }
        if (Objects.equals("*", pattern)) {
            return true;
        }
        if (AntPathMatcher.INSTANCE.match(pattern, target)) {
            return true;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(target);
        return m.matches();
    }

    public static String camelCaseToDash(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        char prev = '\u0000';
        char[] arr = text.toCharArray();
        StringBuilder answer = new StringBuilder(arr.length < 13 ? 16 : arr.length + 8);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            char ch = arr[i2];
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != '\u0000') {
                char next = i2 < arr.length - 1 ? arr[i2 + 1] : (char)'\u0000';
                if (!Character.isUpperCase(prev) || next != '\u0000' && Character.isLowerCase(next)) {
                    StringHelper.applyDashPrefix(prev, answer, ch);
                } else {
                    answer.append(Character.toLowerCase(ch));
                }
            } else {
                answer.append(Character.toLowerCase(ch));
            }
            prev = ch;
        }
        return answer.toString();
    }

    private static void applyDashPrefix(char prev, StringBuilder answer, char ch) {
        if (prev != '-' && prev != '_') {
            answer.append("-");
        }
        answer.append(Character.toLowerCase(ch));
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text != null && prefix != null) {
            return prefix.length() <= text.length() && text.regionMatches(true, 0, prefix, 0, prefix.length());
        }
        return text == null && prefix == null;
    }

    public static String asEnumConstantValue(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        String ret = StringHelper.camelCaseToDash(value);
        ret = ret.replaceAll("-+", "-");
        ret = ret.replace('-', '_').toUpperCase(Locale.ENGLISH);
        return ret;
    }

    public static String[] splitWords(String text) {
        return text.split("[\\W]+");
    }

    public static Stream<String> splitAsStream(CharSequence text, String regex) {
        if (text == null || regex == null) {
            return Stream.empty();
        }
        return Pattern.compile(regex).splitAsStream(text);
    }

    public static int countOccurrence(String text, String search) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = text.indexOf(search, lastIndex)) == -1) continue;
            ++count;
            lastIndex += search.length();
        }
        return count;
    }

    public static String replaceFromSecondOccurrence(String text, String search, String replacement) {
        int index = ((String)text).indexOf(search);
        boolean replace = false;
        while (index != -1) {
            String tempString = ((String)text).substring(index);
            if (replace) {
                tempString = tempString.replaceFirst(search, replacement);
                text = ((String)text).substring(0, index) + tempString;
                replace = false;
            } else {
                replace = true;
            }
            index = ((String)text).indexOf(search, index + 1);
        }
        return text;
    }

    public static String padString(int level) {
        return StringHelper.padString(level, 2);
    }

    public static String padString(int level, int blanks) {
        if (level == 0) {
            return "";
        }
        return " ".repeat(level * blanks);
    }

    public static String fillChars(char ch, int count) {
        if (count <= 0) {
            return "";
        }
        return Character.toString(ch).repeat(count);
    }

    public static boolean isDigit(String s) {
        for (char ch : s.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static String bytesToHex(byte[] hash) {
        StringBuilder sb = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

