/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.component.activemq.ActiveMQComponent;
import org.apache.camel.component.activemq.ActiveMQConfiguration;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="1.0.0", extendsScheme="jms", scheme="activemq", title="ActiveMQ 5.x", syntax="activemq:destinationType:destinationName", category={Category.MESSAGING})
public class ActiveMQEndpoint
extends JmsEndpoint
implements EndpointServiceLocation {
    @UriParam(multiValue=true, prefix="destination.", label="consumer,advanced")
    private Map<String, String> destinationOptions;

    public ActiveMQEndpoint() {
    }

    public ActiveMQEndpoint(String uri, JmsComponent component, String destinationName, boolean pubSubDomain, JmsConfiguration configuration) {
        super(uri, component, destinationName, pubSubDomain, configuration);
    }

    public ActiveMQEndpoint(String endpointUri, JmsBinding binding, JmsConfiguration configuration, String destinationName, boolean pubSubDomain) {
        super(endpointUri, binding, configuration, destinationName, pubSubDomain);
    }

    public ActiveMQEndpoint(String endpointUri, String destinationName, boolean pubSubDomain) {
        super(endpointUri, destinationName, pubSubDomain);
    }

    public ActiveMQEndpoint(String endpointUri, String destinationName) {
        super(endpointUri, destinationName);
    }

    @Override
    public String getServiceUrl() {
        String url = null;
        Object object = this.getConfiguration();
        if (object instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration acc = (ActiveMQConfiguration)object;
            url = acc.getBrokerURL();
        }
        if (url == null && (object = this.getComponent()) instanceof ActiveMQComponent) {
            ActiveMQComponent amq = (ActiveMQComponent)object;
            url = amq.getBrokerURL();
        }
        return url;
    }

    @Override
    public String getServiceProtocol() {
        return "jms";
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        String un = null;
        String cid = null;
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration acc = (ActiveMQConfiguration)jmsConfiguration;
            un = acc.getUsername();
            cid = acc.getClientId();
        }
        if (un == null) {
            un = this.getComponent().getUsername();
        }
        if (cid == null) {
            cid = this.getClientId();
        }
        if (un == null && cid == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (un != null) {
            map.put("username", un);
        }
        if (cid != null) {
            map.put("clientId", cid);
        }
        return map;
    }

    public Map<String, String> getDestinationOptions() {
        return this.destinationOptions;
    }

    public void setDestinationOptions(Map<String, String> destinationOptions) {
        this.destinationOptions = destinationOptions;
    }
}

