/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.spi.AnnotationScanTypeConverters;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeConverter
extends BaseTypeConverterRegistry
implements AnnotationScanTypeConverters {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTypeConverter.class);
    private volatile boolean loadTypeConvertersDone;
    private final boolean loadTypeConverters;

    public DefaultTypeConverter(PackageScanClassResolver resolver, Injector injector, boolean loadTypeConverters, boolean statisticsEnabled) {
        this(null, resolver, injector, loadTypeConverters, statisticsEnabled);
    }

    public DefaultTypeConverter(CamelContext camelContext, PackageScanClassResolver resolver, Injector injector, boolean loadTypeConverters, boolean statisticsEnabled) {
        super(camelContext, resolver, injector, statisticsEnabled);
        this.loadTypeConverters = loadTypeConverters;
    }

    @Override
    public boolean isRunAllowed() {
        return true;
    }

    @Override
    protected void doInit() throws Exception {
        StopWatch watch = new StopWatch();
        super.doInit();
        this.loadCoreAndFastTypeConverters();
        String time = TimeUtils.printDuration(watch.taken(), true);
        LOG.debug("Loaded {} type converters in {}", (Object)this.size(), (Object)time);
        if (!this.loadTypeConvertersDone && this.isLoadTypeConverters()) {
            this.scanTypeConverters();
        }
    }

    private boolean isLoadTypeConverters() {
        boolean load = this.loadTypeConverters;
        if (this.camelContext != null) {
            load = this.camelContext.isLoadTypeConverters();
        }
        return load;
    }

    @Override
    public void scanTypeConverters() throws Exception {
        StopWatch watch = new StopWatch();
        if (!this.loadTypeConvertersDone) {
            this.loadTypeConvertersDone = true;
            if (this.resolver != null) {
                this.typeConverterLoaders.add(this.createScanTypeConverterLoader());
            }
            this.loadTypeConverters();
            if (this.resolver != null) {
                this.resolver.clearCache();
            }
        }
        String time = TimeUtils.printDuration(watch.taken(), true);
        LOG.debug("Loaded {} type converters in {}", (Object)this.size(), (Object)time);
    }

    protected TypeConverterLoader createScanTypeConverterLoader() {
        String basePackages = this.camelContext != null ? this.camelContext.getCamelContextExtension().getBasePackageScan() : null;
        return new AnnotationTypeConverterLoader(this.resolver, basePackages);
    }
}

