/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq6;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.activemq6.ActiveMQConfiguration;
import org.apache.camel.component.activemq6.ActiveMQEndpoint;
import org.apache.camel.component.activemq6.ActiveMQQueueEndpoint;
import org.apache.camel.component.activemq6.ActiveMQTemporaryQueueEndpoint;
import org.apache.camel.component.activemq6.ActiveMQTemporaryTopicEndpoint;
import org.apache.camel.component.activemq6.OriginalDestinationPropagateStrategy;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.SingleConnectionFactory;

@Component(value="activemq6")
public class ActiveMQComponent
extends JmsComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQComponent.class);
    private final CopyOnWriteArrayList<SingleConnectionFactory> singleConnectionFactoryList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Object> pooledConnectionFactoryServiceList = new CopyOnWriteArrayList();
    private boolean embedded;

    public ActiveMQComponent() {
    }

    public ActiveMQComponent(CamelContext context) {
        super(context);
    }

    public ActiveMQComponent(ActiveMQConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public static ActiveMQComponent activeMQComponent() {
        return new ActiveMQComponent();
    }

    public static ActiveMQComponent activeMQComponent(String brokerURL) {
        ActiveMQComponent answer = new ActiveMQComponent();
        if (answer.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)answer.getConfiguration()).setBrokerURL(brokerURL);
        }
        return answer;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    @Metadata(label="common")
    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
        if (embedded) {
            this.setBrokerURL("vm://localhost?broker.persistent=false");
            LOG.info("Using embedded in-memory ActiveMQ broker (you must have activemq-broker JAR added as dependency)");
        }
    }

    public String getBrokerURL() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.getBrokerURL();
        }
        return null;
    }

    @Metadata(label="common")
    public void setBrokerURL(String brokerURL) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setBrokerURL(brokerURL);
        }
    }

    @Metadata(defaultValue="false", label="advanced")
    public void setTrustAllPackages(boolean trustAllPackages) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setTrustAllPackages(trustAllPackages);
        }
    }

    public boolean isTrustAllPackages() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.isTrustAllPackages();
        }
        return false;
    }

    @Metadata(defaultValue="true", label="common")
    public void setUsePooledConnection(boolean usePooledConnection) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setUsePooledConnection(usePooledConnection);
        }
    }

    public boolean isUsePooledConnection() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.isUsePooledConnection();
        }
        return true;
    }

    @Metadata(defaultValue="false", label="common")
    public void setUseSingleConnection(boolean useSingleConnection) {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            activeMQConfiguration.setUseSingleConnection(useSingleConnection);
        }
    }

    public boolean isUseSingleConnection() {
        JmsConfiguration jmsConfiguration = this.getConfiguration();
        if (jmsConfiguration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)jmsConfiguration;
            return activeMQConfiguration.isUseSingleConnection();
        }
        return false;
    }

    @Override
    protected void setProperties(Endpoint bean2, Map<String, Object> parameters) throws Exception {
        Object usePooledConnection;
        Object useSingleConnection = parameters.remove("useSingleConnection");
        if (useSingleConnection != null) {
            ((ActiveMQConfiguration)((JmsEndpoint)bean2).getConfiguration()).setUseSingleConnection(PropertyConfigurerSupport.property(this.getCamelContext(), Boolean.TYPE, useSingleConnection));
        }
        if ((usePooledConnection = parameters.remove("usePooledConnection")) != null) {
            ((ActiveMQConfiguration)((JmsEndpoint)bean2).getConfiguration()).setUsePooledConnection(PropertyConfigurerSupport.property(this.getCamelContext(), Boolean.TYPE, usePooledConnection));
        }
        super.setProperties(bean2, parameters);
    }

    protected void addPooledConnectionFactoryService(Object pooledConnectionFactoryService) {
        this.pooledConnectionFactoryServiceList.add(pooledConnectionFactoryService);
    }

    protected void addSingleConnectionFactory(SingleConnectionFactory singleConnectionFactory) {
        this.singleConnectionFactoryList.add(singleConnectionFactory);
    }

    @Override
    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        Map<String, Object> options = PropertiesHelper.extractProperties(parameters, "destination.");
        String query = URISupport.createQueryString(options);
        if (ObjectHelper.isNotEmpty(query)) {
            return path + "?" + query;
        }
        return path;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.getMessageCreatedStrategy() == null) {
            this.setMessageCreatedStrategy(new OriginalDestinationPropagateStrategy());
        }
    }

    @Override
    protected void doStop() throws Exception {
        for (Object object : this.pooledConnectionFactoryServiceList) {
            try {
                Method m = object.getClass().getMethod("stop", new Class[0]);
                org.apache.camel.support.ObjectHelper.invokeMethod(m, object, new Object[0]);
            }
            catch (Exception exception) {}
        }
        this.pooledConnectionFactoryServiceList.clear();
        for (SingleConnectionFactory singleConnectionFactory : this.singleConnectionFactoryList) {
            try {
                singleConnectionFactory.destroy();
            }
            catch (Exception exception) {}
        }
        this.singleConnectionFactoryList.clear();
        super.doStop();
    }

    @Override
    public void setConfiguration(JmsConfiguration configuration) {
        if (configuration instanceof ActiveMQConfiguration) {
            ActiveMQConfiguration activeMQConfiguration = (ActiveMQConfiguration)configuration;
            activeMQConfiguration.setActiveMQComponent(this);
        }
        super.setConfiguration(configuration);
    }

    @Override
    protected JmsConfiguration createConfiguration() {
        ActiveMQConfiguration answer = new ActiveMQConfiguration();
        answer.setActiveMQComponent(this);
        return answer;
    }

    @Override
    protected JmsEndpoint createTemporaryTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new ActiveMQTemporaryTopicEndpoint(uri, component, subject, configuration);
    }

    @Override
    protected JmsEndpoint createTopicEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration) {
        return new ActiveMQEndpoint(uri, component, subject, true, configuration);
    }

    @Override
    protected JmsEndpoint createTemporaryQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new ActiveMQTemporaryQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }

    @Override
    protected JmsEndpoint createQueueEndpoint(String uri, JmsComponent component, String subject, JmsConfiguration configuration, QueueBrowseStrategy queueBrowseStrategy) {
        return new ActiveMQQueueEndpoint(uri, component, subject, configuration, queueBrowseStrategy);
    }
}

