/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsBrowsableEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.springframework.jms.core.JmsOperations;

public class DefaultQueueBrowseStrategy
implements QueueBrowseStrategy {
    @Override
    public List<Exchange> browse(JmsOperations template, String queue, JmsBrowsableEndpoint endpoint) {
        if (endpoint.getSelector() != null) {
            return template.browseSelected(queue, endpoint.getSelector(), (session, browser) -> DefaultQueueBrowseStrategy.doBrowse(endpoint, session, browser));
        }
        return template.browse(queue, (session, browser) -> DefaultQueueBrowseStrategy.doBrowse(endpoint, session, browser));
    }

    private static List<Exchange> doBrowse(JmsBrowsableEndpoint endpoint, Session session, QueueBrowser browser) throws JMSException {
        int size = endpoint.getMaximumBrowseSize();
        if (size <= 0) {
            size = Integer.MAX_VALUE;
        }
        ArrayList<Exchange> answer = new ArrayList<Exchange>();
        Enumeration iter = browser.getEnumeration();
        for (int i2 = 0; i2 < size && iter.hasMoreElements(); ++i2) {
            Message message = (Message)iter.nextElement();
            Exchange exchange = endpoint.createExchange(message, session);
            answer.add(exchange);
        }
        return answer;
    }
}

