/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.processor.aggregate.AggregationStrategyMethodInfo;
import org.apache.camel.processor.aggregate.AggregationStrategyParameterInfo;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStrategyBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationStrategyBeanInfo.class);
    private final Class<?> type;
    private final Method method;

    public AggregationStrategyBeanInfo(Class<?> type, Method method) {
        this.type = type;
        this.method = method;
    }

    protected AggregationStrategyMethodInfo createMethodInfo() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        int size = parameterTypes.length;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating MethodInfo for class: {} method: {} having {} parameters", new Object[]{this.type, this.method, size});
        }
        if (size < 2) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have at least two parameters, has: " + size);
        }
        if (size % 2 != 0) {
            throw new IllegalArgumentException("The method " + this.method.getName() + " must have equal number of parameters, has: " + size);
        }
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        for (int i2 = 0; i2 < parameterAnnotations.length; ++i2) {
            Annotation[] annotations = parameterAnnotations[i2];
            if (annotations.length <= 0) continue;
            throw new IllegalArgumentException("Method parameter annotation: " + annotations[0] + " at index: " + i2 + " is not supported on method: " + this.method);
        }
        ArrayList<AggregationStrategyParameterInfo> oldParameters = new ArrayList<AggregationStrategyParameterInfo>();
        for (int i3 = 0; i3 < size / 2; ++i3) {
            AggregationStrategyBeanInfo.addParameters(parameterTypes, i3, oldParameters);
        }
        ArrayList<AggregationStrategyParameterInfo> newParameters = new ArrayList<AggregationStrategyParameterInfo>();
        for (int i4 = size / 2; i4 < size; ++i4) {
            AggregationStrategyBeanInfo.addParameters(parameterTypes, i4, newParameters);
        }
        return new AggregationStrategyMethodInfo(this.method, oldParameters, newParameters);
    }

    private static void addParameters(Class<?>[] parameterTypes, int i2, List<AggregationStrategyParameterInfo> parameters) {
        Class<?> parameterType = parameterTypes[i2];
        if (parameters.isEmpty()) {
            Expression body = ExpressionBuilder.mandatoryBodyExpression(parameterType);
            AggregationStrategyParameterInfo info = new AggregationStrategyParameterInfo(i2, parameterType, body);
            parameters.add(info);
        } else if (parameters.size() == 1) {
            Expression headersExpression = ExpressionBuilder.headersExpression();
            AggregationStrategyParameterInfo info = new AggregationStrategyParameterInfo(i2, parameterType, headersExpression);
            parameters.add(info);
        } else if (parameters.size() == 2) {
            Expression properties = ExpressionBuilder.exchangePropertiesExpression();
            AggregationStrategyParameterInfo info = new AggregationStrategyParameterInfo(i2, parameterType, properties);
            parameters.add(info);
        }
    }
}

