/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.jndi;

import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.JmsQueue;
import org.apache.qpid.jms.JmsTopic;
import org.apache.qpid.jms.jndi.LazyCreateContext;
import org.apache.qpid.jms.jndi.ReadOnlyContext;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.util.VariableExpansion;

public class JmsInitialContextFactory
implements InitialContextFactory {
    static final String[] DEFAULT_CONNECTION_FACTORY_NAMES = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    static final String CONNECTION_FACTORY_KEY_PREFIX = "connectionfactory.";
    static final String QUEUE_KEY_PREFIX = "queue.";
    static final String TOPIC_KEY_PREFIX = "topic.";
    static final String CONNECTION_FACTORY_DEFAULT_KEY_PREFIX = "default.connectionfactory.";
    static final String CONNECTION_FACTORY_PROPERTY_KEY_PREFIX = "property.connectionfactory.";
    static final String DYNAMIC_QUEUES = "dynamicQueues";
    static final String DYNAMIC_TOPICS = "dynamicTopics";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment2) throws NamingException {
        Hashtable<Object, Object> environmentCopy;
        block12: {
            environmentCopy = new Hashtable<Object, Object>();
            environmentCopy.putAll(environment2);
            String location = null;
            location = environmentCopy.containsKey("java.naming.provider.url") ? (String)environment2.get("java.naming.provider.url") : System.getProperty("java.naming.provider.url");
            boolean providerUri = false;
            if (location != null) {
                try {
                    String expanded = JmsInitialContextFactory.expand(location, environmentCopy);
                    if (ProviderFactory.findProviderFactory(new URI(expanded)) != null) {
                        environmentCopy.put("default.connectionfactory.remoteURI", expanded);
                        providerUri = true;
                    }
                }
                catch (IOException | URISyntaxException expanded) {
                    // empty catch block
                }
            }
            try {
                BufferedInputStream inputStream;
                if (providerUri || location == null) break block12;
                try {
                    URL fileURL = new URL(location);
                    inputStream = new BufferedInputStream(fileURL.openStream());
                }
                catch (MalformedURLException e) {
                    inputStream = new BufferedInputStream(new FileInputStream(location));
                }
                Properties p = new Properties();
                try {
                    p.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    environmentCopy.put(key, value);
                }
            }
            catch (IOException ioe) {
                NamingException ne = new NamingException("Unable to load property file: " + location + ".");
                ne.initCause(ioe);
                throw ne;
            }
        }
        ConcurrentHashMap<String, Object> bindings = new ConcurrentHashMap<String, Object>();
        this.createConnectionFactories(environmentCopy, bindings);
        this.createQueues(environmentCopy, bindings);
        this.createTopics(environmentCopy, bindings);
        bindings.put(DYNAMIC_QUEUES, new LazyCreateContext(){
            private static final long serialVersionUID = 6503881346214855588L;

            @Override
            protected Object createEntry(String name) {
                return new JmsQueue(name);
            }
        });
        bindings.put(DYNAMIC_TOPICS, new LazyCreateContext(){
            private static final long serialVersionUID = 2019166796234979615L;

            @Override
            protected Object createEntry(String name) {
                return new JmsTopic(name);
            }
        });
        return this.createContext(environmentCopy, bindings);
    }

    private void createConnectionFactories(Hashtable<Object, Object> environment2, Map<String, Object> bindings) throws NamingException {
        Map<String, String> factories = this.getConnectionFactoryNamesAndURIs(environment2);
        Map<String, String> defaults = this.getConnectionFactoryDefaults(environment2);
        for (Map.Entry<String, String> entry : factories.entrySet()) {
            String name = entry.getKey();
            String uri = entry.getValue();
            JmsConnectionFactory factory = null;
            try {
                factory = this.createConnectionFactory(name, uri, defaults, environment2);
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Exception while creating ConnectionFactory '" + name + "'.");
                ne.initCause(e);
                throw ne;
            }
            bindings.put(name, factory);
        }
    }

    protected ReadOnlyContext createContext(Hashtable<Object, Object> environment2, Map<String, Object> bindings) {
        return new ReadOnlyContext(environment2, bindings);
    }

    protected JmsConnectionFactory createConnectionFactory(String name, String uri, Map<String, String> defaults, Hashtable<Object, Object> environment2) throws URISyntaxException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.putAll(defaults);
        if (uri != null && !uri.trim().isEmpty()) {
            props.put("remoteURI", uri);
        }
        props.putAll(this.getConnectionFactoryProperties(name, environment2));
        return this.createConnectionFactory(props);
    }

    protected Map<String, String> getConnectionFactoryNamesAndURIs(Map<Object, Object> environment2) {
        LinkedHashMap<String, String> factories = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : environment2.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.toLowerCase().startsWith(CONNECTION_FACTORY_KEY_PREFIX)) continue;
            String factoryName = key.substring(CONNECTION_FACTORY_KEY_PREFIX.length());
            String value = null;
            if (entry.getValue() != null) {
                value = String.valueOf(entry.getValue());
            }
            factories.put(factoryName, JmsInitialContextFactory.expand(value, environment2));
        }
        if (factories.isEmpty()) {
            for (int i2 = 0; i2 < DEFAULT_CONNECTION_FACTORY_NAMES.length; ++i2) {
                factories.put(DEFAULT_CONNECTION_FACTORY_NAMES[i2], null);
            }
        }
        return factories;
    }

    protected Map<String, String> getConnectionFactoryDefaults(Map<Object, Object> environment2) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("remoteURI", JmsConnectionFactory.getDefaultRemoteAddress());
        for (Map.Entry<Object, Object> entry : environment2.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.toLowerCase().startsWith(CONNECTION_FACTORY_DEFAULT_KEY_PREFIX)) continue;
            String jndiName = key.substring(CONNECTION_FACTORY_DEFAULT_KEY_PREFIX.length());
            String value = String.valueOf(entry.getValue());
            map.put(jndiName, JmsInitialContextFactory.expand(value, environment2));
        }
        return Collections.unmodifiableMap(map);
    }

    protected Map<String, String> getConnectionFactoryProperties(String factoryName, Map<Object, Object> environment2) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String factoryNameSuffix = factoryName + ".";
        for (Map.Entry<Object, Object> entry : environment2.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (!key.toLowerCase().startsWith(CONNECTION_FACTORY_PROPERTY_KEY_PREFIX) || !key.substring(CONNECTION_FACTORY_PROPERTY_KEY_PREFIX.length()).startsWith(factoryNameSuffix)) continue;
            String propertyName = key.substring(CONNECTION_FACTORY_PROPERTY_KEY_PREFIX.length() + factoryNameSuffix.length());
            String value = String.valueOf(entry.getValue());
            map.put(propertyName, JmsInitialContextFactory.expand(value, environment2));
        }
        return map;
    }

    protected void createQueues(Hashtable<Object, Object> environment2, Map<String, Object> bindings) {
        for (Map.Entry<Object, Object> entry : environment2.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(QUEUE_KEY_PREFIX)) continue;
            String jndiName = key.substring(QUEUE_KEY_PREFIX.length());
            String value = JmsInitialContextFactory.expand(entry.getValue().toString(), environment2);
            bindings.put(jndiName, this.createQueue(value));
        }
    }

    protected void createTopics(Hashtable<Object, Object> environment2, Map<String, Object> bindings) {
        for (Map.Entry<Object, Object> entry : environment2.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(TOPIC_KEY_PREFIX)) continue;
            String jndiName = key.substring(TOPIC_KEY_PREFIX.length());
            String value = JmsInitialContextFactory.expand(entry.getValue().toString(), environment2);
            bindings.put(jndiName, this.createTopic(value));
        }
    }

    protected Queue createQueue(String name) {
        return new JmsQueue(name);
    }

    protected Topic createTopic(String name) {
        return new JmsTopic(name);
    }

    protected JmsConnectionFactory createConnectionFactory(Map<String, String> properties) {
        JmsConnectionFactory factory = new JmsConnectionFactory();
        Map<String, String> unused = factory.setProperties(properties);
        if (!unused.isEmpty()) {
            String msg = " Not all properties could be set on the ConnectionFactory. Check the properties are spelled correctly. Unused properties=[" + unused + "].";
            throw new IllegalArgumentException(msg);
        }
        return factory;
    }

    protected static String expand(String input, Map<Object, Object> environment2) {
        return VariableExpansion.expand(input, (String variable) -> {
            Object o;
            String resolve = VariableExpansion.SYS_PROP_RESOLVER.resolve(variable);
            if (resolve == null && (resolve = VariableExpansion.ENV_VAR_RESOLVER.resolve(variable)) == null && (o = environment2.get(variable)) != null) {
                resolve = String.valueOf(o);
            }
            return resolve;
        });
    }
}

