/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.qpid.jms.JmsAcknowledgeCallback;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsMessagePropertyIntercepter;
import org.apache.qpid.jms.message.JmsMessagePropertySupport;
import org.apache.qpid.jms.message.JmsMessageTransformation;
import org.apache.qpid.jms.message.facade.JmsMessageFacade;

public class JmsMessage
implements Message {
    private static final String ID_PREFIX = "ID:";
    protected transient JmsAcknowledgeCallback acknowledgeCallback;
    protected transient JmsConnection connection;
    protected final JmsMessageFacade facade;
    protected boolean readOnly;
    protected boolean readOnlyBody;
    protected boolean readOnlyProperties;
    protected boolean validatePropertyNames = true;

    public JmsMessage(JmsMessageFacade facade) {
        this.facade = facade;
    }

    public JmsMessage copy() throws JMSException {
        JmsMessage other = new JmsMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    protected void copy(JmsMessage other) {
        this.readOnlyBody = other.readOnlyBody;
        this.readOnlyProperties = other.readOnlyProperties;
        this.acknowledgeCallback = other.acknowledgeCallback;
        this.connection = other.connection;
        this.validatePropertyNames = other.validatePropertyNames;
    }

    public int hashCode() {
        String id = this.facade.getMessageId();
        if (id != null) {
            return id.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JmsMessage msg = (JmsMessage)o;
        String oMsg = msg.facade.getMessageId();
        String thisMsg = this.facade.getMessageId();
        return thisMsg != null && oMsg != null && oMsg.equals(thisMsg);
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.acknowledgeCallback != null) {
            try {
                this.acknowledgeCallback.acknowledge();
                this.acknowledgeCallback = null;
            }
            catch (Throwable e) {
                throw JmsExceptionSupport.create(e);
            }
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class target) throws JMSException {
        return true;
    }

    @Override
    public final <T> T getBody(Class<T> asType) throws JMSException {
        if (this.isBodyAssignableTo(asType)) {
            return this.doGetBody(asType);
        }
        throw new MessageFormatException("Message body cannot be read as type: " + asType);
    }

    protected <T> T doGetBody(Class<T> asType) throws JMSException {
        return null;
    }

    @Override
    public void clearBody() throws JMSException {
        this.checkReadOnly();
        this.readOnlyBody = false;
        this.facade.clearBody();
    }

    public boolean isValidatePropertyNames() {
        return this.validatePropertyNames;
    }

    public void setValidatePropertyNames(boolean validatePropertyNames) {
        this.validatePropertyNames = validatePropertyNames;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnlyBody() {
        return this.readOnlyBody;
    }

    public void setReadOnlyBody(boolean readOnlyBody) {
        this.readOnlyBody = readOnlyBody;
    }

    public boolean isReadOnlyProperties() {
        return this.readOnlyProperties;
    }

    public void setReadOnlyProperties(boolean readOnlyProperties) {
        this.readOnlyProperties = readOnlyProperties;
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        Object id = this.facade.getMessageId();
        if (id != null && !((String)id).startsWith(ID_PREFIX)) {
            id = ID_PREFIX + (String)id;
        }
        return id;
    }

    @Override
    public void setJMSMessageID(String value) throws JMSException {
        this.checkReadOnly();
        this.facade.setMessageId(value);
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.facade.getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.checkReadOnly();
        this.facade.setTimestamp(timestamp);
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this.facade.getCorrelationId();
    }

    @Override
    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.checkReadOnly();
        this.facade.setCorrelationId(correlationId);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.facade.getCorrelationIdBytes();
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        this.checkReadOnly();
        this.facade.setCorrelationIdBytes(correlationId);
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        return this.facade.getReplyTo();
    }

    @Override
    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.checkReadOnly();
        this.facade.setReplyTo(JmsMessageTransformation.transformDestination(this.connection, destination));
    }

    @Override
    public Destination getJMSDestination() throws JMSException {
        return this.facade.getDestination();
    }

    @Override
    public void setJMSDestination(Destination destination) throws JMSException {
        this.checkReadOnly();
        this.facade.setDestination(JmsMessageTransformation.transformDestination(this.connection, destination));
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        return this.facade.isPersistent() ? 2 : 1;
    }

    @Override
    public void setJMSDeliveryMode(int mode) throws JMSException {
        this.checkReadOnly();
        switch (mode) {
            case 2: {
                this.facade.setPersistent(true);
                break;
            }
            case 1: {
                this.facade.setPersistent(false);
                break;
            }
            default: {
                throw new JMSException(String.format("Invalid DeliveryMode specific: %d", mode));
            }
        }
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this.facade.isRedelivered();
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.checkReadOnly();
        this.facade.setRedelivered(redelivered);
    }

    @Override
    public String getJMSType() throws JMSException {
        return this.facade.getType();
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        this.checkReadOnly();
        this.facade.setType(type);
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.facade.getExpiration();
    }

    @Override
    public void setJMSExpiration(long expiration) throws JMSException {
        this.checkReadOnly();
        this.facade.setExpiration(expiration);
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.facade.getPriority();
    }

    @Override
    public void setJMSPriority(int priority) throws JMSException {
        this.checkReadOnly();
        if (priority < 0 || priority > 9) {
            throw new JMSException(String.format("Priority value given {%d} is out of range (0..9)", priority));
        }
        this.facade.setPriority(priority);
    }

    @Override
    public long getJMSDeliveryTime() throws JMSException {
        return this.facade.getDeliveryTime();
    }

    @Override
    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.checkReadOnly();
        this.facade.setDeliveryTime(deliveryTime, true);
    }

    @Override
    public void clearProperties() throws JMSException {
        this.checkReadOnly();
        JmsMessagePropertyIntercepter.clearProperties(this, true);
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        return JmsMessagePropertyIntercepter.propertyExists(this, name);
    }

    @Override
    public Enumeration<?> getPropertyNames() throws JMSException {
        return Collections.enumeration(JmsMessagePropertyIntercepter.getPropertyNames(this, true));
    }

    public Enumeration<?> getAllPropertyNames() throws JMSException {
        HashSet<String> result = new HashSet<String>();
        result.addAll(JmsMessagePropertyIntercepter.getAllPropertyNames(this));
        return Collections.enumeration(result);
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkReadOnly();
        JmsMessagePropertyIntercepter.setProperty(this, name, value);
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        return JmsMessagePropertyIntercepter.getProperty(this, name);
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Boolean.class);
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Byte.class);
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Short.class);
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Integer.class);
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Long.class);
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Float.class).floatValue();
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), Double.class);
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        return JmsMessagePropertySupport.convertPropertyTo(name, this.getObjectProperty(name), String.class);
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, Float.valueOf(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public JmsAcknowledgeCallback getAcknowledgeCallback() {
        return this.acknowledgeCallback;
    }

    public void setAcknowledgeCallback(JmsAcknowledgeCallback jmsAcknowledgeCallback) {
        this.acknowledgeCallback = jmsAcknowledgeCallback;
    }

    public void onSend(long producerTtl) throws JMSException {
        this.setReadOnly(true);
        this.facade.onSend(producerTtl);
    }

    public void onSendComplete() {
        this.setReadOnly(false);
    }

    public void onDispatch() throws JMSException {
        this.setReadOnly(false);
        this.setReadOnlyBody(true);
        this.setReadOnlyProperties(true);
        this.facade.onDispatch();
    }

    public JmsConnection getConnection() {
        return this.connection;
    }

    public void setConnection(JmsConnection connection) {
        this.connection = connection;
    }

    public JmsMessageFacade getFacade() {
        return this.facade;
    }

    public boolean isExpired() {
        long expireTime = this.facade.getExpiration();
        return expireTime > 0L && System.currentTimeMillis() > expireTime;
    }

    public String toString() {
        return "JmsMessage { " + this.facade + " }";
    }

    protected void checkReadOnly() throws MessageNotWriteableException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message is currently read-only");
        }
    }

    protected void checkReadOnlyProperties() throws MessageNotWriteableException {
        if (this.readOnly || this.readOnlyProperties) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
    }

    protected void checkReadOnlyBody() throws MessageNotWriteableException {
        if (this.readOnly || this.readOnlyBody) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
    }

    protected void checkWriteOnlyBody() throws MessageNotReadableException {
        if (!this.readOnlyBody) {
            throw new MessageNotReadableException("Message body is write-only");
        }
    }
}

