/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.Map;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpRedirect;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionRedirectedException;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionRemotelyClosedException;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionResourceAllocationException;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionResourceNotFoundException;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionSecurityException;
import org.apache.qpid.jms.provider.exceptions.ProviderInvalidClientIDException;
import org.apache.qpid.jms.provider.exceptions.ProviderInvalidDestinationException;
import org.apache.qpid.jms.provider.exceptions.ProviderResourceAllocationException;
import org.apache.qpid.jms.provider.exceptions.ProviderSecurityException;
import org.apache.qpid.jms.provider.exceptions.ProviderTransactionRolledBackException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionErrors;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Endpoint;

public class AmqpSupport {
    public static final Symbol SOLE_CONNECTION_CAPABILITY = Symbol.valueOf("sole-connection-for-container");
    public static final Symbol ANONYMOUS_RELAY = Symbol.valueOf("ANONYMOUS-RELAY");
    public static final Symbol DELAYED_DELIVERY = Symbol.valueOf("DELAYED_DELIVERY");
    public static final Symbol SHARED_SUBS = Symbol.valueOf("SHARED-SUBS");
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf("amqp:connection-establishment-failed");
    public static final Symbol INVALID_FIELD = Symbol.valueOf("invalid-field");
    public static final Symbol CONTAINER_ID = Symbol.valueOf("container-id");
    public static final Symbol FAILOVER_SERVER_LIST = Symbol.valueOf("failover-server-list");
    public static final Symbol PATH = Symbol.valueOf("path");
    public static final Symbol SCHEME = Symbol.valueOf("scheme");
    public static final Symbol PORT = Symbol.valueOf("port");
    public static final Symbol NETWORK_HOST = Symbol.valueOf("network-host");
    public static final Symbol OPEN_HOSTNAME = Symbol.valueOf("hostname");
    public static final Symbol QUEUE_PREFIX = Symbol.valueOf("queue-prefix");
    public static final Symbol TOPIC_PREFIX = Symbol.valueOf("topic-prefix");
    public static final Symbol PRODUCT = Symbol.valueOf("product");
    public static final Symbol VERSION = Symbol.valueOf("version");
    public static final Symbol PLATFORM = Symbol.valueOf("platform");
    public static final Symbol COPY = Symbol.getSymbol("copy");
    public static final Symbol JMS_NO_LOCAL_SYMBOL = Symbol.valueOf("no-local");
    public static final Symbol JMS_SELECTOR_SYMBOL = Symbol.valueOf("jms-selector");
    public static final Symbol SHARED = Symbol.valueOf("shared");
    public static final Symbol GLOBAL = Symbol.valueOf("global");
    public static final Rejected REJECTED = new Rejected();
    public static final Modified MODIFIED_FAILED = new Modified();
    public static final Modified MODIFIED_FAILED_UNDELIVERABLE = new Modified();
    public static final Symbol DYNAMIC_NODE_LIFETIME_POLICY = Symbol.valueOf("lifetime-policy");
    public static final String TEMP_QUEUE_CREATOR = "temp-queue-creator:";
    public static final String TEMP_TOPIC_CREATOR = "temp-topic-creator:";
    public static final String SUB_NAME_DELIMITER = "|";

    public static ProviderConnectionRemotelyClosedException convertToConnectionClosedException(AmqpProvider provider, Endpoint endpoint, ErrorCondition errorCondition) {
        ProviderConnectionRemotelyClosedException remoteError = null;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            Map info;
            Symbol error = errorCondition.getCondition();
            String message = AmqpSupport.extractErrorMessage(errorCondition);
            remoteError = error.equals(AmqpError.UNAUTHORIZED_ACCESS) ? new ProviderConnectionSecurityException(message) : (error.equals(AmqpError.RESOURCE_LIMIT_EXCEEDED) ? new ProviderConnectionResourceAllocationException(message) : (error.equals(ConnectionError.CONNECTION_FORCED) ? new ProviderConnectionRemotelyClosedException(message) : (error.equals(AmqpError.NOT_FOUND) ? new ProviderConnectionResourceNotFoundException(message) : (error.equals(ConnectionError.REDIRECT) ? AmqpSupport.createRedirectException(provider, error, message, errorCondition) : (error.equals(AmqpError.INVALID_FIELD) ? ((info = errorCondition.getInfo()) != null && CONTAINER_ID.equals(info.get(INVALID_FIELD)) ? new ProviderInvalidClientIDException(message) : new ProviderConnectionRemotelyClosedException(message)) : new ProviderConnectionRemotelyClosedException(message))))));
        } else if (remoteError == null) {
            remoteError = new ProviderConnectionRemotelyClosedException("Unknown error from remote peer");
        }
        return remoteError;
    }

    public static ProviderException convertToNonFatalException(AmqpProvider provider, Endpoint endpoint, ErrorCondition errorCondition) {
        ProviderException remoteError = null;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            Symbol error = errorCondition.getCondition();
            String message = AmqpSupport.extractErrorMessage(errorCondition);
            remoteError = error.equals(AmqpError.UNAUTHORIZED_ACCESS) ? new ProviderSecurityException(message) : (error.equals(AmqpError.RESOURCE_LIMIT_EXCEEDED) ? new ProviderResourceAllocationException(message) : (error.equals(AmqpError.NOT_FOUND) ? new ProviderInvalidDestinationException(message) : (error.equals(TransactionErrors.TRANSACTION_ROLLBACK) ? new ProviderTransactionRolledBackException(message) : new ProviderException(message))));
        } else if (remoteError == null) {
            remoteError = new ProviderException("Unknown error from remote peer");
        }
        return remoteError;
    }

    public static String extractErrorMessage(ErrorCondition errorCondition) {
        Object message = "Received error from remote peer without description";
        if (errorCondition != null) {
            Symbol condition;
            if (errorCondition.getDescription() != null && !errorCondition.getDescription().isEmpty()) {
                message = errorCondition.getDescription();
            }
            if ((condition = errorCondition.getCondition()) != null) {
                message = (String)message + " [condition = " + condition + "]";
            }
        }
        return message;
    }

    public static ProviderConnectionRemotelyClosedException createRedirectException(AmqpProvider provider, Symbol error, String message, ErrorCondition condition) {
        ProviderConnectionRemotelyClosedException result = null;
        Map info = condition.getInfo();
        if (info == null) {
            result = new ProviderConnectionRemotelyClosedException(message + " : Redirection information not set.");
        } else {
            AmqpRedirect redirect = new AmqpRedirect(info, provider);
            try {
                result = new ProviderConnectionRedirectedException(message, redirect.validate().toURI());
            }
            catch (Exception ex) {
                result = new ProviderConnectionRemotelyClosedException(message + " : " + ex.getMessage());
            }
        }
        return result;
    }

    static {
        MODIFIED_FAILED.setDeliveryFailed(true);
        MODIFIED_FAILED_UNDELIVERABLE.setDeliveryFailed(true);
        MODIFIED_FAILED_UNDELIVERABLE.setUndeliverableHere(true);
    }
}

