/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.jms.message.JmsMapMessage;
import org.apache.qpid.jms.message.facade.JmsMapMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpJmsMapMessageFacade
extends AmqpJmsMessageFacade
implements JmsMapMessageFacade {
    private Map<String, Object> messageBodyMap;

    @Override
    public byte getJmsMsgType() {
        return 2;
    }

    @Override
    public AmqpJmsMapMessageFacade copy() {
        AmqpJmsMapMessageFacade copy = new AmqpJmsMapMessageFacade();
        this.copyInto(copy);
        copy.initializeEmptyBody();
        copy.messageBodyMap.putAll(this.messageBodyMap);
        return copy;
    }

    @Override
    public Enumeration<String> getMapNames() {
        return Collections.enumeration(this.messageBodyMap.keySet());
    }

    @Override
    public boolean itemExists(String key) {
        return this.messageBodyMap.containsKey(key);
    }

    @Override
    public Object get(String key) {
        Object value = this.messageBodyMap.get(key);
        if (value instanceof Binary) {
            Binary bin = (Binary)value;
            value = Arrays.copyOfRange(bin.getArray(), bin.getArrayOffset(), bin.getLength());
        }
        return value;
    }

    @Override
    public void put(String key, Object value) {
        Object entry = value;
        if (value instanceof byte[]) {
            entry = new Binary((byte[])value);
        }
        this.messageBodyMap.put(key, entry);
    }

    @Override
    public Object remove(String key) {
        return this.messageBodyMap.remove(key);
    }

    @Override
    public void clearBody() {
        this.messageBodyMap.clear();
    }

    @Override
    public boolean hasBody() {
        return !this.messageBodyMap.isEmpty();
    }

    @Override
    public JmsMapMessage asJmsMessage() {
        return new JmsMapMessage(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void setBody(Section body) {
        if (body == null) {
            this.initializeEmptyBody();
            return;
        } else {
            if (!(body instanceof AmqpValue)) throw new IllegalStateException("Unexpected message body type: " + body.getClass().getSimpleName());
            Object o = ((AmqpValue)body).getValue();
            if (o == null) {
                this.initializeEmptyBody();
                return;
            } else {
                if (!(o instanceof Map)) throw new IllegalStateException("Unexpected message body type: " + body.getClass().getSimpleName());
                this.messageBodyMap = (Map)o;
                super.setBody(body);
            }
        }
    }

    @Override
    protected void initializeEmptyBody() {
        this.messageBodyMap = new LinkedHashMap<String, Object>();
        super.setBody(new AmqpValue(this.messageBodyMap));
    }
}

