/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.message.Message;

public final class AmqpMessageSupport {
    public static final Symbol JMS_MSG_TYPE = Symbol.valueOf("x-opt-jms-msg-type");
    public static final Symbol JMS_DELIVERY_TIME = Symbol.valueOf("x-opt-delivery-time");
    public static final byte JMS_MESSAGE = 0;
    public static final byte JMS_OBJECT_MESSAGE = 1;
    public static final byte JMS_MAP_MESSAGE = 2;
    public static final byte JMS_BYTES_MESSAGE = 3;
    public static final byte JMS_STREAM_MESSAGE = 4;
    public static final byte JMS_TEXT_MESSAGE = 5;
    public static final String JMS_AMQP_TTL = "JMS_AMQP_TTL";
    public static final String JMS_AMQP_REPLY_TO_GROUP_ID = "JMS_AMQP_REPLY_TO_GROUP_ID";
    public static final String JMS_AMQP_TYPED_ENCODING = "JMS_AMQP_TYPED_ENCODING";
    public static final Symbol SERIALIZED_JAVA_OBJECT_CONTENT_TYPE = Symbol.valueOf("application/x-java-serialized-object");
    public static final Symbol OCTET_STREAM_CONTENT_TYPE = Symbol.valueOf("application/octet-stream");
    public static final Symbol LEGACY_TO_TYPE_MSG_ANNOTATION_SYMBOL = Symbol.valueOf("x-opt-to-type");
    public static final Symbol LEGACY_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL = Symbol.valueOf("x-opt-reply-type");
    public static final String LEGACY_QUEUE_ATTRIBUTE = "queue";
    public static final String LEGACY_TOPIC_ATTRIBUTE = "topic";
    public static final String LEGACY_TEMPORARY_ATTRIBUTE = "temporary";

    public static Object getMessageAnnotation(Symbol key, MessageAnnotations messageAnnotations) {
        if (messageAnnotations != null && messageAnnotations.getValue() != null) {
            Map<Symbol, Object> annotations = messageAnnotations.getValue();
            return annotations.get(key);
        }
        return null;
    }

    public static boolean isContentType(Symbol contentType, Symbol messageContentType) {
        if (contentType == null) {
            return messageContentType == null;
        }
        if (messageContentType == null) {
            return false;
        }
        return contentType.equals(messageContentType);
    }

    public static Message decodeMessage(ByteBuf encodedBytes) {
        Message protonMessage = Message.Factory.create();
        protonMessage.decode(encodedBytes.array(), 0, encodedBytes.readableBytes());
        return protonMessage;
    }

    public static ReadableBuffer encodeMessage(Message message) {
        int BUFFER_SIZE = 4096;
        byte[] encodedMessage = new byte[4096];
        int encodedSize = 0;
        while (true) {
            try {
                encodedSize = message.encode(encodedMessage, 0, encodedMessage.length);
            }
            catch (BufferOverflowException e) {
                encodedMessage = new byte[encodedMessage.length * 2];
                continue;
            }
            break;
        }
        return ReadableBuffer.ByteBufferReader.wrap(ByteBuffer.wrap(encodedMessage, 0, encodedSize));
    }
}

