/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.jms.provider.amqp.message.AmqpObjectTypeDelegate;
import org.apache.qpid.jms.util.ClassLoadingAwareObjectInputStream;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpSerializedObjectDelegate
implements AmqpObjectTypeDelegate,
ClassLoadingAwareObjectInputStream.TrustedClassFilter {
    static final Data NULL_OBJECT_BODY;
    private final AmqpJmsMessageFacade parent;
    private final JmsDeserializationPolicy deserializationPolicy;
    private boolean localContent;

    public AmqpSerializedObjectDelegate(AmqpJmsMessageFacade parent, JmsDeserializationPolicy deserializationPolicy) {
        this.parent = parent;
        this.parent.setContentType(AmqpMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE);
        this.deserializationPolicy = deserializationPolicy;
    }

    private static byte[] getSerializedBytes(Serializable value) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(value);
                oos.flush();
                oos.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public Serializable getObject() throws IOException, ClassNotFoundException {
        Binary binary = null;
        Section body = this.parent.getBody();
        if (body == null || body == NULL_OBJECT_BODY) {
            return null;
        }
        if (!(body instanceof Data)) {
            throw new IllegalStateException("Unexpected body type: " + body.getClass().getSimpleName());
        }
        binary = ((Data)body).getValue();
        if (binary == null) {
            return null;
        }
        Serializable serialized = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(binary.getArray(), binary.getArrayOffset(), binary.getLength());
             ClassLoadingAwareObjectInputStream objIn = new ClassLoadingAwareObjectInputStream(bais, this);){
            serialized = (Serializable)objIn.readObject();
        }
        return serialized;
    }

    @Override
    public void setObject(Serializable value) throws IOException {
        if (value == null) {
            this.parent.setBody(NULL_OBJECT_BODY);
        } else {
            byte[] bytes = AmqpSerializedObjectDelegate.getSerializedBytes(value);
            this.parent.setBody(new Data(new Binary(bytes)));
        }
        this.localContent = true;
    }

    @Override
    public void onSend() {
        this.parent.setContentType(AmqpMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE);
        if (this.parent.getBody() == null) {
            this.parent.setBody(NULL_OBJECT_BODY);
        }
    }

    @Override
    public void copyInto(AmqpObjectTypeDelegate copy) throws Exception {
        if (!(copy instanceof AmqpSerializedObjectDelegate)) {
            copy.setObject(this.getObject());
        } else {
            AmqpSerializedObjectDelegate target = (AmqpSerializedObjectDelegate)copy;
            target.localContent = this.localContent;
            target.parent.setBody(this.parent.getBody());
        }
    }

    @Override
    public boolean isAmqpTypeEncoded() {
        return false;
    }

    @Override
    public boolean isTrusted(Class<?> clazz) {
        if (!this.localContent && this.deserializationPolicy != null) {
            return this.deserializationPolicy.isTrustedType(this.parent.getConsumerDestination(), clazz);
        }
        return true;
    }

    @Override
    public boolean hasBody() {
        try {
            return this.getObject() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        byte[] bytes;
        try {
            bytes = AmqpSerializedObjectDelegate.getSerializedBytes(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialise null object body", e);
        }
        NULL_OBJECT_BODY = new Data(new Binary(bytes));
    }
}

