/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.impl.engine.DefaultCamelBeanPostProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class CamelBeanPostProcessor
implements org.apache.camel.spi.CamelBeanPostProcessor,
CamelContextAware,
BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamelBeanPostProcessor.class);
    private final Set<String> prototypeBeans = new LinkedHashSet<String>();
    private CamelContext camelContext;
    private ApplicationContext applicationContext;
    private String camelId;
    private boolean bindToRegistrySupported;
    private final DefaultCamelBeanPostProcessor delegate = new DefaultCamelBeanPostProcessor(){

        @Override
        public CamelContext getOrLookupCamelContext() {
            CamelContext answer = CamelBeanPostProcessor.this.camelContext;
            if (answer == null) {
                if (CamelBeanPostProcessor.this.camelId != null) {
                    LOG.trace("Looking up CamelContext by id: {} from Spring ApplicationContext: {}", (Object)CamelBeanPostProcessor.this.camelId, (Object)CamelBeanPostProcessor.this.applicationContext);
                    answer = CamelBeanPostProcessor.this.applicationContext.getBean(CamelBeanPostProcessor.this.camelId, CamelContext.class);
                } else {
                    LOG.trace("Looking up CamelContext by type from Spring ApplicationContext: {}", (Object)CamelBeanPostProcessor.this.applicationContext);
                    Map<String, CamelContext> contexts = CamelBeanPostProcessor.this.applicationContext.getBeansOfType(CamelContext.class);
                    if (contexts.size() == 1) {
                        answer = contexts.values().iterator().next();
                    }
                }
                if (answer != null) {
                    CamelBeanPostProcessor.this.camelContext = answer;
                }
            }
            return answer;
        }

        @Override
        public void setCamelContext(CamelContext camelContext) {
            super.setCamelContext(camelContext);
            if (this.camelPostProcessorHelper != null) {
                this.camelPostProcessorHelper.setCamelContext(camelContext);
            }
        }

        @Override
        public boolean canPostProcessBean(Object bean2, String beanName) {
            if (bean2 == null) {
                return false;
            }
            return super.canPostProcessBean(bean2, beanName);
        }

        @Override
        protected boolean bindToRegistrySupported() {
            return false;
        }

        @Override
        public CamelPostProcessorHelper getPostProcessorHelper() {
            if (this.camelPostProcessorHelper == null) {
                this.camelPostProcessorHelper = new CamelPostProcessorHelper(this.camelContext){

                    @Override
                    public CamelContext getCamelContext() {
                        CamelContext answer = CamelBeanPostProcessor.this.camelContext;
                        if (answer == null) {
                            answer = CamelBeanPostProcessor.this.delegate.getOrLookupCamelContext();
                        }
                        return answer;
                    }

                    @Override
                    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
                        return new BeanInstantiationException(type, "Could not instantiate proxy of type " + type.getName() + " on endpoint " + String.valueOf(endpoint), (Throwable)e);
                    }

                    @Override
                    protected boolean isSingleton(Object bean2, String beanName) {
                        if (CamelBeanPostProcessor.this.applicationContext == null || beanName == null) {
                            return super.isSingleton(bean2, beanName);
                        }
                        return CamelBeanPostProcessor.this.applicationContext.isSingleton(beanName);
                    }

                    @Override
                    protected void startService(Service service, CamelContext context, Object bean2, String beanName) throws Exception {
                        if (this.isSingleton(bean2, beanName)) {
                            this.getCamelContext().addService(service);
                        } else {
                            ServiceHelper.startService(service);
                            if (CamelBeanPostProcessor.this.prototypeBeans.add(beanName)) {
                                LOG.warn("The bean with id [{}] is prototype scoped and cannot stop the injected  service when bean is destroyed: {}. You may want to stop the service manually from the bean.", (Object)beanName, (Object)service);
                            }
                        }
                    }
                };
            }
            return this.camelPostProcessorHelper;
        }
    };

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        try {
            return this.delegate.postProcessBeforeInitialization(bean2, beanName);
        }
        catch (BeansException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException("Error post processing bean: " + beanName, e);
        }
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        try {
            return this.delegate.postProcessAfterInitialization(bean2, beanName);
        }
        catch (Exception e) {
            if (e instanceof BeansException) {
                throw (BeansException)e;
            }
            throw new BeanCreationException("Error post processing bean: " + beanName, e);
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.delegate.setCamelContext(camelContext);
    }

    public String getCamelId() {
        return this.camelId;
    }

    public void setCamelId(String camelId) {
        this.camelId = camelId;
    }

    public boolean isBindToRegistrySupported() {
        return this.bindToRegistrySupported;
    }

    public void setBindToRegistrySupported(boolean bindToRegistrySupported) {
        this.bindToRegistrySupported = bindToRegistrySupported;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.delegate.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }
}

