/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.camel.util.ObjectHelper;

public final class PropertiesHelper {
    private PropertiesHelper() {
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        return PropertiesHelper.extractProperties(properties, optionPrefix, true);
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix, boolean remove) {
        if (properties == null) {
            return new LinkedHashMap<String, Object>(0);
        }
        return PropertiesHelper.doExtractProperties(properties, optionPrefix, remove);
    }

    static Map<String, Object> doExtractProperties(Map<String, Object> properties, String optionPrefix, boolean remove) {
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            if (!remove) continue;
            it.remove();
        }
        return rc;
    }

    public static boolean hasProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, "properties");
        if (ObjectHelper.isNotEmpty(optionPrefix)) {
            for (String o : properties.keySet()) {
                String name = o;
                if (!name.startsWith(optionPrefix)) continue;
                return true;
            }
            return false;
        }
        return !properties.isEmpty();
    }

    public static Properties asProperties(String ... properties) {
        if ((properties.length & 1) != 0) {
            throw new InternalError("length is odd");
        }
        Properties answer = new Properties();
        for (int i2 = 0; i2 < properties.length; i2 += 2) {
            answer.setProperty(Objects.requireNonNull(properties[i2]), Objects.requireNonNull(properties[i2 + 1]));
        }
        return answer;
    }

    public static Properties asProperties(Map<String, Object> properties) {
        Properties answer = new Properties();
        answer.putAll(properties);
        return answer;
    }
}

