/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import org.apache.qpid.jms.JmsMessageConsumer;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;

public class JmsConsumer
implements JMSConsumer,
AutoCloseable {
    private final JmsSession session;
    private final JmsMessageConsumer consumer;

    public JmsConsumer(JmsSession session, JmsMessageConsumer consumer) {
        this.session = session;
        this.consumer = consumer;
    }

    @Override
    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public MessageListener getMessageListener() {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        try {
            this.consumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public Message receive() {
        try {
            return this.consumer.receive();
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public Message receive(long timeout) {
        try {
            return this.consumer.receive(timeout);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public Message receiveNoWait() {
        try {
            return this.consumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> desired) {
        try {
            return this.consumer.receiveBody(desired, -1L);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> desired, long timeout) {
        try {
            if (timeout == 0L) {
                timeout = -1L;
            }
            return this.consumer.receiveBody(desired, timeout);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> desired) {
        try {
            return this.consumer.receiveBody(desired, 0L);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }
}

