/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.jms.JmsMessageProducer;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsMessagePropertySupport;
import org.apache.qpid.jms.message.JmsMessageTransformation;

public class JmsProducer
implements JMSProducer {
    private final JmsSession session;
    private final JmsMessageProducer producer;
    private CompletionListener completionListener;
    private String correlationId;
    private String type;
    private Destination replyTo;
    private byte[] correlationIdBytes;
    private long deliveryDelay = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    private final Map<String, Object> messageProperties = new HashMap<String, Object>();

    public JmsProducer(JmsSession session, JmsMessageProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    @Override
    public JMSProducer send(Destination destination, Message message) {
        try {
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, byte[] body) {
        try {
            BytesMessage message = this.session.createBytesMessage();
            if (body != null) {
                message.writeBytes(body);
            }
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, Map<String, Object> body) {
        try {
            MapMessage message = this.session.createMapMessage();
            if (body != null) {
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    message.setObject(entry.getKey(), entry.getValue());
                }
            }
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, Serializable body) {
        try {
            ObjectMessage message = this.session.createObjectMessage();
            message.setObject(body);
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
        return this;
    }

    @Override
    public JMSProducer send(Destination destination, String body) {
        try {
            TextMessage message = this.session.createTextMessage(body);
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
        return this;
    }

    private void doSend(Destination destination, Message message) throws JMSException {
        if (message == null) {
            throw new MessageFormatException("Message must not be null");
        }
        for (Map.Entry<String, Object> entry : this.messageProperties.entrySet()) {
            message.setObjectProperty(entry.getKey(), entry.getValue());
        }
        if (this.correlationId != null) {
            message.setJMSCorrelationID(this.correlationId);
        }
        if (this.correlationIdBytes != null) {
            message.setJMSCorrelationIDAsBytes(this.correlationIdBytes);
        }
        if (this.type != null) {
            message.setJMSType(this.type);
        }
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo);
        }
        this.session.send(this.producer, destination, message, this.deliveryMode, this.priority, this.timeToLive, this.disableMessageId, this.disableTimestamp, this.deliveryDelay, this.completionListener);
    }

    @Override
    public JMSProducer clearProperties() {
        this.messageProperties.clear();
        return this;
    }

    @Override
    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.messageProperties.keySet());
    }

    @Override
    public boolean propertyExists(String name) {
        return this.messageProperties.containsKey(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Boolean.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public byte getByteProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Byte.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public double getDoubleProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Double.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public float getFloatProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Float.class).floatValue();
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public int getIntProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Integer.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public long getLongProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Long.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public Object getObjectProperty(String name) {
        return this.messageProperties.get(name);
    }

    @Override
    public short getShortProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), Short.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public String getStringProperty(String name) {
        try {
            return JmsMessagePropertySupport.convertPropertyTo(name, this.messageProperties.get(name), String.class);
        }
        catch (JMSException jmse) {
            throw JmsExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSProducer setProperty(String name, boolean value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, byte value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, double value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, float value) {
        return this.setObjectProperty(name, Float.valueOf(value));
    }

    @Override
    public JMSProducer setProperty(String name, int value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, long value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, Object value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, short value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public JMSProducer setProperty(String name, String value) {
        return this.setObjectProperty(name, value);
    }

    @Override
    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    @Override
    public JMSProducer setJMSCorrelationID(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationIdBytes;
    }

    @Override
    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationIdBytes) {
        this.correlationIdBytes = correlationIdBytes;
        return this;
    }

    @Override
    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    @Override
    public JMSProducer setJMSReplyTo(Destination replyTo) {
        try {
            this.replyTo = JmsMessageTransformation.transformDestination(this.session.getConnection(), replyTo);
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
        return this;
    }

    @Override
    public String getJMSType() {
        return this.type;
    }

    @Override
    public JMSProducer setJMSType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public CompletionListener getAsync() {
        return this.completionListener;
    }

    @Override
    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    @Override
    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    @Override
    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    @Override
    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public JMSProducer setDeliveryMode(int deliveryMode) {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                this.deliveryMode = deliveryMode;
                return this;
            }
        }
        throw new JMSRuntimeException(String.format("Invalid DeliveryMode specified: %d", deliveryMode));
    }

    @Override
    public boolean getDisableMessageID() {
        return this.disableMessageId;
    }

    @Override
    public JMSProducer setDisableMessageID(boolean disableMessageId) {
        this.disableMessageId = disableMessageId;
        return this;
    }

    @Override
    public boolean getDisableMessageTimestamp() {
        return this.disableTimestamp;
    }

    @Override
    public JMSProducer setDisableMessageTimestamp(boolean disableTimestamp) {
        this.disableTimestamp = disableTimestamp;
        return this;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public JMSProducer setPriority(int priority) {
        if (priority < 0 || priority > 9) {
            throw new JMSRuntimeException(String.format("Priority value given {%d} is out of range (0..9)", priority));
        }
        this.priority = priority;
        return this;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    private JMSProducer setObjectProperty(String name, Object value) {
        try {
            JmsMessagePropertySupport.checkPropertyNameIsValid(name, this.session.getConnection().isValidatePropertyNames());
            JmsMessagePropertySupport.checkValidObject(value);
            this.messageProperties.put(name, value);
            return this;
        }
        catch (JMSException e) {
            throw JmsExceptionSupport.createRuntimeException(e);
        }
    }
}

