/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import jakarta.jms.JMSException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.message.facade.JmsTextMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpJmsTextMessageFacade
extends AmqpJmsMessageFacade
implements JmsTextMessageFacade {
    private final Charset charset;

    public AmqpJmsTextMessageFacade() {
        this(StandardCharsets.UTF_8);
    }

    AmqpJmsTextMessageFacade(Charset charset) {
        this.charset = charset;
    }

    @Override
    public byte getJmsMsgType() {
        return 5;
    }

    @Override
    public AmqpJmsTextMessageFacade copy() throws JMSException {
        AmqpJmsTextMessageFacade copy = new AmqpJmsTextMessageFacade();
        this.copyInto(copy);
        copy.setText(this.getText());
        return copy;
    }

    @Override
    public String getText() throws JMSException {
        Section body = this.getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof Data) {
            Data data = (Data)body;
            if (data.getValue() == null || data.getValue().getLength() == 0) {
                return "";
            }
            Binary b = data.getValue();
            ByteBuffer buf = ByteBuffer.wrap(b.getArray(), b.getArrayOffset(), b.getLength());
            try {
                CharBuffer chars = this.charset.newDecoder().decode(buf);
                return String.valueOf(chars);
            }
            catch (CharacterCodingException e) {
                throw JmsExceptionSupport.create("Cannot decode String in " + this.charset.displayName(), e);
            }
        }
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                return (String)value;
            }
            throw new IllegalStateException("Unexpected amqp-value body content type: " + value.getClass().getSimpleName());
        }
        throw new IllegalStateException("Unexpected message body type: " + body.getClass().getSimpleName());
    }

    @Override
    public void setText(String value) {
        this.setBody(new AmqpValue(value));
    }

    @Override
    public void clearBody() {
        this.setBody(new AmqpValue(null));
    }

    @Override
    public boolean hasBody() {
        try {
            return this.getText() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public JmsTextMessage asJmsMessage() {
        return new JmsTextMessage(this);
    }

    Charset getCharset() {
        return this.charset;
    }

    @Override
    protected void initializeEmptyBody() {
        this.setBody(new AmqpValue(null));
    }
}

