/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;

public class MapType
extends AbstractPrimitiveType<Map> {
    private final MapEncoding _mapEncoding;
    private final MapEncoding _shortMapEncoding;
    private EncoderImpl _encoder;
    private AMQPType<?> fixedKeyType;

    MapType(EncoderImpl encoder, DecoderImpl decoder) {
        this._encoder = encoder;
        this._mapEncoding = new AllMapEncoding(encoder, decoder);
        this._shortMapEncoding = new ShortMapEncoding(encoder, decoder);
        encoder.register(Map.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Map> getTypeClass() {
        return Map.class;
    }

    public void setKeyEncoding(AMQPType<?> keyType) {
        this.fixedKeyType = keyType;
    }

    public MapEncoding getEncoding(Map val) {
        int calculatedSize = this.calculateSize(val);
        MapEncoding encoding = val.size() > 127 || calculatedSize >= 254 ? this._mapEncoding : this._shortMapEncoding;
        encoding.setValue(val, calculatedSize);
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateSize(Map map) {
        int len = 0;
        Iterator iter = map.entrySet().iterator();
        AMQPType<?> fixedKeyType = this.fixedKeyType;
        this.setKeyEncoding(null);
        try {
            while (iter.hasNext()) {
                TypeEncoding<Object> elementEncoding;
                Map.Entry element = iter.next();
                if (fixedKeyType == null) {
                    AMQPType keyType = this._encoder.getType(element.getKey());
                    if (keyType == null) {
                        throw new IllegalArgumentException("No encoding is known for map entry key of type: " + element.getKey().getClass().getName());
                    }
                    elementEncoding = keyType.getEncoding(element.getKey());
                } else {
                    elementEncoding = fixedKeyType.getEncoding(element.getKey());
                }
                len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element.getKey());
                AMQPType valueType = this._encoder.getType(element.getValue());
                if (valueType == null) {
                    throw new IllegalArgumentException("No encoding is known for map entry value of type: " + element.getValue().getClass().getName());
                }
                elementEncoding = valueType.getEncoding(element.getValue());
                len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element.getValue());
            }
        }
        finally {
            this.setKeyEncoding(fixedKeyType);
        }
        return len;
    }

    private static TypeConstructor<?> findNextDecoder(DecoderImpl decoder, ReadableBuffer buffer, TypeConstructor<?> previousConstructor) {
        if (previousConstructor == null) {
            return decoder.readConstructor();
        }
        byte encodingCode = buffer.get(buffer.position());
        if (encodingCode == 0 || !(previousConstructor instanceof PrimitiveTypeEncoding)) {
            return decoder.readConstructor();
        }
        PrimitiveTypeEncoding primitiveConstructor = (PrimitiveTypeEncoding)previousConstructor;
        if (encodingCode != primitiveConstructor.getEncodingCode()) {
            return decoder.readConstructor();
        }
        byte by = buffer.get();
        return previousConstructor;
    }

    @Override
    public MapEncoding getCanonicalEncoding() {
        return this._mapEncoding;
    }

    @Override
    public Collection<MapEncoding> getAllEncodings() {
        return Arrays.asList(this._shortMapEncoding, this._mapEncoding);
    }

    private class ShortMapEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Map>
    implements MapEncoding {
        private Map _value;
        private int _length;

        public ShortMapEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeEncodedValue(Map map) {
            this.getEncoder().getBuffer().ensureRemaining(this.getSizeBytes() + this.getEncodedValueSize(map));
            this.getEncoder().writeRaw((byte)(2 * map.size()));
            Iterator iter = map.entrySet().iterator();
            AMQPType fixedKeyType = MapType.this.fixedKeyType;
            MapType.this.setKeyEncoding(null);
            try {
                while (iter.hasNext()) {
                    Map.Entry element = iter.next();
                    TypeEncoding<Object> elementEncoding = fixedKeyType == null ? MapType.this._encoder.getType(element.getKey()).getEncoding(element.getKey()) : fixedKeyType.getEncoding(element.getKey());
                    elementEncoding.writeConstructor();
                    elementEncoding.writeValue(element.getKey());
                    elementEncoding = this.getEncoder().getType(element.getValue()).getEncoding(element.getValue());
                    elementEncoding.writeConstructor();
                    elementEncoding.writeValue(element.getValue());
                }
            }
            finally {
                MapType.this.setKeyEncoding(fixedKeyType);
            }
        }

        @Override
        protected int getEncodedValueSize(Map val) {
            return 1 + (val == this._value ? this._length : MapType.this.calculateSize(val));
        }

        @Override
        public byte getEncodingCode() {
            return -63;
        }

        @Override
        public MapType getType() {
            return MapType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Map> encoder) {
            return encoder == this;
        }

        @Override
        public Map readValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawByte() & 0xFF;
            int count = decoder.readRawByte() & 0xFF;
            TypeConstructor keyConstructor = null;
            TypeConstructor valueConstructor = null;
            LinkedHashMap map = new LinkedHashMap(count);
            for (int i2 = 0; i2 < count / 2; ++i2) {
                if ((keyConstructor = MapType.findNextDecoder(decoder, buffer, keyConstructor)) == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object key = keyConstructor.readValue();
                boolean arrayType = false;
                byte code = buffer.get(buffer.position());
                switch (code) {
                    case -32: 
                    case -16: {
                        arrayType = true;
                    }
                }
                valueConstructor = MapType.findNextDecoder(decoder, buffer, valueConstructor);
                if (valueConstructor == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object value = arrayType ? ((ArrayType.ArrayEncoding)valueConstructor).readValueArray() : valueConstructor.readValue();
                map.put(key, value);
            }
            return map;
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawByte() & 0xFF;
            buffer.position(buffer.position() + size);
        }

        @Override
        public void setValue(Map value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private class AllMapEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Map>
    implements MapEncoding {
        private Map _value;
        private int _length;

        public AllMapEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeEncodedValue(Map map) {
            this.getEncoder().getBuffer().ensureRemaining(this.getSizeBytes() + this.getEncodedValueSize(map));
            this.getEncoder().writeRaw(2 * map.size());
            Iterator iter = map.entrySet().iterator();
            AMQPType fixedKeyType = MapType.this.fixedKeyType;
            MapType.this.setKeyEncoding(null);
            try {
                while (iter.hasNext()) {
                    Map.Entry element = iter.next();
                    TypeEncoding<Object> elementEncoding = fixedKeyType == null ? MapType.this._encoder.getType(element.getKey()).getEncoding(element.getKey()) : fixedKeyType.getEncoding(element.getKey());
                    elementEncoding.writeConstructor();
                    elementEncoding.writeValue(element.getKey());
                    elementEncoding = this.getEncoder().getType(element.getValue()).getEncoding(element.getValue());
                    elementEncoding.writeConstructor();
                    elementEncoding.writeValue(element.getValue());
                }
            }
            finally {
                MapType.this.setKeyEncoding(fixedKeyType);
            }
        }

        @Override
        protected int getEncodedValueSize(Map val) {
            return 4 + (val == this._value ? this._length : MapType.this.calculateSize(val));
        }

        @Override
        public byte getEncodingCode() {
            return -47;
        }

        @Override
        public MapType getType() {
            return MapType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Map> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Map readValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawInt();
            int count = decoder.readRawInt();
            if (count > decoder.getByteBufferRemaining()) {
                throw new IllegalArgumentException("Map element count " + count + " is specified to be greater than the amount of data available (" + decoder.getByteBufferRemaining() + ")");
            }
            TypeConstructor keyConstructor = null;
            TypeConstructor valueConstructor = null;
            LinkedHashMap map = new LinkedHashMap(count);
            for (int i2 = 0; i2 < count / 2; ++i2) {
                if ((keyConstructor = MapType.findNextDecoder(decoder, buffer, keyConstructor)) == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object key = keyConstructor.readValue();
                boolean arrayType = false;
                byte code = buffer.get(buffer.position());
                switch (code) {
                    case -32: 
                    case -16: {
                        arrayType = true;
                    }
                }
                valueConstructor = MapType.findNextDecoder(decoder, buffer, valueConstructor);
                if (valueConstructor == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object value = arrayType ? ((ArrayType.ArrayEncoding)valueConstructor).readValueArray() : valueConstructor.readValue();
                map.put(key, value);
            }
            return map;
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawInt();
            buffer.position(buffer.position() + size);
        }

        @Override
        public void setValue(Map value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private static interface MapEncoding
    extends PrimitiveTypeEncoding<Map> {
        public void setValue(Map var1, int var2);
    }
}

