/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class CharElement
extends AtomicElement<Integer> {
    private final int _value;

    CharElement(Element parent, Element prev, int i2) {
        super(parent, prev);
        this._value = i2;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 4 : 5;
    }

    @Override
    public Integer getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.CHAR;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size = this.size();
        if (size <= b.remaining()) {
            if (size == 5) {
                b.put((byte)115);
            }
            b.putInt(this._value);
        }
        return 0;
    }
}

