/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class IntegerElement
extends AtomicElement<Integer> {
    private final int _value;

    IntegerElement(Element parent, Element prev, int i2) {
        super(parent, prev);
        this._value = i2;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (-128 <= this._value && this._value <= 127) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
                return 4;
            }
            return 4;
        }
        return -128 <= this._value && this._value <= 127 ? 2 : 5;
    }

    @Override
    public Integer getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.INT;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size = this.size();
        if (size <= b.remaining()) {
            switch (size) {
                case 2: {
                    b.put((byte)84);
                }
                case 1: {
                    b.put((byte)this._value);
                    break;
                }
                case 5: {
                    b.put((byte)113);
                }
                case 4: {
                    b.putInt(this._value);
                }
            }
            return size;
        }
        return 0;
    }
}

