/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.springframework.jms.support.destination.CachingDestinationResolver;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JndiDestinationResolver
extends JndiLocatorSupport
implements CachingDestinationResolver {
    private boolean cache = true;
    private boolean fallbackToDynamicDestination = false;
    private DestinationResolver dynamicDestinationResolver = new DynamicDestinationResolver();
    private final Map<String, Destination> destinationCache = new ConcurrentHashMap<String, Destination>(16);

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setFallbackToDynamicDestination(boolean fallbackToDynamicDestination) {
        this.fallbackToDynamicDestination = fallbackToDynamicDestination;
    }

    public void setDynamicDestinationResolver(DestinationResolver dynamicDestinationResolver) {
        this.dynamicDestinationResolver = dynamicDestinationResolver;
    }

    @Override
    public Destination resolveDestinationName(@Nullable Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        Assert.notNull((Object)destinationName, "Destination name must not be null");
        Destination dest = this.destinationCache.get(destinationName);
        if (dest != null) {
            this.validateDestination(dest, destinationName, pubSubDomain);
        } else {
            try {
                dest = this.lookup(destinationName, Destination.class);
                this.validateDestination(dest, destinationName, pubSubDomain);
            }
            catch (NamingException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Destination [" + destinationName + "] not found in JNDI", ex);
                }
                if (this.fallbackToDynamicDestination) {
                    dest = this.dynamicDestinationResolver.resolveDestinationName(session, destinationName, pubSubDomain);
                }
                throw new DestinationResolutionException("Destination [" + destinationName + "] not found in JNDI", ex);
            }
            if (this.cache) {
                this.destinationCache.put(destinationName, dest);
            }
        }
        return dest;
    }

    protected void validateDestination(Destination destination, String destinationName, boolean pubSubDomain) {
        Class targetClass = Queue.class;
        if (pubSubDomain) {
            targetClass = Topic.class;
        }
        if (!targetClass.isInstance(destination)) {
            throw new DestinationResolutionException("Destination [" + destinationName + "] is not of expected type [" + targetClass.getName() + "]");
        }
    }

    @Override
    public void removeFromCache(String destinationName) {
        this.destinationCache.remove(destinationName);
    }

    @Override
    public void clearCache() {
        this.destinationCache.clear();
    }
}

