/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.ConnectionPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConnectionPoolImpl
implements ConnectionPool {
    private final HostDescription host;
    private final ArangoConfig config;
    private final int maxConnections;
    private final List<Connection> connections;
    private final ConnectionFactory factory;
    private int current;
    private volatile String jwt = null;
    private boolean closed = false;

    public ConnectionPoolImpl(HostDescription host, ArangoConfig config, ConnectionFactory factory) {
        this.host = host;
        this.config = config;
        this.maxConnections = config.getMaxConnections();
        this.factory = factory;
        this.connections = new ArrayList<Connection>();
        this.current = 0;
    }

    @Override
    public Connection createConnection(HostDescription host) {
        Connection c = this.factory.create(this.config, host);
        c.setJwt(this.jwt);
        return c;
    }

    @Override
    public synchronized Connection connection() {
        Connection connection;
        if (this.closed) {
            throw new ArangoDBException("Connection pool already closed!");
        }
        if (this.connections.size() < this.maxConnections) {
            connection = this.createConnection(this.host);
            this.connections.add(connection);
            ++this.current;
        } else {
            int index = Math.floorMod(this.current++, this.connections.size());
            connection = this.connections.get(index);
        }
        return connection;
    }

    @Override
    public void setJwt(String jwt) {
        if (jwt != null) {
            this.jwt = jwt;
            for (Connection connection : this.connections) {
                connection.setJwt(jwt);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        for (Connection connection : this.connections) {
            connection.close();
        }
        this.connections.clear();
    }

    public String toString() {
        return "ConnectionPoolImpl [host=" + this.host + ", maxConnections=" + this.maxConnections + ", connections=" + this.connections.size() + ", current=" + this.current + ", factory=" + this.factory.getClass().getSimpleName() + "]";
    }
}

