/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import com.arangodb.ArangoDB;
import io.vertx.core.Vertx;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.arangodb.ArangoDbConfiguration;
import org.apache.camel.component.arangodb.ArangoDbEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="arangodb")
public class ArangoDbComponent
extends DefaultComponent {
    @Metadata(label="advanced", autowired=true)
    private ArangoDB arangoDB;
    @Metadata(label="advanced", autowired=true)
    private Vertx vertx;
    @Metadata
    private ArangoDbConfiguration configuration = new ArangoDbConfiguration();

    public ArangoDbComponent() {
        this(null);
    }

    public ArangoDbComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty(remaining)) {
            throw new IllegalArgumentException("Database name must be specified.");
        }
        ArangoDbConfiguration configurationClone = this.configuration != null ? this.configuration.copy() : new ArangoDbConfiguration();
        configurationClone.setDatabase(remaining);
        ArangoDbEndpoint endpoint = new ArangoDbEndpoint(uri, this, configurationClone);
        endpoint.setArangoDB(this.arangoDB);
        endpoint.setVertx(this.vertx);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public ArangoDB getArangoDB() {
        return this.arangoDB;
    }

    public void setArangoDB(ArangoDB arangoDB) {
        this.arangoDB = arangoDB;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public ArangoDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ArangoDbConfiguration configuration) {
        this.configuration = configuration;
    }
}

