/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import com.arangodb.ArangoDB;
import io.vertx.core.Vertx;
import org.apache.camel.CamelContext;
import org.apache.camel.component.arangodb.ArangoDbEndpoint;
import org.apache.camel.component.arangodb.ArangoDbOperation;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ArangoDbEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ArangoDbEndpoint target = (ArangoDbEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "arangodb": 
            case "arangoDB": {
                target.setArangoDB(ArangoDbEndpointConfigurer.property(camelContext, ArangoDB.class, value));
                return true;
            }
            case "documentcollection": 
            case "documentCollection": {
                target.getConfiguration().setDocumentCollection(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "edgecollection": 
            case "edgeCollection": {
                target.getConfiguration().setEdgeCollection(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "graph": {
                target.getConfiguration().setGraph(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "host": {
                target.getConfiguration().setHost(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ArangoDbEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation(ArangoDbEndpointConfigurer.property(camelContext, ArangoDbOperation.class, value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "port": {
                target.getConfiguration().setPort(ArangoDbEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "user": {
                target.getConfiguration().setUser(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "vertexcollection": 
            case "vertexCollection": {
                target.getConfiguration().setVertexCollection(ArangoDbEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "vertx": {
                target.setVertx(ArangoDbEndpointConfigurer.property(camelContext, Vertx.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "arangodb": 
            case "arangoDB": {
                return ArangoDB.class;
            }
            case "documentcollection": 
            case "documentCollection": {
                return String.class;
            }
            case "edgecollection": 
            case "edgeCollection": {
                return String.class;
            }
            case "graph": {
                return String.class;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return ArangoDbOperation.class;
            }
            case "password": {
                return String.class;
            }
            case "port": {
                return Integer.TYPE;
            }
            case "user": {
                return String.class;
            }
            case "vertexcollection": 
            case "vertexCollection": {
                return String.class;
            }
            case "vertx": {
                return Vertx.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ArangoDbEndpoint target = (ArangoDbEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "arangodb": 
            case "arangoDB": {
                return target.getArangoDB();
            }
            case "documentcollection": 
            case "documentCollection": {
                return target.getConfiguration().getDocumentCollection();
            }
            case "edgecollection": 
            case "edgeCollection": {
                return target.getConfiguration().getEdgeCollection();
            }
            case "graph": {
                return target.getConfiguration().getGraph();
            }
            case "host": {
                return target.getConfiguration().getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "port": {
                return target.getConfiguration().getPort();
            }
            case "user": {
                return target.getConfiguration().getUser();
            }
            case "vertexcollection": 
            case "vertexCollection": {
                return target.getConfiguration().getVertexCollection();
            }
            case "vertx": {
                return target.getVertx();
            }
        }
        return null;
    }
}

