/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoGraphAsync;
import com.arangodb.ArangoVertexCollectionAsync;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoGraphAsyncImpl;
import com.arangodb.internal.InternalArangoVertexCollection;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCollectionDropOptions;
import com.arangodb.model.VertexCollectionRemoveOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoVertexCollectionAsyncImpl
extends InternalArangoVertexCollection
implements ArangoVertexCollectionAsync {
    private final ArangoGraphAsync graph;

    protected ArangoVertexCollectionAsyncImpl(ArangoGraphAsyncImpl graph, String name) {
        super(graph, graph.db().name(), graph.name(), name);
        this.graph = graph;
    }

    @Override
    public ArangoGraphAsync graph() {
        return this.graph;
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> drop() {
        return this.drop(new VertexCollectionDropOptions());
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> drop(VertexCollectionDropOptions options) {
        return this.executorAsync().execute(() -> this.dropRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> remove() {
        return this.remove(new VertexCollectionRemoveOptions());
    }

    @Override
    public CompletableFuture<Void> remove(VertexCollectionRemoveOptions options) {
        return this.executorAsync().execute(() -> this.removeVertexCollectionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<VertexEntity> insertVertex(Object value) {
        return this.executorAsync().execute(() -> this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer());
    }

    @Override
    public CompletableFuture<VertexEntity> insertVertex(Object value, VertexCreateOptions options) {
        return this.executorAsync().execute(() -> this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer());
    }

    @Override
    public <T> CompletableFuture<T> getVertex(String key, Class<T> type) {
        return this.getVertex(key, type, null);
    }

    @Override
    public <T> CompletableFuture<T> getVertex(String key, Class<T> type, GraphDocumentReadOptions options) {
        return this.executorAsync().execute(() -> this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && (ArangoErrors.matches(aEx = (ArangoDBException)e, 304) || ArangoErrors.matches(aEx, 404, ArangoErrors.ERROR_ARANGO_DOCUMENT_NOT_FOUND) || ArangoErrors.matches(aEx, 412, ArangoErrors.ERROR_ARANGO_CONFLICT))) {
                return null;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<VertexUpdateEntity> replaceVertex(String key, Object value) {
        return this.executorAsync().execute(() -> this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer());
    }

    @Override
    public CompletableFuture<VertexUpdateEntity> replaceVertex(String key, Object value, VertexReplaceOptions options) {
        return this.executorAsync().execute(() -> this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer());
    }

    @Override
    public CompletableFuture<VertexUpdateEntity> updateVertex(String key, Object value) {
        return this.executorAsync().execute(() -> this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer());
    }

    @Override
    public CompletableFuture<VertexUpdateEntity> updateVertex(String key, Object value, VertexUpdateOptions options) {
        return this.executorAsync().execute(() -> this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> deleteVertex(String key) {
        return this.executorAsync().execute(() -> this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> deleteVertex(String key, VertexDeleteOptions options) {
        return this.executorAsync().execute(() -> this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

