/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogLevelOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class InternalArangoDB
extends ArangoExecuteable {
    private static final String PATH_API_ADMIN_LOG_ENTRIES = "/_admin/log/entries";
    private static final String PATH_API_ADMIN_LOG_LEVEL = "/_admin/log/level";
    private static final String PATH_API_ROLE = "/_admin/server/role";
    private static final String PATH_API_SERVER_ID = "/_admin/server/id";
    private static final String PATH_API_USER = "/_api/user";
    private static final String PATH_API_QUERY_RULES = "/_api/query/rules";

    protected InternalArangoDB(CommunicationProtocol protocol, ArangoConfig config) {
        super(protocol, config);
    }

    protected InternalArangoDB(ArangoExecuteable other) {
        super(other);
    }

    protected InternalRequest getRoleRequest() {
        return this.request("_system", RequestType.GET, PATH_API_ROLE);
    }

    protected InternalRequest getServerIdRequest() {
        return this.request("_system", RequestType.GET, PATH_API_SERVER_ID);
    }

    protected ArangoExecutor.ResponseDeserializer<ServerRole> getRoleResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/role", ServerRole.class);
    }

    protected ArangoExecutor.ResponseDeserializer<String> getServerIdResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/id", String.class);
    }

    protected InternalRequest createDatabaseRequest(DBCreateOptions options) {
        InternalRequest request = this.request("_system", RequestType.POST, "/_api/database");
        request.setBody(this.getSerde().serialize(options));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDatabaseResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), "/result", Boolean.class);
    }

    protected InternalRequest getDatabasesRequest(String dbName) {
        return this.request(dbName, RequestType.GET, "/_api/database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(String.class));
    }

    protected InternalRequest getAccessibleDatabasesForRequest(String dbName, String user) {
        return this.request(dbName, RequestType.GET, PATH_API_USER, user, "database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getAccessibleDatabasesForResponseDeserializer() {
        return response -> {
            Iterator<String> names = this.getSerde().parse(response.getBody(), "/result").fieldNames();
            ArrayList<String> dbs = new ArrayList<String>();
            while (names.hasNext()) {
                dbs.add(names.next());
            }
            return dbs;
        };
    }

    protected InternalRequest createUserRequest(String dbName, String user, String passwd, UserCreateOptions options) {
        InternalRequest request = this.request(dbName, RequestType.POST, PATH_API_USER);
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(options != null ? options : new UserCreateOptions(), user, passwd)));
        return request;
    }

    protected InternalRequest deleteUserRequest(String dbName, String user) {
        return this.request(dbName, RequestType.DELETE, PATH_API_USER, user);
    }

    protected InternalRequest getUsersRequest(String dbName) {
        return this.request(dbName, RequestType.GET, PATH_API_USER);
    }

    protected InternalRequest getUserRequest(String dbName, String user) {
        return this.request(dbName, RequestType.GET, PATH_API_USER, user);
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<UserEntity>> getUsersResponseDeserializer() {
        return response -> (Collection)this.getSerde().deserialize(response.getBody(), "/result", SerdeUtils.constructListType(UserEntity.class));
    }

    protected InternalRequest updateUserRequest(String dbName, String user, UserUpdateOptions options) {
        InternalRequest request = this.request(dbName, RequestType.PATCH, PATH_API_USER, user);
        request.setBody(this.getSerde().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected InternalRequest replaceUserRequest(String dbName, String user, UserUpdateOptions options) {
        InternalRequest request = this.request(dbName, RequestType.PUT, PATH_API_USER, user);
        request.setBody(this.getSerde().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected InternalRequest updateUserDefaultDatabaseAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", "*").setBody(this.getSerde().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected InternalRequest updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return this.request("_system", RequestType.PUT, PATH_API_USER, user, "database", "*", "*").setBody(this.getSerde().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected InternalRequest executeRequest(Request<?> request) {
        InternalRequest ireq = new InternalRequest(request.getDb(), RequestType.from(request.getMethod()), request.getPath());
        ireq.putHeaderParams(request.getHeaders());
        ireq.putQueryParams(request.getQueryParams());
        ireq.setBody(this.getSerde().serializeUserData(request.getBody()));
        return ireq;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<Response<T>> responseDeserializer(Class<T> type) {
        return response -> new Response(response.getResponseCode(), response.getMeta(), this.getSerde().deserializeUserData(response.getBody(), type));
    }

    protected InternalRequest getLogEntriesRequest(LogOptions options) {
        LogOptions params = options != null ? options : new LogOptions();
        return this.request("_system", RequestType.GET, PATH_API_ADMIN_LOG_ENTRIES).putQueryParam("upto", (Object)params.getUpto()).putQueryParam("level", (Object)params.getLevel()).putQueryParam("start", params.getStart()).putQueryParam("size", params.getSize()).putQueryParam("offset", params.getOffset()).putQueryParam("search", params.getSearch()).putQueryParam("sort", (Object)params.getSort());
    }

    protected InternalRequest getLogLevelRequest(LogLevelOptions options) {
        return this.request("_system", RequestType.GET, PATH_API_ADMIN_LOG_LEVEL).putQueryParam("serverId", options.getServerId());
    }

    protected InternalRequest setLogLevelRequest(LogLevelEntity entity, LogLevelOptions options) {
        return this.request("_system", RequestType.PUT, PATH_API_ADMIN_LOG_LEVEL).putQueryParam("serverId", options.getServerId()).setBody(this.getSerde().serialize(entity));
    }

    protected InternalRequest getQueryOptimizerRulesRequest() {
        return this.request("_system", RequestType.GET, PATH_API_QUERY_RULES);
    }
}

