/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.ArangoDBUnavailableException;
import com.arangodb.internal.serde.InternalSerde;
import java.util.concurrent.TimeoutException;

public final class ResponseUtils {
    private static final int ERROR_STATUS = 300;
    private static final int ERROR_INTERNAL = 503;
    private static final String HEADER_ENDPOINT = "x-arango-endpoint";

    private ResponseUtils() {
    }

    public static ArangoDBException translateError(InternalSerde util, InternalResponse response) {
        int responseCode = response.getResponseCode();
        if (responseCode < 300) {
            return null;
        }
        if (responseCode == 503 && response.containsMeta(HEADER_ENDPOINT)) {
            return new ArangoDBRedirectException(String.format("Response Code: %s", responseCode), response.getMeta(HEADER_ENDPOINT));
        }
        if (response.getBody() != null) {
            ErrorEntity errorEntity = util.deserialize(response.getBody(), ErrorEntity.class);
            if (errorEntity.getCode() == 503 && errorEntity.getErrorNum() == 503) {
                return ArangoDBUnavailableException.from(errorEntity);
            }
            ArangoDBException e = new ArangoDBException(errorEntity);
            if (ArangoErrors.QUEUE_TIME_VIOLATED.equals(e.getErrorNum())) {
                return ArangoDBException.of(new TimeoutException().initCause(e));
            }
            return e;
        }
        return new ArangoDBException(String.format("Response Code: %s", responseCode), (Integer)responseCode);
    }
}

