/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.component.as2.api.util.MicUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;

public class AS2MessageDispositionNotificationEntity
extends MimeEntity {
    private static final String ADDRESS_TYPE_PREFIX = "rfc822;";
    private static final String MTA_NAME_TYPE_PREFIX = "dns;";
    private static final String REPORTING_UA = "Reporting-UA";
    private static final String MDN_GATEWAY = "MDN-Gateway";
    private static final String FINAL_RECIPIENT = "Final-Recipient";
    private static final String ORIGINAL_MESSAGE_ID = "Original-Message-ID";
    private static final String AS2_DISPOSITION = "Disposition";
    private static final String FAILURE = "Failure";
    private static final String ERROR = "Error";
    private static final String WARNING = "Warning";
    private static final String RECEIVED_CONTENT_MIC = "Received-content-MIC";
    private String reportingUA;
    private String mtnName;
    private String finalRecipient;
    private String originalMessageId;
    private DispositionMode dispositionMode;
    private AS2DispositionType dispositionType;
    private AS2DispositionModifier dispositionModifier;
    private String[] failureFields;
    private String[] errorFields;
    private String[] warningFields;
    private Map<String, String> extensionFields = new HashMap<String, String>();
    private MicUtils.ReceivedContentMic receivedContentMic;
    private String parsedBodyPartFields;

    public AS2MessageDispositionNotificationEntity(ClassicHttpRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, String charset, boolean isMainBody, PrivateKey decryptingPrivateKey, Certificate[] validateSigningCertificateChain) throws HttpException {
        super(ContentType.create("message/disposition-notification", charset), null);
        this.setMainBody(isMainBody);
        this.finalRecipient = HttpMessageUtils.getHeaderValue(request, "AS2-To");
        if (this.finalRecipient == null) {
            throw new HttpException("The AS2-To is missing");
        }
        this.originalMessageId = HttpMessageUtils.getHeaderValue(request, "Message-Id");
        if (dispositionModifier == null || !dispositionModifier.isError()) {
            this.receivedContentMic = MicUtils.createReceivedContentMic(request, validateSigningCertificateChain, decryptingPrivateKey);
        }
        this.reportingUA = HttpMessageUtils.getHeaderValue(response, "Server");
        this.dispositionMode = ObjectHelper.notNull(dispositionMode, "Disposition Mode");
        this.dispositionType = ObjectHelper.notNull(dispositionType, "Disposition Type");
        this.dispositionModifier = dispositionModifier;
        this.failureFields = failureFields;
        this.errorFields = errorFields;
        this.warningFields = warningFields;
        if (extensionFields == null || extensionFields.isEmpty()) {
            this.extensionFields.clear();
        } else {
            this.extensionFields.putAll(extensionFields);
        }
    }

    public AS2MessageDispositionNotificationEntity(String reportingUA, String mtnName, String finalRecipient, String originalMessageId, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, MicUtils.ReceivedContentMic receivedContentMic, String parsedBodyPartFields) {
        super(ContentType.create("message/disposition-notification"), null);
        this.reportingUA = reportingUA;
        this.mtnName = mtnName;
        this.finalRecipient = finalRecipient;
        this.originalMessageId = originalMessageId;
        this.dispositionMode = dispositionMode;
        this.dispositionType = dispositionType;
        this.dispositionModifier = dispositionModifier;
        this.failureFields = failureFields;
        this.errorFields = errorFields;
        this.warningFields = warningFields;
        this.extensionFields = extensionFields;
        this.receivedContentMic = receivedContentMic;
        this.parsedBodyPartFields = parsedBodyPartFields;
    }

    public String getReportingUA() {
        return this.reportingUA;
    }

    public String getMtnName() {
        return this.mtnName;
    }

    public String getFinalRecipient() {
        return this.finalRecipient;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public DispositionMode getDispositionMode() {
        return this.dispositionMode;
    }

    public AS2DispositionType getDispositionType() {
        return this.dispositionType;
    }

    public AS2DispositionModifier getDispositionModifier() {
        return this.dispositionModifier;
    }

    public String[] getFailureFields() {
        return this.failureFields;
    }

    public String[] getErrorFields() {
        return this.errorFields;
    }

    public String[] getWarningFields() {
        return this.warningFields;
    }

    public Map<String, String> getExtensionFields() {
        return this.extensionFields;
    }

    public MicUtils.ReceivedContentMic getReceivedContentMic() {
        return this.receivedContentMic;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
            BasicHeader failureField;
            if (!this.isMainBody()) {
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            if (this.parsedBodyPartFields != null) {
                canonicalOutstream.writeln(this.parsedBodyPartFields);
                return;
            }
            if (this.reportingUA != null) {
                BasicHeader reportingUAField = new BasicHeader(REPORTING_UA, this.reportingUA);
                canonicalOutstream.writeln(((Object)reportingUAField).toString());
            }
            if (this.mtnName != null) {
                BasicHeader mdnGatewayField = new BasicHeader(MDN_GATEWAY, MTA_NAME_TYPE_PREFIX + this.mtnName);
                canonicalOutstream.writeln(((Object)mdnGatewayField).toString());
            }
            BasicHeader finalRecipientField = new BasicHeader(FINAL_RECIPIENT, ADDRESS_TYPE_PREFIX + this.finalRecipient);
            canonicalOutstream.writeln(((Object)finalRecipientField).toString());
            if (this.originalMessageId != null) {
                BasicHeader originalMessageIdField = new BasicHeader(ORIGINAL_MESSAGE_ID, this.originalMessageId);
                canonicalOutstream.writeln(((Object)originalMessageIdField).toString());
            }
            String as2Disposition = this.dispositionMode.toString() + ";" + this.dispositionType.toString();
            if (this.dispositionModifier != null) {
                as2Disposition = as2Disposition + "/" + this.dispositionModifier.toString();
            }
            BasicHeader as2DispositionField = new BasicHeader(AS2_DISPOSITION, as2Disposition);
            canonicalOutstream.writeln(((Object)as2DispositionField).toString());
            if (this.failureFields != null) {
                for (String string : this.failureFields) {
                    failureField = new BasicHeader(FAILURE, string);
                    canonicalOutstream.writeln(((Object)failureField).toString());
                }
            }
            if (this.errorFields != null) {
                for (String string : this.errorFields) {
                    BasicHeader errorField = new BasicHeader(ERROR, string);
                    canonicalOutstream.writeln(((Object)errorField).toString());
                }
            }
            if (this.failureFields != null) {
                for (String string : this.failureFields) {
                    failureField = new BasicHeader(WARNING, string);
                    canonicalOutstream.writeln(((Object)failureField).toString());
                }
            }
            if (this.extensionFields != null) {
                for (Map.Entry entry : this.extensionFields.entrySet()) {
                    BasicHeader failureField2 = new BasicHeader((String)entry.getKey(), entry.getValue());
                    canonicalOutstream.writeln(((Object)failureField2).toString());
                }
            }
            if (this.receivedContentMic != null) {
                BasicHeader as2ReceivedContentMicField = new BasicHeader(RECEIVED_CONTENT_MIC, this.receivedContentMic.toString());
                canonicalOutstream.writeln(((Object)as2ReceivedContentMicField).toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

