/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.camel.CamelException;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeCompressedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeEnvelopedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7SignatureEntity;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.entity.TextPlainEntity;
import org.apache.camel.component.as2.api.exception.AS2DecryptionException;
import org.apache.camel.component.as2.api.io.AS2SessionInputBuffer;
import org.apache.camel.component.as2.api.util.AS2HeaderUtils;
import org.apache.camel.component.as2.api.util.ContentTypeUtils;
import org.apache.camel.component.as2.api.util.DispositionNotificationContentUtils;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.codec.DecoderException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.message.BasicLineParser;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.bouncycastle.cms.CMSCompressedData;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.operator.InputExpanderProvider;

public final class EntityParser {
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private EntityParser() {
    }

    public static boolean isBoundaryCloseDelimiter(CharArrayBuffer buffer, ParserCursor cursor, String boundary) {
        ObjectHelper.notNull(buffer, "Buffer");
        ObjectHelper.notNull(boundary, "Boundary");
        String boundaryCloseDelimiter = "--" + boundary + "--";
        if (cursor == null) {
            cursor = new ParserCursor(0, boundaryCloseDelimiter.length());
        }
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        if (indexFrom + boundaryCloseDelimiter.length() > indexTo) {
            return false;
        }
        for (int i = indexFrom; i < indexTo; ++i) {
            if (buffer.charAt(i) == boundaryCloseDelimiter.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBoundaryDelimiter(CharArrayBuffer buffer, ParserCursor cursor, String boundary) {
        ObjectHelper.notNull(buffer, "Buffer");
        ObjectHelper.notNull(boundary, "Boundary");
        String boundaryDelimiter = "--" + boundary;
        if (cursor == null) {
            cursor = new ParserCursor(0, boundaryDelimiter.length());
        }
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        if (indexFrom + boundaryDelimiter.length() > indexTo) {
            return false;
        }
        for (int i = indexFrom; i < indexTo; ++i) {
            if (buffer.charAt(i) == boundaryDelimiter.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static void skipPreambleAndStartBoundary(AS2SessionInputBuffer inbuffer, InputStream is, String boundary) throws HttpException {
        boolean foundStartBoundary;
        try {
            foundStartBoundary = false;
            CharArrayBuffer lineBuffer = new CharArrayBuffer(1024);
            while (inbuffer.readLine(lineBuffer, is) != -1) {
                ParserCursor cursor = new ParserCursor(0, lineBuffer.length());
                if (EntityParser.isBoundaryDelimiter(lineBuffer, cursor, boundary)) {
                    foundStartBoundary = true;
                    break;
                }
                lineBuffer.clear();
            }
        }
        catch (Exception e) {
            throw new HttpException("Failed to read start boundary for body part", e);
        }
        if (!foundStartBoundary) {
            throw new HttpException("Failed to find start boundary for body part");
        }
    }

    public static void skipToBoundary(AS2SessionInputBuffer inbuffer, InputStream is, String boundary) throws HttpException {
        boolean foundEndBoundary;
        try {
            foundEndBoundary = false;
            CharArrayBuffer lineBuffer = new CharArrayBuffer(1024);
            while (inbuffer.readLine(lineBuffer, is) != -1) {
                ParserCursor cursor = new ParserCursor(0, lineBuffer.length());
                if (EntityParser.isBoundaryDelimiter(lineBuffer, cursor, boundary)) {
                    foundEndBoundary = true;
                    break;
                }
                lineBuffer.clear();
            }
        }
        catch (Exception e) {
            throw new HttpException("Failed to read start boundary for body part", e);
        }
        if (!foundEndBoundary && boundary != null) {
            throw new HttpException("Failed to find start boundary for body part");
        }
    }

    public static MimeEntity parseCompressedEntity(byte[] compressedData, InputExpanderProvider expanderProvider) throws HttpException {
        byte[] uncompressedContent = EntityParser.uncompressData(compressedData, expanderProvider);
        return EntityParser.parseEntity(uncompressedContent);
    }

    public static MimeEntity parseEnvelopedEntity(byte[] envelopedContent, PrivateKey privateKey) throws HttpException {
        byte[] decryptedContent = EntityParser.decryptData(envelopedContent, privateKey);
        return EntityParser.parseEntity(decryptedContent);
    }

    public static MimeEntity parseEntity(byte[] content) throws HttpException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            AS2SessionInputBuffer inbuffer = new AS2SessionInputBuffer(new BasicHttpTransportMetrics(), 8192);
            Header[] headers = AbstractMessageParser.parseHeaders(inbuffer, is, -1, -1, BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            ContentType entityContentType = null;
            String entityContentTransferEncoding = null;
            for (Header header : headers) {
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    entityContentType = ContentType.parse(header.getValue());
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) continue;
                entityContentTransferEncoding = header.getValue();
            }
            if (entityContentType == null) {
                throw new HttpException("Failed to find Content-Type header in enveloped entity");
            }
            MimeEntity entity = EntityParser.parseEntityBody(inbuffer, is, null, entityContentType, entityContentTransferEncoding, "", headers);
            Objects.requireNonNull(entity, "Trying to parse entity body resulted in a null MimeEntity");
            entity.removeAllHeaders();
            entity.setHeaders(headers);
            return entity;
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity", e);
        }
    }

    public static byte[] uncompressData(byte[] compressedData, InputExpanderProvider expanderProvider) throws HttpException {
        try {
            CMSCompressedData cmsCompressedData = new CMSCompressedData(compressedData);
            return cmsCompressedData.getContent(expanderProvider);
        }
        catch (CMSException e) {
            throw new HttpException("Failed to decompress data", e);
        }
    }

    public static byte[] decryptData(byte[] encryptedData, PrivateKey privateKey) throws HttpException {
        try {
            CMSEnvelopedData cmsEnvelopedData = new CMSEnvelopedData(encryptedData);
            RecipientInformationStore recipientsInformationStore = cmsEnvelopedData.getRecipientInfos();
            Collection<RecipientInformation> recipients = recipientsInformationStore.getRecipients();
            Iterator<RecipientInformation> it = recipients.iterator();
            if (it.hasNext()) {
                JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(privateKey);
                RecipientInformation recipientInfo = it.next();
                return recipientInfo.getContent(recipient);
            }
        }
        catch (CMSException e) {
            throw new AS2DecryptionException("Failed to decrypt data", e);
        }
        throw new AS2DecryptionException("Failed to decrypt data: bno recipient information");
    }

    private static void parseApplicationPkcs7MimeCompressedEntity(HttpMessage message, InputStream is, AS2SessionInputBuffer inBuffer, ContentType contentType, String contentTransferEncoding) throws HttpException {
        ApplicationPkcs7MimeCompressedDataEntity applicationPkcs7MimeCompressedDataEntity = null;
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(inBuffer, "inBuffer");
        HttpEntity entity = ObjectHelper.notNull(EntityUtils.getMessageEntity(message), "message entity");
        if (entity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
            return;
        }
        Args.check(entity.isStreaming(), "Message entity can not be parsed: entity is not streaming");
        try {
            applicationPkcs7MimeCompressedDataEntity = EntityParser.parseApplicationPkcs7MimeCompressedDataEntityBody(inBuffer, is, null, contentType, contentTransferEncoding);
            applicationPkcs7MimeCompressedDataEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, applicationPkcs7MimeCompressedDataEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", e);
        }
    }

    private static void parseApplicationPkcs7MimeEnvelopedEntity(HttpMessage message, InputStream is, AS2SessionInputBuffer inBuffer, ContentType contentType, String contentTransferEncoding) throws HttpException {
        ApplicationPkcs7MimeEnvelopedDataEntity applicationPkcs7MimeEnvelopedDataEntity = null;
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(inBuffer, "inBuffer");
        HttpEntity entity = ObjectHelper.notNull(EntityUtils.getMessageEntity(message), "message entity");
        if (entity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
            return;
        }
        Args.check(entity.isStreaming(), "Message entity can not be parsed: entity is not streaming");
        try {
            applicationPkcs7MimeEnvelopedDataEntity = EntityParser.parseApplicationPkcs7MimeEnvelopedDataEntityBody(inBuffer, is, null, contentType, contentTransferEncoding);
            applicationPkcs7MimeEnvelopedDataEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, applicationPkcs7MimeEnvelopedDataEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", e);
        }
    }

    private static void parseMultipartSignedEntity(HttpMessage message, InputStream is, AS2SessionInputBuffer inBuffer, String boundary, String charsetName, String contentTransferEncoding) throws HttpException {
        MultipartSignedEntity multipartSignedEntity = null;
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(inBuffer, "inBuffer");
        ObjectHelper.notNull(boundary, "boundary");
        ObjectHelper.notNull(charsetName, "charsetName");
        HttpEntity entity = ObjectHelper.notNull(EntityUtils.getMessageEntity(message), "message entity");
        if (entity instanceof MultipartSignedEntity) {
            return;
        }
        Args.check(entity.isStreaming(), "Message entity can not be parsed: entity is not streaming");
        try {
            String micalg = HttpMessageUtils.getParameterValue(message, "Content-Type", "micalg");
            if (micalg == null) {
                throw new HttpException("Failed to retrieve 'micalg' parameter from content type header");
            }
            multipartSignedEntity = EntityParser.parseMultipartSignedEntityBody(inBuffer, is, boundary, micalg, charsetName, contentTransferEncoding);
            multipartSignedEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, multipartSignedEntity);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", e);
        }
    }

    private static void parseApplicationEDIEntity(HttpMessage message, InputStream is, AS2SessionInputBuffer inBuffer, ContentType contentType, String contentTransferEncoding) throws HttpException {
        ApplicationEntity applicationEntity = null;
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(inBuffer, "inBuffer");
        HttpEntity entity = ObjectHelper.notNull(EntityUtils.getMessageEntity(message), "message entity");
        if (entity instanceof ApplicationEntity) {
            return;
        }
        Args.check(entity.isStreaming(), "Message entity can not be parsed: entity is not streaming");
        try {
            applicationEntity = EntityParser.parseEDIEntityBody(inBuffer, is, null, contentType, contentTransferEncoding, "");
            applicationEntity.setMainBody(true);
            EntityUtils.setMessageEntity(message, applicationEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", e);
        }
    }

    private static void parseMessageDispositionNotificationReportEntity(HttpMessage message, InputStream is, AS2SessionInputBuffer inBuffer, String boundary, String charsetName, String contentTransferEncoding) throws HttpException {
        DispositionNotificationMultipartReportEntity dispositionNotificationMultipartReportEntity = null;
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(inBuffer, "inBuffer");
        ObjectHelper.notNull(boundary, "boundary");
        ObjectHelper.notNull(charsetName, "charsetName");
        HttpEntity entity = ObjectHelper.notNull(EntityUtils.getMessageEntity(message), "message entity");
        if (entity instanceof DispositionNotificationMultipartReportEntity) {
            return;
        }
        Args.check(entity.isStreaming(), "Message entity can not be parsed: entity is not streaming");
        try {
            dispositionNotificationMultipartReportEntity = EntityParser.parseMultipartReportEntityBody(inBuffer, is, boundary, charsetName, contentTransferEncoding);
            EntityUtils.setMessageEntity(message, dispositionNotificationMultipartReportEntity);
        }
        catch (Exception e) {
            throw new HttpException("Failed to parse entity content", e);
        }
    }

    public static void parseAS2MessageEntity(HttpMessage message) throws HttpException {
        if (EntityUtils.hasEntity(message)) {
            HttpEntity entity = ObjectHelper.notNull(EntityUtils.getMessageEntity(message), "message entity");
            if (entity instanceof MimeEntity) {
                return;
            }
            try {
                String contentTypeStr = HttpMessageUtils.getHeaderValue(message, "Content-Type");
                if (contentTypeStr == null) {
                    return;
                }
                EntityParser.doParseAS2MessageEntity(message, contentTypeStr, entity);
            }
            catch (HttpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HttpException("Failed to parse entity content", e);
            }
        }
    }

    private static void doParseAS2MessageEntity(HttpMessage message, String contentTypeStr, HttpEntity entity) throws HttpException, IOException {
        ContentType contentType = ContentType.parse(contentTypeStr);
        String charsetName = StandardCharsets.US_ASCII.name();
        Charset charset = contentType.getCharset();
        if (charset != null) {
            charsetName = charset.name();
        }
        String boundary = HttpMessageUtils.getParameterValue(message, "Content-Type", "boundary");
        String contentTransferEncoding = HttpMessageUtils.getHeaderValue(message, "Content-Transfer-Encoding");
        AS2SessionInputBuffer inBuffer = new AS2SessionInputBuffer(new BasicHttpTransportMetrics(), 8192);
        EntityParser.parseByMimeType(message, contentType, entity, inBuffer, contentTransferEncoding, boundary, charsetName);
    }

    private static void parseByMimeType(HttpMessage message, ContentType contentType, HttpEntity entity, AS2SessionInputBuffer inBuffer, String contentTransferEncoding, String boundary, String charsetName) throws HttpException, IOException {
        block8 : switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact": 
            case "application/edi-x12": 
            case "application/edi-consent": {
                EntityParser.parseApplicationEDIEntity(message, entity.getContent(), inBuffer, contentType, contentTransferEncoding);
                break;
            }
            case "multipart/signed": {
                EntityParser.parseMultipartSignedEntity(message, entity.getContent(), inBuffer, boundary, charsetName, contentTransferEncoding);
                break;
            }
            case "application/pkcs7-mime": {
                switch (contentType.getParameter("smime-type")) {
                    case "compressed-data": {
                        EntityParser.parseApplicationPkcs7MimeCompressedEntity(message, entity.getContent(), inBuffer, contentType, contentTransferEncoding);
                        break block8;
                    }
                    case "enveloped-data": {
                        EntityParser.parseApplicationPkcs7MimeEnvelopedEntity(message, entity.getContent(), inBuffer, contentType, contentTransferEncoding);
                        break block8;
                    }
                }
                break;
            }
            case "multipart/report": {
                EntityParser.parseMessageDispositionNotificationReportEntity(message, entity.getContent(), inBuffer, boundary, charsetName, contentTransferEncoding);
                break;
            }
        }
    }

    public static MultipartSignedEntity parseMultipartSignedEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, String micalg, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = StandardCharsets.US_ASCII.name();
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            NameValuePair[] parameters = new NameValuePair[]{new BasicNameValuePair("protocol", "application/pkcs7-signature"), new BasicNameValuePair("boundary", boundary), new BasicNameValuePair("micalg", micalg), new BasicNameValuePair("charset", charsetName)};
            ContentType contentType = ContentType.create("multipart/signed", parameters);
            MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(contentType, contentTransferEncoding, boundary, false);
            EntityParser.skipPreambleAndStartBoundary(inbuffer, is, boundary);
            Header[] headers = AbstractMessageParser.parseHeaders(inbuffer, is, -1, -1, BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            ContentType signedEntityContentType = null;
            String signedEntityContentTransferEncoding = null;
            for (Header header : headers) {
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    signedEntityContentType = ContentType.parse(header.getValue());
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) continue;
                signedEntityContentTransferEncoding = header.getValue();
            }
            if (signedEntityContentType == null) {
                throw new HttpException("Failed to find Content-Type header in signed entity body part");
            }
            MimeEntity signedEntity = EntityParser.parseEntityBody(inbuffer, is, boundary, signedEntityContentType, signedEntityContentTransferEncoding, "", headers);
            signedEntity.removeAllHeaders();
            signedEntity.setHeaders(headers);
            multipartSignedEntity.addPart(signedEntity);
            headers = AbstractMessageParser.parseHeaders(inbuffer, is, -1, -1, BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            ContentType signatureContentType = null;
            String signatureContentTransferEncoding = null;
            for (Header header : headers) {
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    signatureContentType = ContentType.parse(header.getValue());
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) continue;
                signatureContentTransferEncoding = header.getValue();
            }
            if (signatureContentType == null) {
                throw new HttpException("Failed to find Content-Type header in signature body part");
            }
            if (!ContentTypeUtils.isPkcs7SignatureType(signatureContentType)) {
                throw new HttpException("Invalid content type '" + signatureContentType.getMimeType() + "' for signature body part");
            }
            ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity = EntityParser.parseApplicationPkcs7SignatureEntityBody(inbuffer, is, boundary, signatureContentType, signatureContentTransferEncoding);
            applicationPkcs7SignatureEntity.removeAllHeaders();
            applicationPkcs7SignatureEntity.setHeaders(headers);
            multipartSignedEntity.addPart(applicationPkcs7SignatureEntity);
            MultipartSignedEntity multipartSignedEntity2 = multipartSignedEntity;
            return multipartSignedEntity2;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse text entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static DispositionNotificationMultipartReportEntity parseMultipartReportEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = StandardCharsets.US_ASCII.name();
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            DispositionNotificationMultipartReportEntity dispositionNotificationMultipartReportEntity = new DispositionNotificationMultipartReportEntity(boundary, contentTransferEncoding, false);
            EntityParser.skipPreambleAndStartBoundary(inbuffer, is, boundary);
            Header[] headers = AbstractMessageParser.parseHeaders(inbuffer, is, -1, -1, BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            ContentType textReportContentType = null;
            String textReportContentTransferEncoding = null;
            for (Header header : headers) {
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    textReportContentType = ContentType.parse(header.getValue());
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-Transfer-Encoding")) continue;
                textReportContentTransferEncoding = header.getValue();
            }
            if (textReportContentType == null) {
                throw new HttpException("Failed to find Content-Type header in EDI message body part");
            }
            if (!textReportContentType.getMimeType().equalsIgnoreCase("text/plain")) {
                throw new HttpException("Invalid content type '" + textReportContentType.getMimeType() + "' for first body part of disposition notification");
            }
            String textReportCharsetName = textReportContentType.getCharset() == null ? StandardCharsets.US_ASCII.name() : textReportContentType.getCharset().name();
            TextPlainEntity textReportEntity = EntityParser.parseTextPlainEntityBody(inbuffer, is, boundary, textReportCharsetName, textReportContentTransferEncoding);
            textReportEntity.setHeaders(headers);
            dispositionNotificationMultipartReportEntity.addPart(textReportEntity);
            headers = AbstractMessageParser.parseHeaders(inbuffer, is, -1, -1, BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            ContentType dispositionNotificationContentType = null;
            for (Header header : headers) {
                if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                dispositionNotificationContentType = ContentType.parse(header.getValue());
            }
            if (dispositionNotificationContentType == null) {
                throw new HttpException("Failed to find Content-Type header in body part");
            }
            if (!dispositionNotificationContentType.getMimeType().equalsIgnoreCase("message/disposition-notification")) {
                throw new HttpException("Invalid content type '" + dispositionNotificationContentType.getMimeType() + "' for second body part of disposition notification");
            }
            String string = dispositionNotificationContentType.getCharset() == null ? StandardCharsets.US_ASCII.name() : dispositionNotificationContentType.getCharset().name();
            AS2MessageDispositionNotificationEntity messageDispositionNotificationEntity = EntityParser.parseMessageDispositionNotificationEntityBody(inbuffer, is, boundary, string);
            messageDispositionNotificationEntity.setHeaders(headers);
            dispositionNotificationMultipartReportEntity.addPart(messageDispositionNotificationEntity);
            DispositionNotificationMultipartReportEntity dispositionNotificationMultipartReportEntity2 = dispositionNotificationMultipartReportEntity;
            return dispositionNotificationMultipartReportEntity2;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse text entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static TextPlainEntity parseTextPlainEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, String charsetName, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            if (charsetName == null) {
                charsetName = StandardCharsets.US_ASCII.name();
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String text = EntityParser.parseBodyPartText(inbuffer, is, boundary);
            if (contentTransferEncoding != null) {
                text = EntityUtils.decode(text, charset, contentTransferEncoding);
            }
            TextPlainEntity textPlainEntity = new TextPlainEntity(text, charsetName, contentTransferEncoding, false);
            return textPlainEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse text entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static AS2MessageDispositionNotificationEntity parseMessageDispositionNotificationEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, String charsetName) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            AS2MessageDispositionNotificationEntity as2MessageDispositionNotificationEntity;
            if (charsetName == null) {
                charsetName = StandardCharsets.US_ASCII.name();
            }
            Charset charset = Charset.forName(charsetName);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            List<CharArrayBuffer> dispositionNotificationFields = EntityParser.parseBodyPartFields(inbuffer, is, boundary, BasicLineParser.INSTANCE, new ArrayList<CharArrayBuffer>());
            AS2MessageDispositionNotificationEntity aS2MessageDispositionNotificationEntity = as2MessageDispositionNotificationEntity = DispositionNotificationContentUtils.parseDispositionNotification(dispositionNotificationFields);
            return aS2MessageDispositionNotificationEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse MDN entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static MimeEntity parseEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, ContentType entityContentType, String contentTransferEncoding, String filename, Header[] headers) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            Charset charset = entityContentType.getCharset();
            if (charset == null) {
                charset = StandardCharsets.US_ASCII;
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            MimeEntity entity = null;
            block14 : switch (entityContentType.getMimeType().toLowerCase()) {
                case "application/edifact": 
                case "application/edi-x12": 
                case "application/edi-consent": 
                case "application/xml": {
                    entity = EntityParser.parseEDIEntityBody(inbuffer, is, boundary, entityContentType, contentTransferEncoding, filename);
                    break;
                }
                case "multipart/signed": {
                    String multipartSignedBoundary = AS2HeaderUtils.getParameterValue(headers, "Content-Type", "boundary");
                    String micalg = AS2HeaderUtils.getParameterValue(headers, "Content-Type", "micalg");
                    entity = EntityParser.parseMultipartSignedEntityBody(inbuffer, is, multipartSignedBoundary, micalg, charset.name(), contentTransferEncoding);
                    EntityParser.skipToBoundary(inbuffer, is, boundary);
                    break;
                }
                case "message/disposition-notification": {
                    entity = EntityParser.parseMessageDispositionNotificationEntityBody(inbuffer, is, boundary, charset.name());
                    break;
                }
                case "multipart/report": {
                    String multipartReportBoundary = AS2HeaderUtils.getParameterValue(headers, "Content-Type", "boundary");
                    entity = EntityParser.parseMultipartReportEntityBody(inbuffer, is, multipartReportBoundary, charset.name(), contentTransferEncoding);
                    EntityParser.skipToBoundary(inbuffer, is, boundary);
                    break;
                }
                case "text/plain": {
                    entity = EntityParser.parseTextPlainEntityBody(inbuffer, is, boundary, charset.name(), contentTransferEncoding);
                    break;
                }
                case "application/pkcs7-signature": {
                    entity = EntityParser.parseApplicationPkcs7SignatureEntityBody(inbuffer, is, boundary, entityContentType, contentTransferEncoding);
                    break;
                }
                case "application/pkcs7-mime": {
                    switch (entityContentType.getParameter("smime-type")) {
                        case "compressed-data": {
                            entity = EntityParser.parseApplicationPkcs7MimeCompressedDataEntityBody(inbuffer, is, boundary, entityContentType, contentTransferEncoding);
                            break block14;
                        }
                        case "enveloped-data": {
                            entity = EntityParser.parseApplicationPkcs7MimeEnvelopedDataEntityBody(inbuffer, is, boundary, entityContentType, contentTransferEncoding);
                            break block14;
                        }
                    }
                    break;
                }
            }
            String string = entity;
            return string;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse EDI entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationEntity parseEDIEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, ContentType ediMessageContentType, String contentTransferEncoding, String filename) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            Charset charset = ediMessageContentType.getCharset();
            if (charset == null) {
                charset = StandardCharsets.US_ASCII;
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
            String ediMessageBodyPartContent = EntityParser.parseBodyPartText(inbuffer, is, boundary);
            if (contentTransferEncoding != null) {
                ediMessageBodyPartContent = EntityUtils.decode(ediMessageBodyPartContent, charset, contentTransferEncoding);
            }
            ApplicationEntity applicationEntity = EntityUtils.createEDIEntity(ediMessageBodyPartContent, ediMessageContentType, contentTransferEncoding, false, filename);
            return applicationEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse EDI entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationPkcs7SignatureEntity parseApplicationPkcs7SignatureEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, ContentType contentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            byte[] signature = EntityParser.parseBodyPartBytes(inbuffer, is, boundary, contentType, contentTransferEncoding);
            Charset charset = contentType.getCharset();
            if (charset == null) {
                charset = StandardCharsets.US_ASCII;
            }
            String charsetName = charset.toString();
            ApplicationPkcs7SignatureEntity applicationPkcs7SignatureEntity = new ApplicationPkcs7SignatureEntity(signature, charsetName, contentTransferEncoding, false);
            return applicationPkcs7SignatureEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse PKCS7 Signature entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationPkcs7MimeEnvelopedDataEntity parseApplicationPkcs7MimeEnvelopedDataEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, ContentType contentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            byte[] encryptedContent = EntityParser.parseBodyPartBytes(inbuffer, is, boundary, contentType, contentTransferEncoding);
            ApplicationPkcs7MimeEnvelopedDataEntity applicationPkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(encryptedContent, contentTransferEncoding, false);
            return applicationPkcs7MimeEnvelopedDataEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse PKCS7 Mime entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static ApplicationPkcs7MimeCompressedDataEntity parseApplicationPkcs7MimeCompressedDataEntityBody(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, ContentType contentType, String contentTransferEncoding) throws ParseException {
        CharsetDecoder previousDecoder = inbuffer.getCharsetDecoder();
        try {
            byte[] compressedContent = EntityParser.parseBodyPartBytes(inbuffer, is, boundary, contentType, contentTransferEncoding);
            ApplicationPkcs7MimeCompressedDataEntity applicationPkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(compressedContent, contentTransferEncoding, false);
            return applicationPkcs7MimeCompressedDataEntity;
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("failed to parse PKCS7 Mime entity");
            parseException.initCause(e);
            throw parseException;
        }
        finally {
            inbuffer.setCharsetDecoder(previousDecoder);
        }
    }

    public static byte[] parseBodyPartBytes(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, ContentType contentType, String contentTransferEncoding) throws IOException, CamelException, DecoderException {
        byte[] bodyContentBytes;
        Charset charset = contentType.getCharset();
        if (charset != null) {
            CharsetDecoder charsetDecoder = charset.newDecoder();
            inbuffer.setCharsetDecoder(charsetDecoder);
        } else {
            inbuffer.setCharsetDecoder(null);
        }
        String bodyContent = EntityParser.parseBodyPartText(inbuffer, is, boundary);
        if (charset != null) {
            bodyContentBytes = bodyContent.getBytes(charset);
        } else {
            bodyContentBytes = new byte[bodyContent.length()];
            for (int i = 0; i < bodyContent.length(); ++i) {
                bodyContentBytes[i] = (byte)bodyContent.charAt(i);
            }
        }
        return EntityUtils.decode(bodyContentBytes, contentTransferEncoding);
    }

    public static String parseBodyPartText(AS2SessionInputBuffer inbuffer, InputStream is, String boundary) throws IOException {
        int l;
        CharArrayBuffer buffer = new CharArrayBuffer(8192);
        CharArrayBuffer line = new CharArrayBuffer(8192);
        while ((l = inbuffer.readLine(line, is)) != -1) {
            if (boundary != null && EntityParser.isBoundaryDelimiter(line, null, boundary)) {
                int length = buffer.length();
                buffer.setLength(length - 2);
                break;
            }
            buffer.append(line);
            if (inbuffer.isLastLineReadEnrichedByCarriageReturn()) {
                buffer.append('\r');
            }
            if (inbuffer.isLastLineReadTerminatedByLineFeed()) {
                buffer.append('\n');
            }
            line.clear();
        }
        return buffer.toString();
    }

    public static List<CharArrayBuffer> parseBodyPartFields(AS2SessionInputBuffer inbuffer, InputStream is, String boundary, LineParser parser, List<CharArrayBuffer> fields) throws IOException {
        ObjectHelper.notNull(parser, "parser");
        ObjectHelper.notNull(fields, "fields");
        CharArrayBuffer current = null;
        CharArrayBuffer previous = null;
        while (true) {
            int l;
            if (current == null) {
                current = new CharArrayBuffer(64);
            }
            if ((l = inbuffer.readLine(current, is)) == -1 || current.length() < 1 || boundary != null && EntityParser.isBoundaryDelimiter(current, null, boundary)) break;
            if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                char ch;
                int i;
                for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                }
                previous.append(' ');
                previous.append(current, i, current.length() - i);
                current.clear();
                continue;
            }
            fields.add(current);
            previous = current;
            current = null;
        }
        return fields;
    }
}

