/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Mod;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

class BIKERing {
    private static final int PERMUTATION_CUTOFF = 64;
    private final int bits;
    private final int size;
    private final int sizeExt;
    private final Map<Integer, Integer> halfPowers = new HashMap<Integer, Integer>();

    BIKERing(int r) {
        if ((r & 0xFFFF0001) != 1) {
            throw new IllegalArgumentException();
        }
        this.bits = r;
        this.size = r + 63 >>> 6;
        this.sizeExt = this.size * 2;
        BIKERing.generateHalfPowersInv(this.halfPowers, r);
    }

    void add(long[] x, long[] y, long[] z) {
        for (int i = 0; i < this.size; ++i) {
            z[i] = x[i] ^ y[i];
        }
    }

    void addTo(long[] x, long[] z) {
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            z[n] = z[n] ^ x[i];
        }
    }

    void copy(long[] x, long[] z) {
        for (int i = 0; i < this.size; ++i) {
            z[i] = x[i];
        }
    }

    long[] create() {
        return new long[this.size];
    }

    long[] createExt() {
        return new long[this.sizeExt];
    }

    void decodeBytes(byte[] bs, long[] z) {
        int partialBits = this.bits & 0x3F;
        Pack.littleEndianToLong(bs, 0, z, 0, this.size - 1);
        byte[] last = new byte[8];
        System.arraycopy(bs, this.size - 1 << 3, last, 0, partialBits + 7 >>> 3);
        z[this.size - 1] = Pack.littleEndianToLong(last, 0);
    }

    byte[] encodeBitsTransposed(long[] x) {
        byte[] bs = new byte[this.bits];
        bs[0] = (byte)(x[0] & 1L);
        for (int i = 1; i < this.bits; ++i) {
            bs[this.bits - i] = (byte)(x[i >>> 6] >>> (i & 0x3F) & 1L);
        }
        return bs;
    }

    void encodeBytes(long[] x, byte[] bs) {
        int partialBits = this.bits & 0x3F;
        Pack.longToLittleEndian(x, 0, this.size - 1, bs, 0);
        byte[] last = new byte[8];
        Pack.longToLittleEndian(x[this.size - 1], last, 0);
        System.arraycopy(last, 0, bs, this.size - 1 << 3, partialBits + 7 >>> 3);
    }

    void inv(long[] a, long[] z) {
        long[] f = this.create();
        long[] g = this.create();
        long[] t = this.create();
        this.copy(a, f);
        this.copy(a, t);
        int rSub2 = this.bits - 2;
        int bits = 32 - Integers.numberOfLeadingZeros(rSub2);
        for (int i = 1; i < bits; ++i) {
            this.squareN(f, 1 << i - 1, g);
            this.multiply(f, g, f);
            if ((rSub2 & 1 << i) == 0) continue;
            int n = rSub2 & (1 << i) - 1;
            this.squareN(f, n, g);
            this.multiply(t, g, t);
        }
        this.square(t, z);
    }

    void multiply(long[] x, long[] y, long[] z) {
        long[] tt = this.createExt();
        this.implMultiplyAcc(x, y, tt);
        this.reduce(tt, z);
    }

    void reduce(long[] tt, long[] z) {
        int partialBits = this.bits & 0x3F;
        int excessBits = 64 - partialBits;
        long partialMask = -1L >>> excessBits;
        Nat.shiftUpBits64(this.size, tt, this.size, excessBits, tt[this.size - 1], z, 0);
        this.addTo(tt, z);
        int n = this.size - 1;
        z[n] = z[n] & partialMask;
    }

    int getSize() {
        return this.size;
    }

    int getSizeExt() {
        return this.sizeExt;
    }

    void square(long[] x, long[] z) {
        long[] tt = this.createExt();
        this.implSquare(x, tt);
        this.reduce(tt, z);
    }

    void squareN(long[] x, int n, long[] z) {
        if (n >= 64) {
            this.implPermute(x, n, z);
            return;
        }
        long[] tt = this.createExt();
        this.implSquare(x, tt);
        this.reduce(tt, z);
        while (--n > 0) {
            this.implSquare(z, tt);
            this.reduce(tt, z);
        }
    }

    private static int implModAdd(int m, int x, int y) {
        int t = x + y - m;
        return t + (t >> 31 & m);
    }

    protected void implMultiplyAcc(long[] x, long[] y, long[] zz) {
        long[] u = new long[16];
        for (int i = 0; i < this.size; ++i) {
            BIKERing.implMulwAcc(u, x[i], y[i], zz, i << 1);
        }
        long v0 = zz[0];
        long v1 = zz[1];
        for (int i = 1; i < this.size; ++i) {
            zz[i] = (v0 ^= zz[i << 1]) ^ v1;
            v1 ^= zz[(i << 1) + 1];
        }
        long w = v0 ^ v1;
        for (int i = 0; i < this.size; ++i) {
            zz[this.size + i] = zz[i] ^ w;
        }
        int last = this.size - 1;
        for (int zPos = 1; zPos < last * 2; ++zPos) {
            int hi = Math.min(last, zPos);
            for (int lo = zPos - hi; lo < hi; ++lo, --hi) {
                BIKERing.implMulwAcc(u, x[lo] ^ x[hi], y[lo] ^ y[hi], zz, zPos);
            }
        }
    }

    private void implPermute(long[] x, int n, long[] z) {
        int r = this.bits;
        int pow_1 = this.halfPowers.get(Integers.valueOf(n));
        int pow_2 = BIKERing.implModAdd(r, pow_1, pow_1);
        int pow_4 = BIKERing.implModAdd(r, pow_2, pow_2);
        int pow_8 = BIKERing.implModAdd(r, pow_4, pow_4);
        int p0 = r - pow_8;
        int p1 = BIKERing.implModAdd(r, p0, pow_1);
        int p2 = BIKERing.implModAdd(r, p0, pow_2);
        int p3 = BIKERing.implModAdd(r, p1, pow_2);
        int p4 = BIKERing.implModAdd(r, p0, pow_4);
        int p5 = BIKERing.implModAdd(r, p1, pow_4);
        int p6 = BIKERing.implModAdd(r, p2, pow_4);
        int p7 = BIKERing.implModAdd(r, p3, pow_4);
        for (int i = 0; i < this.size; ++i) {
            long z_i = 0L;
            for (int j = 0; j < 64; j += 8) {
                p0 = BIKERing.implModAdd(r, p0, pow_8);
                p1 = BIKERing.implModAdd(r, p1, pow_8);
                p2 = BIKERing.implModAdd(r, p2, pow_8);
                p3 = BIKERing.implModAdd(r, p3, pow_8);
                p4 = BIKERing.implModAdd(r, p4, pow_8);
                p5 = BIKERing.implModAdd(r, p5, pow_8);
                p6 = BIKERing.implModAdd(r, p6, pow_8);
                p7 = BIKERing.implModAdd(r, p7, pow_8);
                z_i |= (x[p0 >>> 6] >>> p0 & 1L) << j + 0;
                z_i |= (x[p1 >>> 6] >>> p1 & 1L) << j + 1;
                z_i |= (x[p2 >>> 6] >>> p2 & 1L) << j + 2;
                z_i |= (x[p3 >>> 6] >>> p3 & 1L) << j + 3;
                z_i |= (x[p4 >>> 6] >>> p4 & 1L) << j + 4;
                z_i |= (x[p5 >>> 6] >>> p5 & 1L) << j + 5;
                z_i |= (x[p6 >>> 6] >>> p6 & 1L) << j + 6;
                z_i |= (x[p7 >>> 6] >>> p7 & 1L) << j + 7;
            }
            z[i] = z_i;
        }
        int n2 = this.size - 1;
        z[n2] = z[n2] & -1L >>> -r;
    }

    private static int generateHalfPower(int r, int r32, int n) {
        int k;
        int p = 1;
        for (k = n; k >= 32; k -= 32) {
            int y = r32 * p;
            long t = ((long)y & 0xFFFFFFFFL) * (long)r;
            long u = t + (long)p;
            p = (int)(u >>> 32);
        }
        if (k > 0) {
            int mk = -1 >>> -k;
            int y = r32 * p & mk;
            long t = ((long)y & 0xFFFFFFFFL) * (long)r;
            long u = t + (long)p;
            p = (int)(u >>> k);
        }
        return p;
    }

    private static void generateHalfPowersInv(Map<Integer, Integer> halfPowers, int r) {
        int rSub2 = r - 2;
        int bits = 32 - Integers.numberOfLeadingZeros(rSub2);
        int r32 = Mod.inverse32(-r);
        for (int i = 1; i < bits; ++i) {
            int n;
            int m = 1 << i - 1;
            if (m >= 64 && !halfPowers.containsKey(Integers.valueOf(m))) {
                halfPowers.put(Integers.valueOf(m), Integers.valueOf(BIKERing.generateHalfPower(r, r32, m)));
            }
            if ((rSub2 & 1 << i) == 0 || (n = rSub2 & (1 << i) - 1) < 64 || halfPowers.containsKey(Integers.valueOf(n))) continue;
            halfPowers.put(Integers.valueOf(n), Integers.valueOf(BIKERing.generateHalfPower(r, r32, n)));
        }
    }

    private static void implMulwAcc(long[] u, long x, long y, long[] z, int zOff) {
        u[1] = y;
        for (int i = 2; i < 16; i += 2) {
            u[i] = u[i >>> 1] << 1;
            u[i + 1] = u[i] ^ y;
        }
        int j = (int)x;
        long h = 0L;
        long l = u[j & 0xF] ^ u[j >>> 4 & 0xF] << 4;
        int k = 56;
        do {
            j = (int)(x >>> k);
            long g = u[j & 0xF] ^ u[j >>> 4 & 0xF] << 4;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 8) > 0);
        for (int p = 0; p < 7; ++p) {
            x = (x & 0xFEFEFEFEFEFEFEFEL) >>> 1;
            h ^= x & y << p >> 63;
        }
        int n = zOff;
        z[n] = z[n] ^ l;
        int n2 = zOff + 1;
        z[n2] = z[n2] ^ h;
    }

    private void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x, 0, this.size, zz, 0);
    }
}

