/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.protocol;

import java.io.IOException;
import org.apache.camel.component.as2.api.util.AS2Utils;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;

public class RequestAsynchronousMDN
implements HttpRequestInterceptor {
    private final String as2Version;
    private final String senderFQDN;

    public RequestAsynchronousMDN(String as2Version, String senderFQDN) {
        this.as2Version = as2Version;
        this.senderFQDN = senderFQDN;
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        request.addHeader("MIME-Version", "1.0");
        request.addHeader("AS2-Version", this.as2Version);
        request.addHeader("Message-Id", AS2Utils.createMessageId(this.senderFQDN));
        String recipientAddress = coreContext.getAttribute("camel-as2.async-mdn.recipient-address", String.class);
        request.addHeader("Recipient-Address", recipientAddress);
    }
}

