/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeCompressedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeEnvelopedDataEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.exception.AS2AuthenticationException;
import org.apache.camel.component.as2.api.exception.AS2DecryptionException;
import org.apache.camel.component.as2.api.exception.AS2InsufficientSecurityException;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.MessageSupport;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;

public final class HttpMessageUtils {
    private HttpMessageUtils() {
    }

    public static String getHeaderValue(HttpMessage message, String headerName) {
        Header header = message.getFirstHeader(headerName);
        return header == null ? null : header.getValue();
    }

    public static void setHeaderValue(HttpMessage message, String headerName, String headerValue) {
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(headerName, "headerName");
        if (headerValue == null) {
            message.removeHeaders(headerName);
        } else {
            message.setHeader(headerName, headerValue);
        }
    }

    public static <T> T getEntity(HttpMessage message, Class<T> type) {
        BasicClassicHttpResponse httpResponse;
        HttpEntity entity;
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(type, "type");
        if (message instanceof BasicClassicHttpRequest) {
            BasicClassicHttpRequest httpEntityEnclosingRequest = (BasicClassicHttpRequest)message;
            HttpEntity entity2 = httpEntityEnclosingRequest.getEntity();
            if (entity2 != null && type.isInstance(entity2)) {
                return type.cast(entity2);
            }
        } else if (message instanceof BasicClassicHttpResponse && (entity = (httpResponse = (BasicClassicHttpResponse)message).getEntity()) != null && type.isInstance(entity)) {
            type.cast(entity);
        }
        return null;
    }

    public static String getParameterValue(HttpMessage message, String headerName, String parameterName) {
        ObjectHelper.notNull(message, "message");
        ObjectHelper.notNull(headerName, "headerName");
        ObjectHelper.notNull(parameterName, "parameterName");
        Header header = message.getFirstHeader(headerName);
        if (header == null) {
            return null;
        }
        for (HeaderElement headerElement : MessageSupport.parse(header)) {
            for (NameValuePair nameValuePair : headerElement.getParameters()) {
                if (!nameValuePair.getName().equalsIgnoreCase(parameterName)) continue;
                return nameValuePair.getValue();
            }
        }
        return null;
    }

    public static ApplicationEntity extractEdiPayload(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        String contentTypeString = HttpMessageUtils.getHeaderValue(message, "Content-Type");
        if (contentTypeString == null) {
            throw new HttpException("Failed to create MIC: content type missing from request");
        }
        ContentType contentType = ContentType.parse(contentTypeString);
        EntityParser.parseAS2MessageEntity(message);
        return switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact", "application/edi-x12", "application/edi-consent" -> {
                if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null) {
                    throw new AS2InsufficientSecurityException("Failed to validate the signature");
                }
                if (decrpytingAndSigningInfo.getDecryptingPrivateKey() != null) {
                    throw new AS2InsufficientSecurityException("Expected to be encrypted");
                }
                yield HttpMessageUtils.getEntity(message, ApplicationEntity.class);
            }
            case "multipart/signed" -> {
                if (decrpytingAndSigningInfo.getDecryptingPrivateKey() != null) {
                    throw new AS2InsufficientSecurityException("Expected to be encrypted");
                }
                yield HttpMessageUtils.extractMultipartSigned(message, decrpytingAndSigningInfo);
            }
            case "application/pkcs7-mime" -> {
                switch (contentType.getParameter("smime-type")) {
                    case "compressed-data": {
                        if (decrpytingAndSigningInfo.getDecryptingPrivateKey() != null) {
                            throw new AS2InsufficientSecurityException("Expected to be encrypted");
                        }
                        yield HttpMessageUtils.extractCompressedData(message, decrpytingAndSigningInfo);
                    }
                    case "enveloped-data": {
                        yield HttpMessageUtils.extractEnvelopedData(message, decrpytingAndSigningInfo);
                    }
                }
                throw new HttpException("Failed to extract EDI message: unknown application/pkcs7-mime smime-type: " + contentType.getParameter("smime-type"));
            }
            default -> throw new HttpException("Failed to extract EDI message: invalid content type '" + contentType.getMimeType() + "' for AS2 request message");
        };
    }

    private static ApplicationEntity extractEnvelopedData(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        if (decrpytingAndSigningInfo.getDecryptingPrivateKey() == null) {
            throw new AS2DecryptionException("Failed to extract EDI payload: private key can not be null for AS2 enveloped message");
        }
        ApplicationPkcs7MimeEnvelopedDataEntity envelopedDataEntity = HttpMessageUtils.getEntity(message, ApplicationPkcs7MimeEnvelopedDataEntity.class);
        Objects.requireNonNull(envelopedDataEntity, "Failed to extract EDI payload: the enveloped data entity is null");
        ApplicationEntity ediEntity = HttpMessageUtils.extractEdiPayloadFromEnvelopedEntity(envelopedDataEntity, decrpytingAndSigningInfo);
        return ediEntity;
    }

    private static ApplicationEntity extractCompressedData(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = HttpMessageUtils.getEntity(message, ApplicationPkcs7MimeCompressedDataEntity.class);
        Objects.requireNonNull(compressedDataEntity, "Failed to extract the EDI payload: the compressed data entity is null");
        ApplicationEntity ediEntity = HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo, false);
        return ediEntity;
    }

    private static ApplicationEntity extractMultipartSigned(HttpMessage message, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        ApplicationEntity ediEntity;
        MultipartSignedEntity multipartSignedEntity = HttpMessageUtils.getEntity(message, MultipartSignedEntity.class);
        Objects.requireNonNull(multipartSignedEntity, "Failed to extract EDI payload: the multipart signed entity is null");
        if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null && !SigningUtils.isValid(multipartSignedEntity, decrpytingAndSigningInfo.getValidateSigningCertificateChain())) {
            throw new AS2AuthenticationException("Failed to validate the signature");
        }
        MimeEntity mimeEntity = multipartSignedEntity.getSignedDataEntity();
        if (mimeEntity instanceof ApplicationEntity) {
            ediEntity = (ApplicationEntity)mimeEntity;
        } else if (mimeEntity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
            ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)mimeEntity;
            ediEntity = HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo, true);
        } else {
            throw new HttpException("Failed to extract EDI payload: invalid content type '" + mimeEntity.getContentType() + "' for AS2 compressed and signed message");
        }
        return ediEntity;
    }

    private static ApplicationEntity extractEdiPayloadFromEnvelopedEntity(ApplicationPkcs7MimeEnvelopedDataEntity envelopedDataEntity, DecrpytingAndSigningInfo decrpytingAndSigningInfo) throws HttpException {
        MimeEntity entity = envelopedDataEntity.getEncryptedEntity(decrpytingAndSigningInfo.getDecryptingPrivateKey());
        String contentTypeString = entity.getContentType();
        if (contentTypeString == null) {
            throw new HttpException("Failed to extract EDI message: content type missing from encrypted entity");
        }
        ContentType contentType = ContentType.parse(contentTypeString);
        return switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact", "application/edi-x12", "application/edi-consent" -> {
                if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null) {
                    throw new AS2InsufficientSecurityException("Failed to validate the signature");
                }
                yield (ApplicationEntity)entity;
            }
            case "multipart/signed" -> {
                MultipartSignedEntity multipartSignedEntity = (MultipartSignedEntity)entity;
                if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null && !SigningUtils.isValid(multipartSignedEntity, decrpytingAndSigningInfo.getValidateSigningCertificateChain())) {
                    throw new AS2AuthenticationException("Failed to validate the signature");
                }
                MimeEntity mimeEntity = multipartSignedEntity.getSignedDataEntity();
                if (mimeEntity instanceof ApplicationEntity) {
                    yield (ApplicationEntity)mimeEntity;
                }
                if (mimeEntity instanceof ApplicationPkcs7MimeCompressedDataEntity) {
                    ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)mimeEntity;
                    yield HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo, true);
                }
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + mimeEntity.getContentType() + "' for AS2 compressed and signed entity");
            }
            case "application/pkcs7-mime" -> {
                if (!"compressed-data".equals(contentType.getParameter("smime-type"))) {
                    throw new HttpException("Failed to extract EDI payload: invalid mime type '" + contentType.getParameter("smime-type") + "' for AS2 enveloped entity");
                }
                ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity = (ApplicationPkcs7MimeCompressedDataEntity)entity;
                yield HttpMessageUtils.extractEdiPayloadFromCompressedEntity(compressedDataEntity, decrpytingAndSigningInfo, false);
            }
            default -> throw new HttpException("Failed to extract EDI payload: invalid content type '" + contentType.getMimeType() + "' for AS2 enveloped entity");
        };
    }

    public static ApplicationEntity extractEdiPayloadFromCompressedEntity(ApplicationPkcs7MimeCompressedDataEntity compressedDataEntity, DecrpytingAndSigningInfo decrpytingAndSigningInfo, boolean hasValidSignature) throws HttpException {
        MimeEntity entity = compressedDataEntity.getCompressedEntity(new ZlibExpanderProvider());
        String contentTypeString = entity.getContentType();
        if (contentTypeString == null) {
            throw new HttpException("Failed to extract EDI payload: content type missing from compressed entity");
        }
        ContentType contentType = ContentType.parse(contentTypeString);
        return switch (contentType.getMimeType().toLowerCase()) {
            case "application/edifact", "application/edi-x12", "application/edi-consent" -> {
                if (!hasValidSignature && decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null) {
                    throw new AS2InsufficientSecurityException("Failed to validate the signature");
                }
                yield (ApplicationEntity)entity;
            }
            case "multipart/signed" -> {
                MultipartSignedEntity multipartSignedEntity = (MultipartSignedEntity)entity;
                if (decrpytingAndSigningInfo.getValidateSigningCertificateChain() != null && !SigningUtils.isValid(multipartSignedEntity, decrpytingAndSigningInfo.getValidateSigningCertificateChain())) {
                    throw new AS2AuthenticationException("Failed to validate the signature");
                }
                MimeEntity mimeEntity = multipartSignedEntity.getSignedDataEntity();
                if (mimeEntity instanceof ApplicationEntity) {
                    ApplicationEntity applicationEntity;
                    yield applicationEntity = (ApplicationEntity)mimeEntity;
                }
                throw new HttpException("Failed to extract EDI payload: invalid content type '" + mimeEntity.getContentType() + "' for AS2 compressed and signed entity");
            }
            default -> throw new HttpException("Failed to extract EDI payload: invalid content type '" + contentType.getMimeType() + "' for AS2 compressed entity");
        };
    }

    public static class DecrpytingAndSigningInfo {
        private final Certificate[] validateSigningCertificateChain;
        private final PrivateKey decryptingPrivateKey;

        public DecrpytingAndSigningInfo(Certificate[] validateSigningCertificateChain, PrivateKey decryptingPrivateKey) {
            this.validateSigningCertificateChain = validateSigningCertificateChain;
            this.decryptingPrivateKey = decryptingPrivateKey;
        }

        public Certificate[] getValidateSigningCertificateChain() {
            return this.validateSigningCertificateChain;
        }

        public PrivateKey getDecryptingPrivateKey() {
            return this.decryptingPrivateKey;
        }
    }
}

