/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider;

import java.security.InvalidKeyException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;

/*
 * Exception performing whole class analysis ignored.
 */
public class Util {
    public static byte[] makeKeyBytes(KTSParameterSpec ktsSpec, byte[] secret) throws InvalidKeyException {
        AlgorithmIdentifier kdfAlgorithm = ktsSpec.getKdfAlgorithm();
        byte[] otherInfo = ktsSpec.getOtherInfo();
        byte[] keyBytes = new byte[(ktsSpec.getKeySize() + 7) / 8];
        if (X9ObjectIdentifiers.id_kdf_kdf2.equals(kdfAlgorithm.getAlgorithm())) {
            AlgorithmIdentifier digAlg = AlgorithmIdentifier.getInstance(kdfAlgorithm.getParameters());
            KDF2BytesGenerator kdf = new KDF2BytesGenerator(Util.getDigest((ASN1ObjectIdentifier)digAlg.getAlgorithm()));
            kdf.init(new KDFParameters(secret, otherInfo));
            kdf.generateBytes(keyBytes, 0, keyBytes.length);
        } else if (X9ObjectIdentifiers.id_kdf_kdf3.equals(kdfAlgorithm.getAlgorithm())) {
            AlgorithmIdentifier digAlg = AlgorithmIdentifier.getInstance(kdfAlgorithm.getParameters());
            ConcatenationKDFGenerator kdf = new ConcatenationKDFGenerator(Util.getDigest((ASN1ObjectIdentifier)digAlg.getAlgorithm()));
            kdf.init(new KDFParameters(secret, otherInfo));
            kdf.generateBytes(keyBytes, 0, keyBytes.length);
        } else if (NISTObjectIdentifiers.id_shake256.equals(kdfAlgorithm.getAlgorithm())) {
            SHAKEDigest xof = new SHAKEDigest(256);
            xof.update(secret, 0, secret.length);
            xof.update(otherInfo, 0, otherInfo.length);
            xof.doFinal(keyBytes, 0, keyBytes.length);
        } else {
            throw new InvalidKeyException("Unrecognized KDF: " + String.valueOf(kdfAlgorithm.getAlgorithm()));
        }
        return keyBytes;
    }

    static Digest getDigest(ASN1ObjectIdentifier oid) {
        if (oid.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (oid.equals(NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        if (oid.equals(NISTObjectIdentifiers.id_shake128)) {
            return new SHAKEDigest(128);
        }
        if (oid.equals(NISTObjectIdentifiers.id_shake256)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + String.valueOf(oid));
    }
}

