/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.ntruprime;

import java.security.InvalidKeyException;
import java.util.Objects;
import javax.crypto.DecapsulateException;
import javax.crypto.KEMSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import org.bouncycastle.pqc.jcajce.provider.Util;
import org.bouncycastle.pqc.jcajce.provider.ntruprime.BCSNTRUPrimePrivateKey;
import org.bouncycastle.util.Arrays;

class SNTRUPrimeDecapsulatorSpi
implements KEMSpi.DecapsulatorSpi {
    BCSNTRUPrimePrivateKey privateKey;
    KTSParameterSpec parameterSpec;
    SNTRUPrimeKEMExtractor kemExt;

    public SNTRUPrimeDecapsulatorSpi(BCSNTRUPrimePrivateKey privateKey, KTSParameterSpec parameterSpec) {
        this.privateKey = privateKey;
        this.parameterSpec = parameterSpec;
        this.kemExt = new SNTRUPrimeKEMExtractor(privateKey.getKeyParams());
    }

    @Override
    public SecretKey engineDecapsulate(byte[] encapsulation, int from, int to, String algorithm) throws DecapsulateException {
        Objects.checkFromToIndex(from, to, this.engineSecretSize());
        Objects.requireNonNull(algorithm, "null algorithm");
        Objects.requireNonNull(encapsulation, "null encapsulation");
        if (encapsulation.length != this.engineEncapsulationSize()) {
            throw new DecapsulateException("incorrect encapsulation size");
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && algorithm.equals("Generic")) {
            algorithm = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(algorithm)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + algorithm);
        }
        boolean useKDF = this.parameterSpec.getKdfAlgorithm() != null;
        byte[] secret = this.kemExt.extractSecret(encapsulation);
        if (useKDF) {
            try {
                secret = Util.makeKeyBytes((KTSParameterSpec)this.parameterSpec, (byte[])secret);
            }
            catch (InvalidKeyException e) {
                throw new IllegalStateException(e);
            }
        }
        byte[] secretKey = Arrays.copyOfRange(secret, from, to);
        return new SecretKeySpec(secretKey, algorithm);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        return this.kemExt.getEncapsulationLength();
    }
}

