/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.camel.component.as2.api.io.AS2BHttpServerConnection;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.RequestValidateHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2AsyncMDNServerConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AS2AsyncMDNServerConnection.class);
    private static final String REQUEST_LISTENER_THREAD_NAME_PREFIX = "AS2AsyncMdnSvr-";
    private static final String REQUEST_HANDLER_THREAD_NAME_PREFIX = "AS2AsyncMdnHdlr-";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private RequestListenerThread listenerThread;
    private final Lock lock = new ReentrantLock();

    public AS2AsyncMDNServerConnection(Integer portNumber, SSLContext sslContext) throws IOException {
        Integer parserPortNumber = ObjectHelper.notNull(portNumber, "portNumber");
        this.listenerThread = new RequestListenerThread(parserPortNumber, sslContext);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public void close() {
        if (this.listenerThread != null) {
            this.lock.lock();
            try {
                try {
                    this.listenerThread.serverSocket.close();
                }
                catch (IOException e) {
                    LOG.info(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.listenerThread = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void receive(String requestUriPattern, HttpRequestHandler handler) {
        if (this.listenerThread != null) {
            this.lock.lock();
            try {
                this.listenerThread.registerHandler(requestUriPattern, handler);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    class RequestListenerThread
    extends Thread {
        private final ServerSocket serverSocket;
        private final HttpService httpService;
        private final RequestHandlerRegistry registry;
        private final HttpServerRequestHandler handler;

        public RequestListenerThread(int port, SSLContext sslContext) throws IOException {
            this.setName(AS2AsyncMDNServerConnection.REQUEST_LISTENER_THREAD_NAME_PREFIX + port);
            if (sslContext == null) {
                this.serverSocket = new ServerSocket(port);
            } else {
                SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
                this.serverSocket = factory.createServerSocket(port);
            }
            DefaultHttpProcessor httpProcessor = new DefaultHttpProcessor(new RequestValidateHost());
            this.registry = new RequestHandlerRegistry();
            this.handler = new BasicHttpServerRequestHandler(this.registry);
            this.httpService = new HttpService(httpProcessor, this.handler);
        }

        @Override
        public void run() {
            LOG.info("Listening on port {}", (Object)this.serverSocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    Socket inSocket = this.serverSocket.accept();
                    RequestHandlerThread t = new RequestHandlerThread(this.httpService, inSocket);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException | SocketException ex) {
                    break;
                }
                catch (IOException e) {
                    LOG.error("I/O error initialising connection thread: {}", (Object)e.getMessage());
                    break;
                }
            }
        }

        void registerHandler(String requestUriPattern, HttpRequestHandler httpRequestHandler) {
            this.registry.register(null, requestUriPattern, httpRequestHandler);
        }
    }

    class RequestHandlerThread
    extends Thread {
        private final HttpService httpService;
        private final HttpServerConnection serverConnection;

        public RequestHandlerThread(HttpService httpService, Socket inSocket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incoming connection from {}", (Object)inSocket.getInetAddress());
            }
            Http1Config cfg = Http1Config.custom().setBufferSize(8192).build();
            AS2BHttpServerConnection inConn = new AS2BHttpServerConnection(cfg);
            inConn.bind(inSocket);
            this.setName(AS2AsyncMDNServerConnection.REQUEST_HANDLER_THREAD_NAME_PREFIX + this.getId());
            this.httpService = httpService;
            this.serverConnection = inConn;
        }

        @Override
        public void run() {
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (!Thread.interrupted()) {
                    this.httpService.handleRequest(this.serverConnection, context);
                }
            }
            catch (IOException ex) {
                LOG.error("I/O exception: {}", (Object)ex.getMessage(), (Object)ex);
            }
            catch (HttpException ex) {
                LOG.error("Unrecoverable HTTP protocol violation: {}", (Object)ex.getMessage(), (Object)ex);
            }
            finally {
                try {
                    this.serverConnection.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

